/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.newsreader.spring;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.jasig.portlet.newsreader.spring.LazyInitByDefaultBeanDefinitionDocumentReader;
import org.jasig.portlet.newsreader.spring.SingletonDoubleCheckedCreator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class PortletApplicationContextLocator
implements ServletContextListener {
    private static Logger LOGGER = LoggerFactory.getLogger(PortletApplicationContextLocator.class);
    private static final SingletonDoubleCheckedCreator<ConfigurableApplicationContext> applicationContextCreator = new PortletApplicationContextCreator();
    public static final String DATABASE_CONTEXT_LOCATION = "classpath:/context/importExportContext.xml";
    private static Throwable directCreatorThrowable;
    private static ServletContext servletContext;

    public void contextInitialized(ServletContextEvent sce) {
        servletContext = sce.getServletContext();
    }

    public void contextDestroyed(ServletContextEvent sce) {
        servletContext = null;
    }

    @Deprecated
    public static boolean isRunningInWebApplication() {
        return servletContext != null;
    }

    @Deprecated
    public static WebApplicationContext getRequiredWebApplicationContext() {
        ServletContext context = servletContext;
        if (context == null) {
            throw new IllegalStateException("No ServletContext is available to load a WebApplicationContext for. Is this ServletContextListener not configured or has the ServletContext been destroyed?");
        }
        return WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)context);
    }

    @Deprecated
    public static WebApplicationContext getWebApplicationContext() {
        ServletContext context = servletContext;
        if (context == null) {
            return null;
        }
        return WebApplicationContextUtils.getWebApplicationContext((ServletContext)context);
    }

    public static ApplicationContext getApplicationContext(String importExportContextFile) {
        ServletContext context = servletContext;
        if (context != null) {
            LOGGER.debug("Using WebApplicationContext");
            if (applicationContextCreator.isCreated()) {
                IllegalStateException createException = new IllegalStateException("A portal managed ApplicationContext has already been created but now a ServletContext is available and a WebApplicationContext will be returned. This situation should be resolved by delaying calls to this class until after the web-application has completely initialized.");
                LOGGER.error("Application context found", (Throwable)createException);
                LOGGER.error("Stack trace of original ApplicationContext creator", directCreatorThrowable);
                throw createException;
            }
            WebApplicationContext webApplicationContext = WebApplicationContextUtils.getWebApplicationContext((ServletContext)context);
            if (webApplicationContext == null) {
                throw new IllegalStateException("ServletContext is available but WebApplicationContextUtils.getWebApplicationContext(ServletContext) returned null. Either the application context failed to load or is not yet done loading.");
            }
            return webApplicationContext;
        }
        return (ApplicationContext)applicationContextCreator.get(importExportContextFile);
    }

    public static void shutdown() {
        if (applicationContextCreator.isCreated()) {
            ConfigurableApplicationContext applicationContext = (ConfigurableApplicationContext)applicationContextCreator.get(new Object[0]);
            applicationContext.close();
        } else {
            IllegalStateException createException = new IllegalStateException("No portal managed ApplicationContext has been created, there is nothing to shutdown.");
            LOGGER.error("Application context should exist", (Throwable)createException);
        }
    }

    private static class PortletApplicationContextCreator
    extends SingletonDoubleCheckedCreator<ConfigurableApplicationContext> {
        private PortletApplicationContextCreator() {
        }

        @Override
        protected ConfigurableApplicationContext createSingleton(Object ... args) {
            LOGGER.info("Creating new lazily initialized GenericApplicationContext for the portal");
            long startTime = System.currentTimeMillis();
            GenericApplicationContext genericApplicationContext = new GenericApplicationContext();
            XmlBeanDefinitionReader reader = new XmlBeanDefinitionReader((BeanDefinitionRegistry)genericApplicationContext);
            reader.setDocumentReaderClass(LazyInitByDefaultBeanDefinitionDocumentReader.class);
            Resource resource = genericApplicationContext.getResource((String)args[0]);
            reader.loadBeanDefinitions(resource);
            genericApplicationContext.refresh();
            genericApplicationContext.registerShutdownHook();
            directCreatorThrowable = new Throwable();
            directCreatorThrowable.fillInStackTrace();
            LOGGER.info("Created new lazily initialized GenericApplicationContext for the portal in " + (System.currentTimeMillis() - startTime) + "ms");
            return genericApplicationContext;
        }
    }
}

