/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.newsreader.service;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import org.jasig.portlet.newsreader.dao.NewsStore;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RolesService {
    private static final String USER_ROLES_SESSION_ATTRIBUTE = RolesService.class.getName() + ".userRoles";
    @Autowired
    private NewsStore newsStore;

    public Set<String> getUserRoles(PortletRequest req) {
        PortletSession session = req.getPortletSession();
        HashSet<String> rslt = (HashSet<String>)session.getAttribute(USER_ROLES_SESSION_ATTRIBUTE);
        if (rslt == null) {
            rslt = new HashSet<String>();
            List<String> allRoles = this.newsStore.getUserRoles();
            for (String role : allRoles) {
                if (!req.isUserInRole(role)) continue;
                rslt.add(role);
            }
            session.setAttribute(USER_ROLES_SESSION_ATTRIBUTE, rslt, 2);
        }
        return rslt;
    }
}

