/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.newsreader.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import org.jasig.portlet.newsreader.NewsConfiguration;
import org.jasig.portlet.newsreader.PredefinedNewsConfiguration;
import org.jasig.portlet.newsreader.service.Whitelist;

public class NewsConfigurationWhitelist
extends Whitelist {
    public static final Whitelist.Callback<PredefinedNewsConfiguration> WHITELIST_CALLBACK = new /* Unavailable Anonymous Inner Class!! */;
    private static final String WHITELIST_USERFEEDS_PREFERENCE = "Whitelist.userFeeds";

    public List<NewsConfiguration> filter(PortletRequest req, Collection<NewsConfiguration> items) {
        ArrayList<NewsConfiguration> rslt = new ArrayList<NewsConfiguration>();
        for (NewsConfiguration config : items) {
            if (config.getNewsDefinition().isPredefined()) {
                PredefinedNewsConfiguration predef = (PredefinedNewsConfiguration)config;
                List filtered = super.filter(req, Collections.singleton(predef), WHITELIST_CALLBACK);
                if (filtered.size() == 0) continue;
                rslt.add(config);
                continue;
            }
            PortletPreferences prefs = req.getPreferences();
            String isWhitelistUserfeeds = prefs.getValue(WHITELIST_USERFEEDS_PREFERENCE, "true");
            if (!Boolean.valueOf(isWhitelistUserfeeds).booleanValue()) continue;
            rslt.add(config);
        }
        return rslt;
    }
}

