/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.newsreader.service;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.portlet.PortletRequest;
import org.apache.commons.codec.digest.DigestUtils;
import org.jasig.portlet.newsreader.service.RolesService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserIdService {
    private static final String GUEST_USER_ID_PREFIX = "g_";
    @Autowired
    private RolesService rolesService;
    private MessageDigest md5;

    @PostConstruct
    public void init() {
        try {
            this.md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            String msg = "Failed to create the MD5 MessageDigest";
            throw new RuntimeException("Failed to create the MD5 MessageDigest", e);
        }
    }

    public String getUserId(PortletRequest req) {
        String rslt = req.getRemoteUser() != null ? req.getRemoteUser() : this.calculateGuestUserIdHash(req);
        return rslt;
    }

    private String calculateGuestUserIdHash(PortletRequest req) {
        StringBuilder rolesString = new StringBuilder();
        Set<String> roles = this.rolesService.getUserRoles(req);
        ArrayList<String> sortedRoles = new ArrayList<String>(roles);
        Collections.sort(sortedRoles);
        for (String s : sortedRoles) {
            if (rolesString.length() != 0) {
                rolesString.append("-");
            }
            rolesString.append(s);
        }
        byte[] digest = this.md5.digest(rolesString.toString().getBytes());
        String hex = DigestUtils.md2Hex((byte[])digest);
        return GUEST_USER_ID_PREFIX + hex;
    }
}

