/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.newsreader.mvc.portlet.reader;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.jasig.portlet.newsreader.NewsConfiguration;
import org.jasig.portlet.newsreader.NewsSet;
import org.jasig.portlet.newsreader.adapter.INewsAdapter;
import org.jasig.portlet.newsreader.adapter.NewsException;
import org.jasig.portlet.newsreader.dao.NewsStore;
import org.jasig.portlet.newsreader.model.NewsFeedItem;
import org.jasig.portlet.newsreader.model.PaginatingNewsFeed;
import org.jasig.portlet.newsreader.mvc.AbstractNewsController;
import org.jasig.portlet.newsreader.service.NewsSetResolvingService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.portlet.ModelAndView;
import org.springframework.web.portlet.bind.annotation.ResourceMapping;

@Controller
@RequestMapping(value={"VIEW"})
public class AjaxNewsController {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private NewsStore newsStore;
    private NewsSetResolvingService setCreationService;
    private ApplicationContext applicationContext;

    @Autowired
    public void setNewsStore(NewsStore newsStore) {
        this.newsStore = newsStore;
    }

    @Autowired
    public void setSetCreationService(NewsSetResolvingService setCreationService) {
        this.setCreationService = setCreationService;
    }

    @Autowired
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @ResourceMapping
    public ModelAndView getJSONFeeds(ResourceRequest request, ResourceResponse response) throws Exception {
        HashMap<String, Object> model;
        block23: {
            String activeFeed;
            this.log.debug("handleAjaxRequestInternal (AjaxNewsController)");
            model = new HashMap<String, Object>();
            String feedView = request.getPreferences().getValue("feedView", null);
            this.log.debug("Feed view type is " + feedView);
            boolean getAllFeedItems = "all".equals(feedView);
            this.log.debug("Get all feed items is " + getAllFeedItems);
            String setName = request.getPreferences().getValue("newsSetName", "default");
            NewsSet set = this.setCreationService.getNewsSet(setName, (PortletRequest)request);
            List feeds = AbstractNewsController.filterNonWhitelistedConfigurations((PortletRequest)request, (Collection)set.getNewsConfigurations());
            Collections.sort(feeds);
            this.log.debug("Number of feeds found: " + feeds.size());
            JSONArray jsonFeeds = new JSONArray();
            ArrayList<String> knownFeeds = new ArrayList<String>();
            for (NewsConfiguration feed : feeds) {
                this.log.debug("Processing feed: " + feed.getNewsDefinition().getName());
                if (!getAllFeedItems && feed.getNewsDefinition().getName().equals("All")) {
                    feed.setDisplayed(false);
                }
                if (!feed.isDisplayed()) continue;
                JSONObject jsonFeed = new JSONObject();
                jsonFeed.put((Object)"id", (Object)feed.getId());
                jsonFeed.put((Object)"name", (Object)feed.getNewsDefinition().getName());
                jsonFeeds.add((Object)jsonFeed);
                knownFeeds.add(String.valueOf(feed.getId()));
                this.log.debug("Value of jsonFeed: " + jsonFeed);
            }
            model.put("feeds", jsonFeeds);
            PortletPreferences prefs = request.getPreferences();
            String activeateNews = request.getParameter("activeateNews");
            if (activeateNews != null) {
                prefs.setValue("activeFeed", activeateNews);
                prefs.store();
            }
            int page = 0;
            try {
                String pageParam = request.getParameter("page");
                page = pageParam == null ? 0 : Integer.parseInt(pageParam);
            }
            catch (Exception e) {
                this.log.warn("page parameter could not be parsed to int");
            }
            int maxStories = AbstractNewsController.getMaxStories((PortletPreferences)prefs);
            if (getAllFeedItems) {
                for (NewsConfiguration newsConfig : feeds) {
                    if (!newsConfig.getNewsDefinition().getName().equals("All")) continue;
                    prefs.setValue("activeFeed", newsConfig.getId().toString());
                    prefs.store();
                    break;
                }
            }
            if (!knownFeeds.contains(activeFeed = request.getPreferences().getValue("activeFeed", null))) {
                activeFeed = null;
            }
            if (activeFeed == null && jsonFeeds.size() > 0) {
                activeFeed = ((JSONObject)jsonFeeds.get(0)).getString("id");
                prefs.setValue("activeFeed", activeateNews);
                prefs.store();
            }
            if (activeFeed != null) {
                NewsConfiguration feedConfig = this.newsStore.getNewsConfiguration(Long.valueOf(activeFeed));
                model.put("activeFeed", feedConfig.getId());
                this.log.debug("On render Active feed is " + feedConfig.getId());
                model.put("page", page);
                try {
                    PaginatingNewsFeed sharedFeed;
                    if (getAllFeedItems) {
                        this.log.debug("Getting all feed items");
                        ArrayList allFeedItems = new ArrayList();
                        for (NewsConfiguration newsConfig : feeds) {
                            this.log.debug("Getting feed items for " + newsConfig.getNewsDefinition().getName());
                            if (newsConfig.getNewsDefinition().getName().equals("All") || !newsConfig.isDisplayed()) {
                                this.log.debug("Breaking out of for loop and not getting feed entries");
                                continue;
                            }
                            INewsAdapter adapter = (INewsAdapter)this.applicationContext.getBean(newsConfig.getNewsDefinition().getClassName());
                            feedConfig = this.newsStore.getNewsConfiguration(newsConfig.getId());
                            PaginatingNewsFeed feed = adapter.getSyndFeed(feedConfig, page, maxStories);
                            List feedItems = feed.getEntries();
                            this.log.debug("Number of feed entries for " + newsConfig.getNewsDefinition().getName() + " is " + feedItems.size());
                            for (int i = 0; i < feedItems.size(); ++i) {
                                allFeedItems.add(feedItems.get(i));
                            }
                        }
                        sharedFeed = new PaginatingNewsFeed(10);
                        Collections.sort(allFeedItems);
                        sharedFeed.setTitle("News Feed");
                        sharedFeed.setAuthor("Various");
                        Date year = new Date();
                        sharedFeed.setCopyright(Integer.toString(year.getYear()));
                        sharedFeed.setEntries(allFeedItems);
                        this.log.debug("TOTAL Number of feed items: " + sharedFeed.getEntries().size());
                    } else {
                        INewsAdapter adapter = (INewsAdapter)this.applicationContext.getBean(feedConfig.getNewsDefinition().getClassName());
                        sharedFeed = adapter.getSyndFeed(feedConfig, page, maxStories);
                    }
                    if (sharedFeed != null) {
                        List items = sharedFeed.getEntries();
                        for (int i = 0; i < items.size(); ++i) {
                            NewsFeedItem item = (NewsFeedItem)items.get(i);
                            if (item.getLink() != null || item.getFullStory() == null) continue;
                            PortletURL link = response.createRenderURL();
                            link.setParameter("action", "fullStory");
                            link.setParameter("activeFeed", feedConfig.getId().toString());
                            link.setParameter("itemIndex", String.valueOf(i));
                            link.setParameter("page", Integer.toString(page));
                            item.setLink(link.toString());
                        }
                        model.put("feed", sharedFeed);
                        model.put("maxPage", sharedFeed.getPageCount());
                        break block23;
                    }
                    this.log.warn("Failed to get feed from adapter.");
                    model.put("message", "The news \"" + feedConfig.getNewsDefinition().getName() + "\" is currently unavailable.");
                }
                catch (NoSuchBeanDefinitionException ex) {
                    this.log.error("News class instance could not be found: " + ex.getMessage());
                    model.put("message", "The news \"" + feedConfig.getNewsDefinition().getName() + "\" is currently unavailable.");
                }
                catch (NewsException ex) {
                    this.log.warn(ex.getMessage(), (Throwable)ex);
                    model.put("message", "The news \"" + feedConfig.getNewsDefinition().getName() + "\" is currently unavailable.");
                }
                catch (Exception ex) {
                    this.log.error(ex.getMessage(), (Throwable)ex);
                    model.put("message", "The news \"" + feedConfig.getNewsDefinition().getName() + "\" is currently unavailable.");
                }
            } else {
                model.put("message", "Select the news you wish to read.");
            }
        }
        this.log.debug("forwarding to /ajaxFeedList");
        String etag = String.valueOf(model.hashCode());
        String requestEtag = request.getETag();
        if (request.getETag() != null && etag.equals(requestEtag)) {
            response.getCacheControl().setExpirationTime(1);
            response.getCacheControl().setUseCachedContent(true);
            return new ModelAndView("empty", Collections.emptyMap());
        }
        response.getCacheControl().setETag(etag);
        response.getCacheControl().setExpirationTime(1);
        return new ModelAndView("json", model);
    }
}

