/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.newsreader.mvc;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.jasig.resourceserver.aggr.om.Included;
import org.jasig.resourceserver.utils.aggr.ResourcesElementsProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class AggregationAwareFilterBean
implements Filter {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Filter filter;
    private ResourcesElementsProvider elementsProvider;

    public void setFilter(Filter filter) {
        this.filter = filter;
    }

    @Autowired
    public void setElementsProvider(ResourcesElementsProvider elementsProvider) {
        this.elementsProvider = elementsProvider;
    }

    public void destroy() {
        this.filter.destroy();
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.filter.init(filterConfig);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.elementsProvider.getIncludedType((HttpServletRequest)request) == Included.AGGREGATED) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Aggregation enabled, delegating to filter: " + this.filter);
            }
            this.filter.doFilter(request, response, chain);
        } else {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Aggregation disabled, skipping filter: " + this.filter);
            }
            chain.doFilter(request, response);
        }
    }
}

