/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.newsreader.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.DefaultHttpClient;
import org.jasig.portlet.newsreader.adapter.NewsException;
import org.jasig.portlet.newsreader.model.FullStory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteHttpFullStory
implements FullStory {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private final String remoteHttpUrl;

    @JsonCreator
    public RemoteHttpFullStory(@JsonProperty(value="remoteHttpUrl") String remoteHttpUrl) {
        this.remoteHttpUrl = remoteHttpUrl;
    }

    public String getRemoteHttpUrl() {
        return this.remoteHttpUrl;
    }

    @JsonIgnore
    public String getFullStoryText() {
        try {
            return this.fetchRemoteContent();
        }
        catch (Exception ex) {
            throw new NewsException("Failed to fetch FullStory content from " + this.remoteHttpUrl, (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String fetchRemoteContent() throws ClientProtocolException, IOException {
        this.log.trace("RemoteHttpFullStory.fetchRemoteContent()");
        DefaultHttpClient httpclient = new DefaultHttpClient();
        try {
            String responseBody;
            HttpGet httpget = new HttpGet(this.remoteHttpUrl);
            this.log.debug("executing request " + httpget.getURI());
            BasicResponseHandler responseHandler = new BasicResponseHandler();
            String string = responseBody = (String)httpclient.execute((HttpUriRequest)httpget, (ResponseHandler)responseHandler);
            return string;
        }
        finally {
            httpclient.getConnectionManager().shutdown();
        }
    }
}

