/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.newsreader.dao;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.jasig.portlet.newsreader.NewsConfiguration;
import org.jasig.portlet.newsreader.NewsDefinition;
import org.jasig.portlet.newsreader.NewsSet;
import org.jasig.portlet.newsreader.PredefinedNewsConfiguration;
import org.jasig.portlet.newsreader.PredefinedNewsDefinition;
import org.jasig.portlet.newsreader.UserDefinedNewsConfiguration;
import org.jasig.portlet.newsreader.dao.NewsStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

public class HibernateNewsStore
extends HibernateDaoSupport
implements NewsStore {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public void storeNewsDefinition(NewsDefinition listing) {
        try {
            this.getHibernateTemplate().saveOrUpdate((Object)listing);
            this.getHibernateTemplate().flush();
        }
        catch (HibernateException ex) {
            throw this.convertHibernateAccessException(ex);
        }
    }

    public void storeNewsConfiguration(NewsConfiguration configuration) {
        try {
            this.getHibernateTemplate().saveOrUpdate((Object)configuration);
            this.getHibernateTemplate().flush();
        }
        catch (HibernateException ex) {
            throw this.convertHibernateAccessException(ex);
        }
    }

    public List<NewsConfiguration> getNewsConfigurations(String subscribeId) {
        try {
            this.logger.debug("fetching news configurations for " + subscribeId);
            return this.getHibernateTemplate().find("FROM NewsConfiguration config WHERE subscribeId = ? AND displayed = true ORDER BY newsDefinition.name", (Object)subscribeId);
        }
        catch (HibernateException ex) {
            throw this.convertHibernateAccessException(ex);
        }
    }

    public List<UserDefinedNewsConfiguration> getUserDefinedNewsConfigurations(Long setId, boolean visibleOnly) {
        try {
            String query = "FROM NewsConfiguration config WHERE config.newsSet.id = ? AND config.class = UserDefinedNewsConfiguration ORDER BY newsDefinition.name";
            if (visibleOnly) {
                query = query.concat(" AND visibleOnly = true");
            }
            return this.getHibernateTemplate().find(query, (Object)setId);
        }
        catch (HibernateException ex) {
            throw this.convertHibernateAccessException(ex);
        }
    }

    public List<PredefinedNewsConfiguration> getPredefinedNewsConfigurations(Long setId, boolean visibleOnly) {
        try {
            String query = "FROM NewsConfiguration config WHERE config.newsSet.id = ? AND config.class = PredefinedNewsConfiguration ORDER BY newsDefinition.name";
            if (visibleOnly) {
                query = query.concat(" AND visibleOnly = true");
            }
            return this.getHibernateTemplate().find(query, (Object)setId);
        }
        catch (HibernateException ex) {
            throw this.convertHibernateAccessException(ex);
        }
    }

    public List<PredefinedNewsConfiguration> getPredefinedNewsConfigurations() {
        try {
            String query = "FROM NewsDefinition def WHERE def.class = PredefinedNewsDefinition ORDER BY def.name";
            return this.getHibernateTemplate().find(query);
        }
        catch (HibernateException ex) {
            throw this.convertHibernateAccessException(ex);
        }
    }

    public List<PredefinedNewsDefinition> getHiddenPredefinedNewsDefinitions(Long setId, Set<String> roles) {
        try {
            String query = "FROM PredefinedNewsDefinition def WHERE NOT EXISTS (FROM def.userConfigurations config WHERE config.newsSet.id = :setId) ";
            for (int i = 0; i < roles.size(); ++i) {
                query = query.concat("AND :role" + i + " NOT IN elements(def.defaultRoles) ");
            }
            Query q = this.getSession().createQuery(query);
            q.setLong("setId", setId.longValue());
            int count = 0;
            for (String role : roles) {
                q.setString("role" + count, role);
                ++count;
            }
            return q.list();
        }
        catch (HibernateException ex) {
            throw this.convertHibernateAccessException(ex);
        }
    }

    public void initNews(NewsSet set, Set<String> roles) {
        try {
            if (roles.isEmpty()) {
                return;
            }
            String query = "FROM PredefinedNewsDefinition def LEFT JOIN FETCH def.defaultRoles role  WHERE NOT EXISTS (FROM def.userConfigurations config WHERE config.newsSet.id = :setId) AND role IN (:roles)";
            String[] params = new String[]{"setId", "roles"};
            Object[] values = new Object[]{set.getId(), roles};
            List defs = this.getHibernateTemplate().findByNamedParam(query, params, values);
            this.logger.debug("Found the following PredefinedNewsDefinition objects for NewsSet={} and roles={}:  {}", new Object[]{set.getName(), roles, defs});
            for (PredefinedNewsDefinition def : defs) {
                PredefinedNewsConfiguration config = new PredefinedNewsConfiguration();
                config.setNewsDefinition((NewsDefinition)def);
                set.addNewsConfiguration((NewsConfiguration)config);
            }
        }
        catch (HibernateException ex) {
            throw this.convertHibernateAccessException(ex);
        }
    }

    public PredefinedNewsDefinition getPredefinedNewsDefinition(Long id) {
        try {
            String query = "FROM PredefinedNewsDefinition def LEFT JOIN FETCH def.defaultRoles role WHERE def.id = :id";
            Query q = this.getSession().createQuery(query);
            q.setLong("id", id.longValue());
            return (PredefinedNewsDefinition)q.uniqueResult();
        }
        catch (HibernateException ex) {
            throw this.convertHibernateAccessException(ex);
        }
    }

    public PredefinedNewsDefinition getPredefinedNewsDefinitionByName(String name) {
        try {
            String query = "FROM PredefinedNewsDefinition def LEFT JOIN FETCH def.defaultRoles role WHERE def.name = :name";
            Query q = this.getSession().createQuery(query);
            q.setString("name", name);
            return (PredefinedNewsDefinition)q.uniqueResult();
        }
        catch (HibernateException ex) {
            throw this.convertHibernateAccessException(ex);
        }
    }

    public NewsDefinition getNewsDefinition(Long id) {
        try {
            return (NewsDefinition)this.getHibernateTemplate().get(NewsDefinition.class, (Serializable)id);
        }
        catch (HibernateException ex) {
            throw this.convertHibernateAccessException(ex);
        }
    }

    public NewsConfiguration getNewsConfiguration(Long id) {
        try {
            return (NewsConfiguration)this.getHibernateTemplate().load(NewsConfiguration.class, (Serializable)id);
        }
        catch (HibernateException ex) {
            throw this.convertHibernateAccessException(ex);
        }
    }

    public void deleteNewsConfiguration(NewsConfiguration configuration) {
        try {
            this.getHibernateTemplate().delete((Object)configuration);
            this.getHibernateTemplate().flush();
        }
        catch (HibernateException ex) {
            throw this.convertHibernateAccessException(ex);
        }
    }

    public void deleteNewsDefinition(PredefinedNewsDefinition definition) {
        try {
            String query = "FROM NewsConfiguration config WHERE config.newsDefinition.id = ? AND config.class = PredefinedNewsConfiguration";
            List configs = this.getHibernateTemplate().find(query, (Object)definition.getId());
            this.getHibernateTemplate().deleteAll((Collection)configs);
            this.getHibernateTemplate().delete((Object)definition);
            this.getHibernateTemplate().flush();
        }
        catch (HibernateException ex) {
            throw this.convertHibernateAccessException(ex);
        }
    }

    public List<String> getUserRoles() {
        try {
            String query = "SELECT DISTINCT elements(def.defaultRoles) FROM PredefinedNewsDefinition def ";
            return this.getHibernateTemplate().find(query);
        }
        catch (HibernateException ex) {
            throw this.convertHibernateAccessException(ex);
        }
    }

    public NewsSet getNewsSet(Long id) {
        try {
            return (NewsSet)this.getHibernateTemplate().get(NewsSet.class, (Serializable)id);
        }
        catch (HibernateException ex) {
            throw this.convertHibernateAccessException(ex);
        }
    }

    public List<NewsSet> getNewsSetsForUser(String userId) {
        try {
            this.logger.debug("fetching news sets for " + userId);
            return this.getHibernateTemplate().find("FROM NewsSet newsSet WHERE newsSet.userId = ? ORDER BY newsSet.name", (Object)userId);
        }
        catch (HibernateException ex) {
            throw this.convertHibernateAccessException(ex);
        }
    }

    public void storeNewsSet(NewsSet set) {
        try {
            this.getHibernateTemplate().saveOrUpdate((Object)set);
            this.getHibernateTemplate().flush();
        }
        catch (HibernateException ex) {
            throw this.convertHibernateAccessException(ex);
        }
    }

    public NewsSet getNewsSet(String userId, String setName) {
        try {
            this.logger.debug("fetching news sets for " + userId);
            String query = "FROM NewsSet newsSet WHERE :userId = newsSet.userId AND :setName = newsSet.name ORDER BY newsSet.name";
            Query q = this.getSession().createQuery(query);
            q.setString("userId", userId);
            q.setString("setName", setName);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(this.getSessionFactory().getStatistics().toString());
            }
            NewsSet set = (NewsSet)q.uniqueResult();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(this.getSessionFactory().getStatistics().toString());
            }
            return set;
        }
        catch (HibernateException ex) {
            throw this.convertHibernateAccessException(ex);
        }
    }
}

