/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.newsreader.service;

import java.util.Set;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import org.jasig.portlet.newsreader.NewsSet;
import org.jasig.portlet.newsreader.dao.NewsStore;
import org.jasig.portlet.newsreader.service.NewsSetResolvingService;
import org.jasig.portlet.newsreader.service.RolesService;
import org.jasig.portlet.newsreader.service.UserIdService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.portlet.util.PortletUtils;

@Service(value="setCreationService")
public class SharedNewsSetServiceImpl
implements NewsSetResolvingService {
    private NewsStore newsStore;
    @Autowired
    private UserIdService userIdService;
    @Autowired
    private RolesService rolesService;
    private Logger logger = LoggerFactory.getLogger(SharedNewsSetServiceImpl.class);

    @Autowired
    public void setNewsStore(NewsStore newsStore) {
        this.newsStore = newsStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NewsSet getNewsSet(String fname, PortletRequest request) {
        NewsSet set;
        Object mutex;
        PortletSession session = request.getPortletSession();
        String userId = this.userIdService.getUserId(request);
        Object object = mutex = PortletUtils.getSessionMutex((PortletSession)session);
        synchronized (object) {
            this.logger.debug("Got Mutex {} for userId={}", mutex, (Object)userId);
            set = this.newsStore.getNewsSet(userId, fname);
            if (set == null) {
                this.logger.debug("No existing set found for " + userId + ", creating and saving new set.");
                set = new NewsSet();
                set.setUserId(userId);
                set.setName(fname);
                this.newsStore.storeNewsSet(set);
                set = this.newsStore.getNewsSet(userId, fname);
            }
            if (session.getAttribute("setId", 2) == null) {
                if (set != null) {
                    this.logger.debug("re-initalising loaded newsSet " + set.getName());
                } else {
                    this.logger.debug("attempting to re-initialize loaded newsSet, but it is null");
                }
                Set<String> roles = this.rolesService.getUserRoles(request);
                if (roles != null) {
                    this.newsStore.initNews(set, roles);
                    this.newsStore.storeNewsSet(set);
                    session.setAttribute("setId", (Object)set.getId(), 2);
                }
            }
        }
        return set;
    }
}

