/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.newsreader.mvc.portlet.reader;

import java.util.HashMap;
import java.util.List;
import javax.portlet.ActionRequest;
import javax.portlet.PortletSecurityException;
import javax.portlet.RenderRequest;
import org.jasig.portlet.newsreader.PredefinedNewsDefinition;
import org.jasig.portlet.newsreader.dao.NewsStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.portlet.ModelAndView;
import org.springframework.web.portlet.bind.annotation.ActionMapping;
import org.springframework.web.portlet.bind.annotation.RenderMapping;

@Controller
@RequestMapping(value={"EDIT"})
public class AdminNewsController {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    @Autowired(required=true)
    private NewsStore newsStore;

    @RenderMapping(params={"action=administration"})
    public ModelAndView getAdminView(RenderRequest request) throws PortletSecurityException {
        if (!request.isUserInRole("newsAdmin")) {
            this.log.warn("User [ {} ] with IP [ {} ] tried to access news administration!", (Object)request.getRemoteUser(), (Object)request.getProperty("REMOTE_ADDR"));
            throw new PortletSecurityException("User does not have required admin role");
        }
        this.log.debug("Entering news admin");
        HashMap<String, List> model = new HashMap<String, List>();
        model.put("feeds", this.newsStore.getPredefinedNewsConfigurations());
        return new ModelAndView("adminNews", "model", model);
    }

    @ActionMapping(params={"action=deletePredefinedFeed"})
    public void deleteFeed(@RequestParam(value="id") Long id, ActionRequest request) throws PortletSecurityException {
        if (!request.isUserInRole("newsAdmin")) {
            this.log.warn("User [ {} ] with IP [ {} ] tried to access news administration!", (Object)request.getRemoteUser(), (Object)request.getProperty("REMOTE_ADDR"));
            throw new PortletSecurityException("User does not have required admin role");
        }
        PredefinedNewsDefinition def = this.newsStore.getPredefinedNewsDefinition(id);
        this.newsStore.deleteNewsDefinition(def);
    }
}

