/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.notice.mvc.controller;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import javax.annotation.Resource;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.notice.response.NotificationResponse;
import org.jasig.portlet.notice.service.INotificationService;
import org.jasig.web.service.AjaxPortletSupportService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"VIEW"})
public class DataController {
    public static final String ATTRIBUTE_HIDDEN_ERRORS = DataController.class.getName() + ".ATTRIBUTE_HIDDEN_ERRORS";
    private Log log = LogFactory.getLog(this.getClass());
    @Resource
    private String notificationsContextName;
    @Autowired(required=true)
    private AjaxPortletSupportService ajaxPortletSupportService;
    @Autowired(required=true)
    private INotificationService notificationService;

    @RequestMapping(params={"action=getNotifications"})
    public void getNotifications(ActionRequest req, ActionResponse res, @RequestParam(value="refresh", required=false) String doRefresh) throws IOException {
        this.log.trace((Object)"In getNotifications");
        HashMap<String, Object> model = new HashMap<String, Object>();
        try {
            if (Boolean.valueOf(doRefresh).booleanValue()) {
                this.notificationService.refreshNotifications(this.notificationsContextName, req.getRemoteUser());
            }
            NotificationResponse notificationResponse = this.notificationService.getNotifications(this.notificationsContextName, req.getRemoteUser(), (PortletRequest)req);
            PortletSession session = req.getPortletSession(true);
            HashSet hidden = (HashSet)session.getAttribute(ATTRIBUTE_HIDDEN_ERRORS);
            if (hidden == null) {
                hidden = new HashSet();
                session.setAttribute(ATTRIBUTE_HIDDEN_ERRORS, hidden);
            }
            notificationResponse.filterErrors(hidden);
            model.put("notificationResponse", notificationResponse);
            this.ajaxPortletSupportService.redirectAjaxResponse("ajax/json", model, req, res);
        }
        catch (Exception ex) {
            this.log.error((Object)"Unanticipated Error", (Throwable)ex);
            model.put("errorMessage", ex.getMessage());
            this.ajaxPortletSupportService.redirectAjaxResponse("ajax/json", model, req, res);
        }
    }

    @RequestMapping(params={"action=hideError"})
    public void hideError(ActionRequest req, ActionResponse res, @RequestParam(value="errorKey") String errorKey) throws IOException {
        PortletSession session = req.getPortletSession(true);
        HashSet<Integer> hidden = (HashSet<Integer>)session.getAttribute(ATTRIBUTE_HIDDEN_ERRORS);
        if (hidden == null) {
            hidden = new HashSet<Integer>();
            session.setAttribute(ATTRIBUTE_HIDDEN_ERRORS, hidden);
        }
        int errorKeyInt = 0;
        try {
            errorKeyInt = Integer.parseInt(errorKey);
        }
        catch (Exception e) {
            this.log.error((Object)e);
        }
        hidden.add(errorKeyInt);
    }
}

