/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.notice.response;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.json.JSON;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import net.sf.json.JSONSerializer;
import org.jasig.portlet.notice.response.NotificationCategory;
import org.jasig.portlet.notice.response.NotificationEntry;
import org.jasig.portlet.notice.response.NotificationError;

public class NotificationResponse
implements Serializable {
    private static final long serialVersionUID = 1L;
    private List<NotificationCategory> categories = new ArrayList<NotificationCategory>();
    private List<NotificationError> errors = new ArrayList<NotificationError>();

    public NotificationResponse() {
    }

    public NotificationResponse(List<NotificationCategory> categories, List<NotificationError> errors) {
        this.categories = categories;
        this.errors = errors;
    }

    public void setSource(String source) {
        for (NotificationCategory category : this.categories) {
            category.setSource(source);
        }
        for (NotificationError error : this.errors) {
            error.setSource(source);
        }
    }

    public String toJson() {
        return NotificationResponse.toJson(this);
    }

    public static String toJson(NotificationResponse request) {
        try {
            JSON json = JSONSerializer.toJSON(request.toMap());
            return json.toString(1);
        }
        catch (JSONException je) {
            je.printStackTrace();
            return null;
        }
    }

    public static NotificationResponse fromJson(String data) {
        NotificationResponse request = null;
        try {
            HashMap<String, Class<NotificationEntry>> convertMap = new HashMap<String, Class<NotificationEntry>>();
            convertMap.put("errors", NotificationError.class);
            convertMap.put("categories", NotificationCategory.class);
            convertMap.put("entries", NotificationEntry.class);
            JSONObject json = JSONObject.fromObject((Object)data);
            request = (NotificationResponse)JSONObject.toBean((JSONObject)json, NotificationResponse.class, convertMap);
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
        return request;
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (int i = 0; i < this.categories.size(); ++i) {
            map.put("categories", this.categories);
        }
        for (int j = 0; j < this.errors.size(); ++j) {
            map.put("errors", this.errors);
        }
        return map;
    }

    public void addResponseData(NotificationResponse response) {
        this.addCategories(response.getCategories());
        this.addErrors(response.getErrors());
    }

    public List<NotificationCategory> getCategories() {
        return this.categories;
    }

    public void setCategories(List<NotificationCategory> categories) {
        this.categories = categories;
    }

    public void addCategories(List<NotificationCategory> newCategories) {
        for (NotificationCategory newCategory : newCategories) {
            boolean found = false;
            for (NotificationCategory myCategory : this.categories) {
                if (!myCategory.getTitle().toLowerCase().equals(newCategory.getTitle().toLowerCase())) continue;
                found = true;
                myCategory.addEntries(newCategory.getEntries());
            }
            if (found) continue;
            this.categories.add(newCategory);
        }
    }

    public void clearCategories() {
        this.categories.clear();
    }

    public List<NotificationError> getErrors() {
        return this.errors;
    }

    public void setErrors(List<NotificationError> errors) {
        this.errors = errors;
    }

    public void addErrors(List<NotificationError> newErrors) {
        for (NotificationError error : newErrors) {
            this.errors.add(error);
        }
    }

    public void filterErrors(Set<Integer> filterErrors) {
        ArrayList<NotificationError> iSetClone = new ArrayList<NotificationError>(this.errors);
        for (NotificationError error : iSetClone) {
            if (!filterErrors.contains(error.getKey())) continue;
            this.errors.remove(error);
        }
    }

    public void clearErrors() {
        this.errors.clear();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("org.jasig.portlet.notice.serverresponse.NotificationRequest\n");
        for (NotificationCategory category : this.categories) {
            buffer.append(category.toString());
        }
        for (NotificationError error : this.errors) {
            buffer.append(error.toString());
        }
        return buffer.toString();
    }
}

