/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.notice.service;

import com.googlecode.ehcache.annotations.Cacheable;
import com.googlecode.ehcache.annotations.KeyGenerator;
import com.googlecode.ehcache.annotations.PartialCacheKey;
import com.googlecode.ehcache.annotations.Property;
import com.googlecode.ehcache.annotations.TriggersRemove;
import java.util.List;
import javax.portlet.PortletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.notice.response.NotificationResponse;
import org.jasig.portlet.notice.service.INotificationService;
import org.jasig.portlet.notice.service.exceptions.NotificationServiceException;

public class CacheNotificationService
implements INotificationService {
    private final Log log = LogFactory.getLog(this.getClass());
    private List<INotificationService> embeddedServices;

    @Override
    public String getName() {
        return "CacheService";
    }

    @Override
    @Cacheable(cacheName="notificationCache", keyGenerator=@KeyGenerator(name="HashCodeCacheKeyGenerator", properties={@Property(name="includeMethod", value="false")}))
    public NotificationResponse getNotifications(@PartialCacheKey String notificationsContextName, @PartialCacheKey String remoteUser, PortletRequest req) throws NotificationServiceException {
        return this.fetchNotificationsFromSource(req);
    }

    @Override
    @TriggersRemove(cacheName={"notificationCache"}, keyGenerator=@KeyGenerator(name="HashCodeCacheKeyGenerator", properties={@Property(name="includeMethod", value="false")}))
    public void refreshNotifications(String notificationsContextName, String remoteUser) {
    }

    @Override
    public NotificationResponse fetchNotificationsFromSource(PortletRequest req) throws NotificationServiceException {
        this.log.debug((Object)"Invoking embedded notification services...");
        NotificationResponse masterResponse = new NotificationResponse();
        for (INotificationService notificationService : this.embeddedServices) {
            NotificationResponse response = notificationService.fetchNotificationsFromSource(req);
            masterResponse.addResponseData(response);
        }
        return masterResponse;
    }

    public void setEmbeddedServices(List<INotificationService> embeddedServices) {
        this.embeddedServices = embeddedServices;
    }
}

