/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.notice.service;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.portlet.PortletRequest;
import net.sf.json.JSON;
import net.sf.json.JSONException;
import net.sf.json.JSONSerializer;
import org.jasig.portlet.notice.response.NotificationResponse;
import org.jasig.portlet.notice.service.AbstractNotificationService;
import org.jasig.portlet.notice.service.exceptions.NotificationServiceException;

public class DemoNotificationService
extends AbstractNotificationService {
    private String demoFilename = "DemoNoticationResponse.dat";

    @Override
    public String getName() {
        return "DemoService";
    }

    public void setFilename(String filename) {
        this.demoFilename = filename;
    }

    @Override
    public NotificationResponse fetchNotificationsFromSource(PortletRequest req) throws NotificationServiceException {
        return this.readFromFile(this.demoFilename);
    }

    public boolean writeToFile(NotificationResponse request, String filename) {
        try {
            JSON json = JSONSerializer.toJSON(request.toMap());
            String data = json.toString(1);
            FileOutputStream fos = new FileOutputStream(filename);
            fos.write(data.getBytes());
            fos.close();
            return true;
        }
        catch (JSONException je) {
            je.printStackTrace();
            return false;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return false;
        }
    }

    public NotificationResponse readFromFile(String filename) {
        try {
            InputStream fis = this.getClass().getClassLoader().getResourceAsStream(filename);
            int available = fis.available();
            byte[] bytes = new byte[available];
            fis.read(bytes);
            fis.close();
            return NotificationResponse.fromJson(new String(bytes));
        }
        catch (JSONException je) {
            je.printStackTrace();
            return null;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return null;
        }
    }
}

