/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.weather.dao.accuweather.xstream;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.jasig.portlet.weather.dao.accuweather.constants.Constants;
import org.jasig.portlet.weather.domain.Current;

public class CurrentConverter
implements Converter {
    private static final Logger logger = Logger.getLogger(CurrentConverter.class);

    public void marshal(Object arg0, HierarchicalStreamWriter arg1, MarshallingContext arg2) {
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        Current current = new Current();
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            if ("url".equals(reader.getNodeName())) {
                context.put((Object)"moreInformationLink", (Object)reader.getValue());
            } else if ("observationtime".equals(reader.getNodeName())) {
                String obsTime = reader.getValue();
                Date observationTime = null;
                for (String pattern : Constants.dateFormatterPatterns) {
                    if (observationTime != null) continue;
                    SimpleDateFormat formatter = new SimpleDateFormat(pattern);
                    try {
                        observationTime = formatter.parse(obsTime.trim());
                    }
                    catch (ParseException pe) {
                        if (!logger.isEnabledFor((Priority)Level.WARN)) continue;
                        logger.warn((Object)("Unable to parse observation time " + obsTime));
                    }
                }
                context.put((Object)"observationTime", observationTime);
            } else if ("pressure".equals(reader.getNodeName())) {
                Double pressure = null;
                if (!"-999".equals(reader.getValue())) {
                    pressure = Double.valueOf(reader.getValue());
                }
                current.setPressure(pressure);
            } else if ("temperature".equals(reader.getNodeName())) {
                current.setTemperature(Integer.valueOf(reader.getValue()));
            } else if ("humidity".equals(reader.getNodeName())) {
                String humidity = reader.getValue();
                current.setHumidity(Double.valueOf(humidity.substring(0, humidity.indexOf(37))));
            } else if ("weathertext".equals(reader.getNodeName())) {
                current.setCondition(reader.getValue());
            } else if ("weathericon".equals(reader.getNodeName())) {
                current.setImgName(reader.getValue());
            } else if ("windspeed".equals(reader.getNodeName())) {
                current.setWindSpeed(Double.valueOf(reader.getValue()));
            } else if ("winddirection".equals(reader.getNodeName())) {
                current.setWindDirection(reader.getValue());
            }
            reader.moveUp();
        }
        return current;
    }

    public boolean canConvert(Class clazz) {
        return clazz.equals(Current.class);
    }
}

