/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.weather.dao.accuweather.xstream;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.constructs.blocking.CacheEntryFactory;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.apache.commons.io.IOUtils;
import org.jasig.portlet.weather.QuietUrlCodec;
import org.jasig.portlet.weather.TemperatureUnit;
import org.jasig.portlet.weather.dao.IWeatherDao;
import org.jasig.portlet.weather.dao.accuweather.xstream.FinderConverter;
import org.jasig.portlet.weather.dao.accuweather.xstream.WeatherConverter;
import org.jasig.portlet.weather.domain.Location;
import org.jasig.portlet.weather.domain.Weather;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.stereotype.Repository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Repository
public class WeatherDaoImpl
implements IWeatherDao,
DisposableBean,
InitializingBean,
CacheEntryFactory {
    private final MultiThreadedHttpConnectionManager connectionManager = new MultiThreadedHttpConnectionManager();
    private final HttpClient httpClient = new HttpClient((HttpConnectionManager)this.connectionManager);
    private Ehcache weatherDataCache;
    private Ehcache weatherDataErrorCache;
    private int connectionTimeout = 5000;
    private int readTimeout = 5000;
    private int timesToRetry = 5;

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public void setTimesToRetry(int timesToRetry) {
        this.timesToRetry = timesToRetry;
    }

    public void setWeatherDataCache(Ehcache ehcache) {
        this.weatherDataCache = ehcache;
    }

    public void setWeatherDataErrorCache(Ehcache weatherDataErrorCache) {
        this.weatherDataErrorCache = weatherDataErrorCache;
    }

    public void afterPropertiesSet() throws Exception {
        HttpConnectionManager httpConnectionManager = this.httpClient.getHttpConnectionManager();
        HttpConnectionManagerParams params = httpConnectionManager.getParams();
        params.setConnectionTimeout(this.connectionTimeout);
        params.setSoTimeout(this.readTimeout);
        params.setParameter("http.method.retry-handler", (Object)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void destroy() throws Exception {
        this.connectionManager.shutdown();
    }

    public Collection<Location> find(String location) {
        String accuweatherUrl = "http://uport.accu-weather.com/widget/uport/city-find.asp?location=" + QuietUrlCodec.encode((String)location, (String)"UTF-8");
        XStream xstream = new XStream();
        xstream.alias("adc_database", Collection.class);
        xstream.registerConverter((Converter)new FinderConverter());
        Collection locations = null;
        try {
            locations = (Collection)this.getAndDeserialize(accuweatherUrl, xstream);
        }
        catch (RuntimeException e) {
            throw new DataRetrievalFailureException("find location failed for search '" + location + "'", (Throwable)e);
        }
        return locations != null && locations.size() > 0 ? locations : null;
    }

    public Object createEntry(Object o) throws Exception {
        Map key = (Map)o;
        this.checkCachedException(key);
        String locationCode = (String)key.get("locationCode");
        TemperatureUnit unit = (TemperatureUnit)key.get("unit");
        String accuweatherUrl = "http://uport.accu-weather.com/widget/uport/weather-data.asp?location=" + QuietUrlCodec.encode((String)locationCode, (String)"UTF-8") + "&metric=" + (TemperatureUnit.C.equals((Object)unit) ? "1" : "0");
        XStream xstream = new XStream();
        xstream.registerConverter((Converter)new WeatherConverter(locationCode));
        xstream.alias("adc_database", Weather.class);
        Weather weather = null;
        try {
            weather = (Weather)this.getAndDeserialize(accuweatherUrl, xstream);
        }
        catch (RuntimeException e) {
            DataRetrievalFailureException drfe = new DataRetrievalFailureException("get weather failed for location '" + locationCode + "' and unit " + unit, (Throwable)e);
            Element element = new Element((Object)key, (Object)drfe);
            this.weatherDataErrorCache.put(element);
            throw drfe;
        }
        return weather;
    }

    public Weather getWeather(String locationCode, TemperatureUnit unit) {
        LinkedHashMap<String, String> key = new LinkedHashMap<String, String>();
        key.put("locationCode", locationCode);
        key.put("unit", (String)unit);
        this.checkCachedException(key);
        Element element = this.weatherDataCache.get(key);
        return (Weather)element.getValue();
    }

    protected void checkCachedException(Map<String, Object> key) {
        Element errorElement = this.weatherDataErrorCache.get(key);
        if (errorElement != null && !errorElement.isExpired()) {
            throw (RuntimeException)errorElement.getValue();
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object getAndDeserialize(String url, XStream deserializer) {
        Object object;
        GetMethod getMethod = new GetMethod(url);
        InputStream inputStream = null;
        try {
            int statusCode = this.httpClient.executeMethod((HttpMethod)getMethod);
            if (statusCode != 200) {
                String statusText = getMethod.getStatusText();
                throw new DataRetrievalFailureException("get of '" + url + "' failed with status '" + statusCode + "' due to '" + statusText + "'");
            }
            inputStream = getMethod.getResponseBodyAsStream();
            object = deserializer.fromXML(inputStream);
        }
        catch (HttpException e) {
            try {
                throw new RuntimeException("http protocol exception while getting data from weather service from: " + url, e);
                catch (IOException e2) {
                    throw new RuntimeException("IO exception while getting data from weather service from: " + url, e2);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream);
                getMethod.releaseConnection();
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        getMethod.releaseConnection();
        return object;
    }

    static /* synthetic */ int access$000(WeatherDaoImpl x0) {
        return x0.timesToRetry;
    }
}

