/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.weather.portlet;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletPreferences;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.jasig.portlet.weather.DuplicateLocationException;
import org.jasig.portlet.weather.TemperatureUnit;
import org.jasig.portlet.weather.service.IWeatherService;
import org.jasig.portlet.weather.service.SavedLocation;
import org.jasig.web.service.AjaxPortletSupport;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.portlet.ModelAndView;

@Controller
@RequestMapping(value={"EDIT"})
public class WeatherEditController {
    private IWeatherService weatherService = null;
    private AjaxPortletSupport ajaxPortletSupport;

    @Autowired
    public void setWeatherService(IWeatherService weatherService) {
        this.weatherService = weatherService;
    }

    @Autowired
    public void setAjaxPortletSupport(AjaxPortletSupport ajaxPortletSupport) {
        this.ajaxPortletSupport = ajaxPortletSupport;
    }

    @RequestMapping
    public ModelAndView renderEditView(RenderRequest request, RenderResponse response) throws Exception {
        PortletPreferences preferences = request.getPreferences();
        List savedLocations = this.weatherService.getSavedLocations(preferences);
        ModelMap model = new ModelMap("savedLocations", (Object)savedLocations);
        return new ModelAndView("edit", (Map)model);
    }

    @RequestMapping(params={"action=add"})
    public void addCity(@RequestParam(value="location", required=false) String location, @RequestParam(value="locationCode", required=false) String locationCode, @RequestParam(value="unit", required=false) TemperatureUnit unit, ActionRequest request, ActionResponse response) throws Exception {
        PortletPreferences prefs = request.getPreferences();
        HashMap<String, String> model = new HashMap<String, String>();
        if (!StringUtils.hasText((String)location) || !StringUtils.hasLength((String)locationCode)) {
            model.put("status", "failure");
            this.ajaxPortletSupport.redirectAjaxResponse("ajax/json", model, request, response);
            return;
        }
        try {
            SavedLocation savedLocation = this.weatherService.addWeatherLocation(prefs, locationCode, location, unit == null ? TemperatureUnit.F : unit);
            model.put("status", "success");
            model.put("location", (String)savedLocation);
        }
        catch (DuplicateLocationException dle) {
            model.put("status", "failure");
            model.put("cause", "DUPLICATE_LOCATION");
        }
        this.ajaxPortletSupport.redirectAjaxResponse("ajax/json", model, request, response);
    }

    @RequestMapping(params={"action=saveOrder"})
    public void saveCityOrder(@RequestParam(value="locationCodes") String[] locationCodes, ActionRequest request, ActionResponse response) throws Exception {
        HashMap<String, String> model = new HashMap<String, String>();
        PortletPreferences prefs = request.getPreferences();
        List savedLocations = this.weatherService.getSavedLocations(prefs);
        if (savedLocations.size() != locationCodes.length) {
            model.put("status", "failure");
            model.put("message", "updated locations array is not the same size (" + locationCodes.length + ") as the saved locations array (" + savedLocations.size() + ")");
            this.ajaxPortletSupport.redirectAjaxResponse("ajax/json", model, request, response);
            return;
        }
        LinkedHashMap<String, SavedLocation> locations = new LinkedHashMap<String, SavedLocation>();
        for (SavedLocation savedLocation : savedLocations) {
            locations.put(savedLocation.code, savedLocation);
        }
        ArrayList updatedLocations = new ArrayList(savedLocations.size());
        for (String locationCode : locationCodes) {
            updatedLocations.add(locations.get(locationCode));
        }
        this.weatherService.saveLocations(updatedLocations, prefs);
        model.put("status", "success");
        this.ajaxPortletSupport.redirectAjaxResponse("ajax/json", model, request, response);
    }

    @RequestMapping(params={"action=updateUnits"})
    public void updateCityUnits(@RequestParam(value="locationCode") String locationCode, @RequestParam(value="unit") TemperatureUnit unit, ActionRequest request, ActionResponse response) throws Exception {
        HashMap<String, String> model = new HashMap<String, String>();
        PortletPreferences prefs = request.getPreferences();
        List savedLocations = this.weatherService.getSavedLocations(prefs);
        ArrayList<SavedLocation> updatedLocations = new ArrayList<SavedLocation>(savedLocations.size());
        for (SavedLocation savedLocation : savedLocations) {
            if (savedLocation.code.equals(locationCode)) {
                updatedLocations.add(new SavedLocation(savedLocation.code, savedLocation.name, unit));
                continue;
            }
            updatedLocations.add(savedLocation);
        }
        this.weatherService.saveLocations(updatedLocations, prefs);
        model.put("status", "success");
        this.ajaxPortletSupport.redirectAjaxResponse("ajax/json", model, request, response);
    }

    @RequestMapping(params={"action=delete"})
    public void deleteCity(@RequestParam(value="locationCode") String locationCode, ActionRequest request, ActionResponse response) throws Exception {
        HashMap<String, String> model = new HashMap<String, String>();
        PortletPreferences prefs = request.getPreferences();
        this.weatherService.deleteWeatherLocation(prefs, locationCode);
        model.put("status", "success");
        this.ajaxPortletSupport.redirectAjaxResponse("ajax/json", model, request, response);
    }
}

