/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.weather.dao.accuweather.xstream;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import org.jasig.portlet.weather.domain.Forecast;

public class ForecastConverter
implements Converter {
    private String timeOfDay = null;

    public ForecastConverter() {
    }

    public ForecastConverter(String timeOfDay) {
        this.timeOfDay = timeOfDay;
    }

    public boolean canConvert(Class clazz) {
        return clazz.equals(Forecast.class);
    }

    public void marshal(Object arg0, HierarchicalStreamWriter arg1, MarshallingContext arg2) {
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        Forecast forecast = new Forecast();
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            if ("daycode".equals(reader.getNodeName())) {
                forecast.setDay(reader.getValue().substring(0, 3));
            } else if (this.timeOfDay.equals(reader.getNodeName())) {
                while (reader.hasMoreChildren()) {
                    reader.moveDown();
                    if ("txtshort".equals(reader.getNodeName())) {
                        forecast.setCondition(reader.getValue());
                    } else if ("weathericon".equals(reader.getNodeName())) {
                        forecast.setImgName(reader.getValue());
                    } else if ("hightemperature".equals(reader.getNodeName())) {
                        forecast.setHighTemperature(Integer.valueOf(reader.getValue()));
                    } else if ("lowtemperature".equals(reader.getNodeName())) {
                        forecast.setLowTemperature(Integer.valueOf(reader.getValue()));
                    }
                    reader.moveUp();
                }
            }
            reader.moveUp();
        }
        return forecast;
    }
}

