/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.weather.dao.accuweather.xstream;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.jasig.portlet.weather.dao.accuweather.constants.Constants;
import org.jasig.portlet.weather.dao.accuweather.xstream.CurrentConverter;
import org.jasig.portlet.weather.dao.accuweather.xstream.ForecastsConverter;
import org.jasig.portlet.weather.dao.accuweather.xstream.LocationConverter;
import org.jasig.portlet.weather.dao.accuweather.xstream.UnitsConverter;
import org.jasig.portlet.weather.domain.Current;
import org.jasig.portlet.weather.domain.Forecast;
import org.jasig.portlet.weather.domain.Location;
import org.jasig.portlet.weather.domain.Weather;

public class WeatherConverter
implements Converter {
    private static final Logger logger = Logger.getLogger(WeatherConverter.class);
    private Date observationTime = null;
    private Date sunsetTime = null;
    private String locationCode = null;

    public WeatherConverter(String locationCode) {
        this.locationCode = locationCode;
    }

    public boolean canConvert(Class clazz) {
        return clazz.equals(Weather.class);
    }

    public void marshal(Object arg0, HierarchicalStreamWriter arg1, MarshallingContext arg2) {
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        Weather weather = new Weather();
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            if ("units".equals(reader.getNodeName())) {
                context.put((Object)"weather", (Object)weather);
                weather = (Weather)context.convertAnother((Object)weather, Weather.class, (Converter)new UnitsConverter());
            } else if ("local".equals(reader.getNodeName())) {
                Location location = (Location)context.convertAnother((Object)weather, Location.class, (Converter)new LocationConverter(this.locationCode));
                weather.setLocation(location);
            } else if ("currentconditions".equals(reader.getNodeName())) {
                Current current = (Current)context.convertAnother((Object)weather, Current.class, (Converter)new CurrentConverter());
                weather.setCurrentWeather(current);
                this.observationTime = (Date)context.get((Object)"observationTime");
                weather.setMoreInformationLink((String)context.get((Object)"moreInformationLink"));
            } else if ("planets".equals(reader.getNodeName())) {
                reader.moveDown();
                String sunTime = reader.getAttribute("set");
                for (String pattern : Constants.dateFormatterPatterns) {
                    if (this.sunsetTime != null) continue;
                    SimpleDateFormat formatter = new SimpleDateFormat(pattern);
                    try {
                        this.sunsetTime = formatter.parse(sunTime.trim());
                    }
                    catch (ParseException pe) {
                        if (!logger.isEnabledFor((Priority)Level.WARN)) continue;
                        logger.warn((Object)("Unable to parse sunset time " + sunTime));
                    }
                }
                reader.moveUp();
            } else if ("forecast".equals(reader.getNodeName())) {
                String timeOfDay = "daytime";
                if (this.sunsetTime != null && this.observationTime != null) {
                    timeOfDay = this.sunsetTime.before(this.observationTime) ? "nighttime" : "daytime";
                } else if (logger.isEnabledFor((Priority)Level.WARN)) {
                    logger.warn((Object)"Unable to determine time of day for forecast rendering, defaulting to day time");
                }
                Collection forecasts = (Collection)context.convertAnother((Object)weather, Forecast.class, (Converter)new ForecastsConverter(timeOfDay));
                weather.setForecast(forecasts);
            }
            reader.moveUp();
        }
        return weather;
    }
}

