/**
 * Licensed to Jasig under one or more contributor license
 * agreements. See the NOTICE file distributed with this work
 * for additional information regarding copyright ownership.
 * Jasig licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a
 * copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.jasig.portlet.weather.domain;

import java.io.Serializable;

/**
 * This class models an international location.
 * 
 * @author Dustin Schultz
 * @version $Id: Location.java 22379 2010-11-15 22:19:56Z edalquist $
 */
public class Location implements Serializable {

	private static final long serialVersionUID = -4301186984139190062L;
	private String locationCode = null; // zipcode or some other code that represents this location
	private String city = null;
	private String stateOrCountry = null;
	private Double latitude = null;
	private Double longitude = null;

	public void setLocationCode(String locationCode) {
		this.locationCode = locationCode;
	}

	public String getCity() {
		return city;
	}

	public void setCity(String city) {
		this.city = city;
	}

	public String getStateOrCountry() {
		return stateOrCountry;
	}

	public void setStateOrCountry(String stateOrCountry) {
		this.stateOrCountry = stateOrCountry;
	}

	public Double getLatitude() {
		return latitude;
	}

	public void setLatitude(Double latitude) {
		this.latitude = latitude;
	}

	public Double getLongitude() {
		return longitude;
	}

	public void setLongitude(Double longitude) {
		this.longitude = longitude;
	}

	public String getLocationCode() {
		return locationCode;
	}
}
