/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.weather.dao.worldwide;

import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.apache.commons.io.IOUtils;
import org.jasig.portlet.weather.QuietUrlCodec;
import org.jasig.portlet.weather.TemperatureUnit;
import org.jasig.portlet.weather.dao.IWeatherDao;
import org.jasig.portlet.weather.dao.worldwide.WorldWeatherOnlineDaoImpl;
import org.jasig.portlet.weather.dao.worldwide.xml.LocationResult;
import org.jasig.portlet.weather.dao.worldwide.xml.SearchData;
import org.jasig.portlet.weather.dao.worldwide.xml.WeatherData;
import org.jasig.portlet.weather.dao.worldwide.xml.WeatherForecast;
import org.jasig.portlet.weather.domain.Current;
import org.jasig.portlet.weather.domain.Forecast;
import org.jasig.portlet.weather.domain.Location;
import org.jasig.portlet.weather.domain.Weather;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;
import org.springframework.dao.DataRetrievalFailureException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorldWeatherOnlineDaoImpl
implements IWeatherDao,
DisposableBean,
InitializingBean {
    private static final String DATE_PATTERN = "yyyy-MM-dd";
    private static final String DAY_PATTERN = "EEE";
    private static final String FIND_URL = "http://free.worldweatheronline.com/feed/search.ashx?key=@KEY@&query=@QUERY@&num_of_results=3&format=xml";
    private static final String WEATHER_URL = "http://free.worldweatheronline.com/feed/weather.ashx?key=@KEY@&num_of_days=3&format=xml&q=@LOCATION@";
    private String key = null;
    private Properties imageMapping;
    private final MultiThreadedHttpConnectionManager connectionManager = new MultiThreadedHttpConnectionManager();
    private final HttpClient httpClient = new HttpClient((HttpConnectionManager)this.connectionManager);
    private int connectionTimeout = 5000;
    private int readTimeout = 5000;
    private int timesToRetry = 5;

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public void setTimesToRetry(int timesToRetry) {
        this.timesToRetry = timesToRetry;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setImageMapping(Resource imageMapping) {
        this.imageMapping = new Properties();
        InputStream is = null;
        try {
            is = imageMapping.getInputStream();
            this.imageMapping.load(is);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load image mapping", e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    public void afterPropertiesSet() throws Exception {
        HttpConnectionManager httpConnectionManager = this.httpClient.getHttpConnectionManager();
        HttpConnectionManagerParams params = httpConnectionManager.getParams();
        params.setConnectionTimeout(this.connectionTimeout);
        params.setSoTimeout(this.readTimeout);
        params.setParameter("http.method.retry-handler", (Object)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void destroy() throws Exception {
        this.connectionManager.shutdown();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Collection<Location> find(String location) {
        List list;
        String url = FIND_URL.replace("@KEY@", this.key).replace("@QUERY@", QuietUrlCodec.encode((String)location, (String)"UTF-8"));
        GetMethod getMethod = new GetMethod(url);
        InputStream inputStream = null;
        try {
            List locations;
            int statusCode = this.httpClient.executeMethod((HttpMethod)getMethod);
            if (statusCode != 200) {
                String statusText = getMethod.getStatusText();
                throw new DataRetrievalFailureException("get of '" + url + "' failed with status '" + statusCode + "' due to '" + statusText + "'");
            }
            inputStream = getMethod.getResponseBodyAsStream();
            list = locations = this.deserializeSearchResults(inputStream);
        }
        catch (HttpException e) {
            try {
                throw new RuntimeException("http protocol exception while getting data from weather service from: " + url, e);
                catch (IOException e2) {
                    throw new RuntimeException("IO exception while getting data from weather service from: " + url, e2);
                }
                catch (JAXBException e3) {
                    throw new RuntimeException("Parsing exception while getting data from weather service from: " + url, e3);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream);
                getMethod.releaseConnection();
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        getMethod.releaseConnection();
        return list;
    }

    public Weather getWeather(String locationCode, TemperatureUnit unit) {
        String worldwideweatherUrl = WEATHER_URL.replace("@KEY@", this.key).replace("@LOCATION@", QuietUrlCodec.encode((String)locationCode, (String)"UTF-8"));
        Weather weather = (Weather)this.getAndDeserialize(worldwideweatherUrl, unit);
        String[] locationParts = locationCode.split(", ");
        Location location = new Location();
        location.setCity(locationParts[0]);
        if (locationParts.length > 1) {
            location.setStateOrCountry(locationParts[1]);
        }
        weather.setLocation(location);
        weather.setMoreInformationLink("http://www.worldweatheronline.com/weather.aspx?q=" + QuietUrlCodec.encode((String)locationCode, (String)"UTF-8"));
        return weather;
    }

    public String getWeatherProviderName() {
        return "World Weather Online";
    }

    public String getWeatherProviderLink() {
        return "http://www.worldweatheronline.com/";
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object getAndDeserialize(String url, TemperatureUnit unit) {
        Weather weather;
        GetMethod getMethod = new GetMethod(url);
        InputStream inputStream = null;
        try {
            Weather weather2;
            int statusCode = this.httpClient.executeMethod((HttpMethod)getMethod);
            if (statusCode != 200) {
                String statusText = getMethod.getStatusText();
                throw new DataRetrievalFailureException("get of '" + url + "' failed with status '" + statusCode + "' due to '" + statusText + "'");
            }
            inputStream = getMethod.getResponseBodyAsStream();
            weather = weather2 = this.deserializeWeatherResult(inputStream, unit);
        }
        catch (HttpException e) {
            try {
                throw new RuntimeException("http protocol exception while getting data from weather service from: " + url, e);
                catch (IOException e2) {
                    throw new RuntimeException("IO exception while getting data from weather service from: " + url, e2);
                }
                catch (JAXBException e3) {
                    throw new RuntimeException("Parsing exception while getting data from weather service from: " + url, e3);
                }
                catch (ParseException e4) {
                    throw new RuntimeException("Parsing exception while getting data from weather service from: " + url, e4);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream);
                getMethod.releaseConnection();
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        getMethod.releaseConnection();
        return weather;
    }

    protected Weather deserializeWeatherResult(InputStream inputStream, TemperatureUnit unit) throws JAXBException, ParseException {
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{WeatherData.class});
        Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
        WeatherData data = (WeatherData)unmarshaller.unmarshal(inputStream);
        Weather weather = new Weather();
        Current current = new Current();
        current.setCondition(data.getCondition().getDescription());
        current.setHumidity(Double.valueOf(data.getCondition().getHumidity()));
        current.setPressure(Double.valueOf(data.getCondition().getPressure()));
        current.setWindDirection(data.getCondition().getWindDir());
        if (data.getCondition().getWeatherIconUrl() != null && data.getCondition().getWeatherIconUrl().contains("night")) {
            current.setImgName(this.imageMapping.getProperty("image.night." + data.getCondition().getWeatherCode()));
        } else {
            current.setImgName(this.imageMapping.getProperty("image.day." + data.getCondition().getWeatherCode()));
        }
        switch (2.$SwitchMap$org$jasig$portlet$weather$TemperatureUnit[unit.ordinal()]) {
            case 1: {
                current.setTemperature(Integer.valueOf(data.getCondition().getTempC()));
                current.setWindSpeed(Double.valueOf(data.getCondition().getSpeedKmph()));
                weather.setTemperatureUnit("C");
                weather.setWindUnit("kmph");
                weather.setPressureUnit("mb");
                break;
            }
            default: {
                current.setTemperature(Integer.valueOf(data.getCondition().getTempF()));
                current.setWindSpeed(Double.valueOf(data.getCondition().getSpeedMiles()));
                weather.setTemperatureUnit("F");
                weather.setWindUnit("mi");
                weather.setPressureUnit("mb");
            }
        }
        weather.setCurrentWeather(current);
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_PATTERN);
        SimpleDateFormat dayFormat = new SimpleDateFormat(DAY_PATTERN);
        ArrayList<Forecast> forecasts = new ArrayList<Forecast>();
        for (WeatherForecast f : data.getForecasts()) {
            Forecast forecast = new Forecast();
            forecast.setCondition(f.getDescription());
            if (f.getIconUrl() != null && f.getIconUrl().contains("night")) {
                forecast.setImgName(this.imageMapping.getProperty("image.night." + f.getWeatherCode()));
            } else {
                forecast.setImgName(this.imageMapping.getProperty("image.day." + f.getWeatherCode()));
            }
            Date date = dateFormat.parse(f.getDate());
            forecast.setDay(dayFormat.format(date));
            switch (2.$SwitchMap$org$jasig$portlet$weather$TemperatureUnit[unit.ordinal()]) {
                case 1: {
                    forecast.setHighTemperature(Integer.valueOf(f.getTempMaxF()));
                    forecast.setLowTemperature(Integer.valueOf(f.getTempMinF()));
                    break;
                }
                default: {
                    forecast.setHighTemperature(Integer.valueOf(f.getTempMaxF()));
                    forecast.setLowTemperature(Integer.valueOf(f.getTempMinF()));
                }
            }
            forecasts.add(forecast);
        }
        weather.setForecast(forecasts);
        return weather;
    }

    protected List<Location> deserializeSearchResults(InputStream inputStream) throws JAXBException {
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{SearchData.class});
        Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
        SearchData data = (SearchData)unmarshaller.unmarshal(inputStream);
        ArrayList<Location> locations = new ArrayList<Location>();
        for (LocationResult l : data.getResults()) {
            Location location = new Location();
            location.setCity(l.getCity());
            location.setLatitude(Double.valueOf(l.getLatitude()));
            location.setLongitude(Double.valueOf(l.getLongitude()));
            location.setStateOrCountry(l.getRegion() != null ? l.getRegion() : l.getCountry());
            StringBuffer code = new StringBuffer();
            code.append(l.getCity());
            if (l.getRegion() != null) {
                code.append(", ").append(l.getRegion());
            }
            if (l.getCountry() != null) {
                code.append(", ").append(l.getCountry());
            }
            location.setLocationCode(code.toString());
            locations.add(location);
        }
        return locations;
    }

    static /* synthetic */ int access$000(WorldWeatherOnlineDaoImpl x0) {
        return x0.timesToRetry;
    }
}

