/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.weather.service;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.portlet.PortletPreferences;
import javax.portlet.ReadOnlyException;
import javax.portlet.ValidatorException;
import org.jasig.portlet.weather.DuplicateLocationException;
import org.jasig.portlet.weather.TemperatureUnit;
import org.jasig.portlet.weather.service.IWeatherService;
import org.jasig.portlet.weather.service.SavedLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.PermissionDeniedDataAccessException;

public abstract class AbstractWeatherService
implements IWeatherService {
    private static final String METRICS = "metrics";
    private static final String UNITS = "units";
    private static final String LOCATIONS = "locations";
    private static final String LOCATION_CODES = "locationCodes";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public List<SavedLocation> getSavedLocations(PortletPreferences prefs) {
        String[] locationCodes = prefs.getValues(LOCATION_CODES, new String[0]);
        String[] locations = prefs.getValues(LOCATIONS, new String[0]);
        String[] units = prefs.getValues(UNITS, null);
        String[] metrics = prefs.getValues(METRICS, null);
        if (metrics != null) {
            units = new String[metrics.length];
            for (int index = 0; index < metrics.length; ++index) {
                units[index] = Boolean.parseBoolean(metrics[index]) ? TemperatureUnit.C.toString() : TemperatureUnit.F.toString();
            }
        }
        ArrayList<SavedLocation> savedLocations = new ArrayList<SavedLocation>(locationCodes.length);
        for (int locationIndex = 0; locationIndex < locationCodes.length; ++locationIndex) {
            if (locationCodes[locationIndex] == null) {
                this.logger.warn("A null location was stored at index '{}' this should be resolved when SavedLocations are next stored for this user", (Object)locationIndex);
                continue;
            }
            savedLocations.add(new SavedLocation(locationCodes[locationIndex], locationIndex < locations.length ? locations[locationIndex] : null, locationIndex < units.length ? TemperatureUnit.safeValueOf((String)units[locationIndex]) : TemperatureUnit.F));
        }
        return savedLocations;
    }

    public void saveLocations(List<SavedLocation> savedLocations, PortletPreferences prefs) {
        ArrayList<String> locationCodes = new ArrayList<String>(savedLocations.size());
        ArrayList<String> locations = new ArrayList<String>(savedLocations.size());
        ArrayList<String> metrics = new ArrayList<String>(savedLocations.size());
        for (SavedLocation savedLocation : savedLocations) {
            locationCodes.add(savedLocation.code);
            locations.add(savedLocation.name);
            metrics.add(savedLocation.temperatureUnit.toString());
        }
        try {
            prefs.setValues(LOCATION_CODES, locationCodes.toArray(new String[locationCodes.size()]));
            prefs.setValues(LOCATIONS, locations.toArray(new String[locations.size()]));
            prefs.setValues(UNITS, metrics.toArray(new String[metrics.size()]));
            prefs.reset(METRICS);
            prefs.store();
        }
        catch (ReadOnlyException roe) {
            throw new PermissionDeniedDataAccessException("Failed to save preferences due to one being marked read-only. The portlet preferences locationCode, locations, and metrics must not be read only.", (Throwable)roe);
        }
        catch (ValidatorException ve) {
            throw new DataIntegrityViolationException("Validation of saved locations preferences failed", (Throwable)ve);
        }
        catch (IOException ioe) {
            throw new RuntimeException("Failed to store saved locations preferences due to IO error", ioe);
        }
    }

    public SavedLocation addWeatherLocation(PortletPreferences prefs, String locationCode, String location, TemperatureUnit unit) {
        SavedLocation newLocation;
        ArrayList<SavedLocation> savedLocations = new ArrayList<SavedLocation>(this.getSavedLocations(prefs));
        if (savedLocations.contains(newLocation = new SavedLocation(locationCode, location, unit))) {
            throw new DuplicateLocationException("A location already exists for code '" + locationCode + "'");
        }
        savedLocations.add(newLocation);
        this.saveLocations(savedLocations, prefs);
        return newLocation;
    }

    public void deleteWeatherLocation(PortletPreferences prefs, String locationCode) {
        ArrayList savedLocations = new ArrayList(this.getSavedLocations(prefs));
        Iterator savedLocationItr = savedLocations.iterator();
        while (savedLocationItr.hasNext()) {
            SavedLocation savedLocation = (SavedLocation)savedLocationItr.next();
            if (!savedLocation.code.equals(locationCode)) continue;
            savedLocationItr.remove();
            break;
        }
        this.saveLocations(savedLocations, prefs);
    }
}

