/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.weather.portlet;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.weather.domain.Weather;
import org.jasig.portlet.weather.portlet.IViewSelector;
import org.jasig.portlet.weather.service.IWeatherService;
import org.jasig.portlet.weather.service.SavedLocation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.portlet.ModelAndView;
import org.springframework.web.portlet.bind.annotation.ResourceMapping;

@Controller
@RequestMapping(value={"VIEW"})
public class WeatherViewController {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private IWeatherService weatherService = null;
    private IViewSelector viewSelector;

    @Autowired
    public void setWeatherService(IWeatherService weatherService) {
        this.weatherService = weatherService;
    }

    @Autowired
    public void setViewSelector(IViewSelector viewSelector) {
        this.viewSelector = viewSelector;
    }

    @RequestMapping
    public ModelAndView viewWeather(RenderRequest request, RenderResponse response) {
        String extension = this.viewSelector.getViewNameExtension((PortletRequest)request);
        String viewName = "view".concat(extension);
        return new ModelAndView(viewName, this.getWeatherInfo((PortletRequest)request, (PortletResponse)response));
    }

    @ResourceMapping(value="weatherFeed")
    public ModelAndView getWeatherFeed(PortletRequest request, PortletResponse response) {
        return new ModelAndView("jsonView", this.getWeatherInfo(request, response));
    }

    private Map<String, Object> getWeatherInfo(PortletRequest request, PortletResponse response) {
        LinkedHashMap<String, Object> model = new LinkedHashMap<String, Object>();
        PortletPreferences prefs = request.getPreferences();
        List<SavedLocation> savedLocations = this.weatherService.getSavedLocations(prefs);
        ArrayList<Weather> weatherList = new ArrayList<Weather>(savedLocations.size());
        ArrayList<SavedLocation> errorList = new ArrayList<SavedLocation>(savedLocations.size());
        for (SavedLocation savedLocation : savedLocations) {
            try {
                Weather weather = this.weatherService.getWeather(savedLocation.code, savedLocation.temperatureUnit);
                weatherList.add(weather);
            }
            catch (RuntimeException re) {
                errorList.add(savedLocation);
                this.logger.warn((Object)("Failed to load weather for " + savedLocation), (Throwable)re);
            }
        }
        model.put("weathers", weatherList);
        model.put("errors", errorList);
        model.put("serviceName", this.weatherService.getWeatherProviderName());
        model.put("serviceUrl", this.weatherService.getWeatherProviderLink());
        model.put("isGuest", request.getRemoteUser() == null || request.getRemoteUser().equalsIgnoreCase("guest"));
        return model;
    }
}

