/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.weather.service;

import org.apache.commons.lang.Validate;
import org.jasig.portlet.weather.TemperatureUnit;

public class SavedLocation {
    public final String code;
    public final String name;
    public final TemperatureUnit temperatureUnit;

    public SavedLocation(String code, String name, TemperatureUnit temperatureUnit) {
        Validate.notNull((Object)code, (String)"location code cannot be null");
        this.code = code;
        this.name = name;
        if (temperatureUnit == null) {
            temperatureUnit = TemperatureUnit.F;
        }
        this.temperatureUnit = temperatureUnit;
    }

    public String getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public TemperatureUnit getTemperatureUnit() {
        return this.temperatureUnit;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.code == null ? 0 : this.code.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SavedLocation other = (SavedLocation)obj;
        return !(this.code == null ? other.code != null : !this.code.equals(other.code));
    }

    public String toString() {
        return "SavedLocation [code=" + this.code + ", name=" + this.name + ", temperatureUnit=" + (Object)((Object)this.temperatureUnit) + "]";
    }
}

