/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.weather.service;

import java.io.Serializable;
import java.util.Collection;
import javax.annotation.Resource;
import net.sf.ehcache.Cache;
import net.sf.ehcache.Element;
import org.apache.commons.lang.StringUtils;
import org.jasig.portlet.weather.TemperatureUnit;
import org.jasig.portlet.weather.dao.IWeatherDao;
import org.jasig.portlet.weather.domain.Location;
import org.jasig.portlet.weather.domain.Weather;
import org.jasig.portlet.weather.service.AbstractWeatherService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WeatherServiceImpl
extends AbstractWeatherService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String ADDING_LOCATIONS_TO_CACHE_KEY = "Adding locations-to cache key: {}\n{}";
    private static final String RETRIEVING_LOCATIONS_FROM_CACHE_KEY = "Retrieving locations-from cache key: {}\n{}";
    private static final String ADDING_WEATHER_TO_CACHE_KEY = "Adding Weather-to cache key: {}\n{}";
    private static final String RETRIEVING_WEATHER_FROM_CACHE_KEY = "Retrieving Weather-from cache, key: {}\n{}";
    private static final String WEATHER_KEY_TEMPLATE = "%s_%s";
    private IWeatherDao weatherDao = null;
    @Resource(name="weatherSearchCache")
    private Cache weatherSearchCache;
    @Resource(name="weatherDataCache")
    private Cache weatherDataCache;

    @Override
    public Collection<Location> find(String location) {
        if (StringUtils.isBlank((String)location)) {
            return null;
        }
        Element cachedElement = this.weatherSearchCache.get((Serializable)((Object)location));
        if (cachedElement != null) {
            this.logDebugInformation(RETRIEVING_LOCATIONS_FROM_CACHE_KEY, location, cachedElement);
            Collection locations = (Collection)((Object)cachedElement.getValue());
            return locations;
        }
        Collection<Location> locations = this.weatherDao.find(location);
        cachedElement = new Element((Object)location, locations);
        this.logDebugInformation(ADDING_LOCATIONS_TO_CACHE_KEY, location, cachedElement);
        this.weatherSearchCache.put(cachedElement);
        return locations;
    }

    @Override
    public Weather getWeather(String locationCode, TemperatureUnit unit) {
        if (StringUtils.isBlank((String)locationCode)) {
            return null;
        }
        String key = this.createKeyFromLocationAndUnitOfMeasure(locationCode, unit);
        Element cachedElement = this.weatherDataCache.get((Serializable)((Object)key));
        if (cachedElement != null) {
            this.logDebugInformation(RETRIEVING_WEATHER_FROM_CACHE_KEY, key, cachedElement);
            Weather weather = (Weather)cachedElement.getValue();
            return weather;
        }
        Weather weather = this.weatherDao.getWeather(locationCode, unit);
        cachedElement = new Element((Serializable)((Object)key), (Serializable)weather);
        this.logDebugInformation(ADDING_WEATHER_TO_CACHE_KEY, key, cachedElement);
        this.weatherDataCache.put(cachedElement);
        return weather;
    }

    private String createKeyFromLocationAndUnitOfMeasure(String locationCode, TemperatureUnit temperatureUnitOfMeasure) {
        String key = String.format(WEATHER_KEY_TEMPLATE, locationCode, temperatureUnitOfMeasure.toString());
        return key;
    }

    private void logDebugInformation(String message, String value, Element cachedElement) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(message, (Object)value, (Object)cachedElement.getValue().toString());
        }
    }

    @Autowired
    public void setWeatherDao(IWeatherDao weatherDao) {
        this.weatherDao = weatherDao;
    }

    @Override
    public String getWeatherProviderLink() {
        return this.weatherDao.getWeatherProviderLink();
    }

    @Override
    public String getWeatherProviderName() {
        return this.weatherDao.getWeatherProviderName();
    }

    public void setWeatherSearchCache(Cache weatherSearchCache) {
        this.weatherSearchCache = weatherSearchCache;
    }

    public void setWeatherDataCache(Cache weatherDataCache) {
        this.weatherDataCache = weatherDataCache;
    }
}

