/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.weather.dao.yahoo;

import java.io.IOException;
import java.io.InputStream;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodRetryHandler;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.NoHttpResponseException;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.apache.commons.io.IOUtils;
import org.jasig.portlet.weather.InvalidConfigurationException;
import org.jasig.portlet.weather.QuietUrlCodec;
import org.jasig.portlet.weather.TemperatureUnit;
import org.jasig.portlet.weather.dao.IWeatherDao;
import org.jasig.portlet.weather.dao.yahoo.IYahooLocationParsingService;
import org.jasig.portlet.weather.dao.yahoo.IYahooWeatherParsingService;
import org.jasig.portlet.weather.domain.Location;
import org.jasig.portlet.weather.domain.Weather;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.context.support.DefaultMessageSourceResolvable;
import org.springframework.dao.DataRetrievalFailureException;

public class YahooWeatherDaoImpl
implements IWeatherDao,
DisposableBean,
InitializingBean {
    private static final String FIND_URL = "https://query.yahooapis.com/v1/public/yql?q=select%20*%20from%20geo.places(10)%20where%20text%3D%22@QUERY@%22";
    private static final String WEATHER_URL = "https://query.yahooapis.com/v1/public/yql?q=select%20*%20from%20weather.forecast%20where%20woeid%3D@LOCATION@%20and%20u%3D%22@UNIT@%22";
    private static final String ERR_API_MISSING_KEY = "exception.missing.APIKey";
    private static final String ERR_GENERAL_KEY = "exception.generalError.title";
    private IYahooWeatherParsingService weatherParsingService;
    private IYahooLocationParsingService locationParsingService;
    private String key;
    private MessageSource messageSource;
    private final MultiThreadedHttpConnectionManager connectionManager = new MultiThreadedHttpConnectionManager();
    private final HttpClient httpClient = new HttpClient((HttpConnectionManager)this.connectionManager);
    private int connectionTimeout = 5000;
    private int readTimeout = 5000;
    private int timesToRetry = 5;

    public void setWeatherParsingService(IYahooWeatherParsingService parser) {
        this.weatherParsingService = parser;
    }

    public void setLocationParsingService(IYahooLocationParsingService parser) {
        this.locationParsingService = parser;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public void setTimesToRetry(int timesToRetry) {
        this.timesToRetry = timesToRetry;
    }

    public void afterPropertiesSet() throws Exception {
        HttpConnectionManager httpConnectionManager = this.httpClient.getHttpConnectionManager();
        HttpConnectionManagerParams params = httpConnectionManager.getParams();
        params.setConnectionTimeout(this.connectionTimeout);
        params.setSoTimeout(this.readTimeout);
        params.setParameter("http.method.retry-handler", (Object)new HttpMethodRetryHandler(){

            public boolean retryMethod(HttpMethod method, IOException exception, int executionCount) {
                if (executionCount >= YahooWeatherDaoImpl.this.timesToRetry) {
                    return false;
                }
                if (exception instanceof NoHttpResponseException) {
                    return true;
                }
                if (exception instanceof SocketException) {
                    return true;
                }
                if (exception instanceof SocketTimeoutException) {
                    return true;
                }
                return !method.isRequestSent();
            }
        });
    }

    public void destroy() throws Exception {
        this.connectionManager.shutdown();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Collection<Location> find(String location) {
        List<Location> list;
        if (this.key == null || this.key.length() == 0) {
            DefaultMessageSourceResolvable resolvable = new DefaultMessageSourceResolvable(new String[]{ERR_API_MISSING_KEY, ERR_GENERAL_KEY});
            throw new InvalidConfigurationException(this.messageSource.getMessage((MessageSourceResolvable)resolvable, Locale.getDefault()));
        }
        String url = FIND_URL.replace("@KEY@", this.key).replace("@QUERY@", QuietUrlCodec.encode(location, "UTF-8"));
        GetMethod getMethod = new GetMethod(url);
        InputStream inputStream = null;
        try {
            List<Location> locations;
            int statusCode = this.httpClient.executeMethod((HttpMethod)getMethod);
            if (statusCode != 200) {
                String statusText = getMethod.getStatusText();
                throw new DataRetrievalFailureException("get of '" + url + "' failed with status '" + statusCode + "' due to '" + statusText + "'");
            }
            inputStream = getMethod.getResponseBodyAsStream();
            list = locations = this.locationParsingService.parseLocations(inputStream);
        }
        catch (HttpException e) {
            try {
                throw new RuntimeException("http protocol exception while getting data from weather service from: " + url, e);
                catch (IOException e2) {
                    throw new RuntimeException("IO exception while getting data from weather service from: " + url, e2);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream);
                getMethod.releaseConnection();
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        getMethod.releaseConnection();
        return list;
    }

    @Override
    public Weather getWeather(String locationCode, TemperatureUnit unit) {
        String yahooweatherUrl = WEATHER_URL.replace("@LOCATION@", QuietUrlCodec.encode(locationCode, "UTF-8")).replace("@UNIT@", TemperatureUnit.C.equals((Object)unit) ? "c" : "f");
        return (Weather)this.getAndDeserialize(yahooweatherUrl);
    }

    @Override
    public String getWeatherProviderName() {
        return "Yahoo! Weather";
    }

    @Override
    public String getWeatherProviderLink() {
        return "https://weather.yahoo.com";
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object getAndDeserialize(String url) {
        Weather weather;
        GetMethod getMethod = new GetMethod(url);
        InputStream inputStream = null;
        try {
            int statusCode = this.httpClient.executeMethod((HttpMethod)getMethod);
            if (statusCode != 200) {
                String statusText = getMethod.getStatusText();
                throw new DataRetrievalFailureException("get of '" + url + "' failed with status '" + statusCode + "' due to '" + statusText + "'");
            }
            inputStream = getMethod.getResponseBodyAsStream();
            weather = this.weatherParsingService.parseWeather(inputStream);
        }
        catch (HttpException e) {
            try {
                throw new RuntimeException("http protocol exception while getting data from weather service from: " + url, e);
                catch (IOException e2) {
                    throw new RuntimeException("IO exception while getting data from weather service from: " + url, e2);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream);
                getMethod.releaseConnection();
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        getMethod.releaseConnection();
        return weather;
    }
}

