/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.my.webproxy.beans.cache;

import edu.wisc.my.webproxy.beans.cache.CacheEntry;
import edu.wisc.my.webproxy.beans.cache.PageCache;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class CacheOutputStream
extends OutputStream {
    private final OutputStream out;
    private final CacheEntry entryBase;
    private final String key;
    private final PageCache cache;
    private final boolean persistData;
    private ByteArrayOutputStream cacheBuffer = new ByteArrayOutputStream(1024);

    public CacheOutputStream(OutputStream out, CacheEntry entryBase, PageCache cache, String cacheKey, boolean persistData) {
        if (cache == null) {
            throw new IllegalArgumentException("cache cannot be null");
        }
        if (cacheKey == null) {
            throw new IllegalArgumentException("cacheKey cannot be null");
        }
        this.out = out;
        this.entryBase = entryBase;
        this.key = cacheKey;
        this.cache = cache;
        this.persistData = persistData;
    }

    public void close() throws IOException {
        if (this.cacheBuffer == null) {
            throw new IllegalStateException("close() has already been called.");
        }
        this.entryBase.setContent(this.cacheBuffer.toByteArray());
        this.cache.cachePage(this.key, this.entryBase, this.persistData);
        this.cacheBuffer = null;
        if (this.out != null) {
            this.out.close();
        }
    }

    public void flush() throws IOException {
        if (this.cacheBuffer == null) {
            throw new IllegalStateException("close() has already been called.");
        }
        if (this.out != null) {
            this.out.flush();
        }
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (this.cacheBuffer == null) {
            throw new IllegalStateException("close() has already been called.");
        }
        this.cacheBuffer.write(b, off, len);
        if (this.out != null) {
            this.out.write(b, off, len);
        }
    }

    public void write(byte[] b) throws IOException {
        if (this.cacheBuffer == null) {
            throw new IllegalStateException("close() has already been called.");
        }
        this.cacheBuffer.write(b);
        if (this.out != null) {
            this.out.write(b);
        }
    }

    public void write(int b) throws IOException {
        if (this.cacheBuffer == null) {
            throw new IllegalStateException("close() has already been called.");
        }
        this.cacheBuffer.write(b);
        if (this.out != null) {
            this.out.write(b);
        }
    }
}

