/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.my.webproxy.beans.cache.oscache;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Average {
    private static final Log LOG = LogFactory.getLog(Average.class);
    private final long minSize;
    private final long initialSize;
    private final long maxSize;
    private final Object AVERAGE_LOCK = new Object();
    private double currentAverage;
    private long count = 1L;

    public Average() {
        this(1024L, 10240L, 524288L);
    }

    public Average(long min, long initial, long max) {
        if (min > initial || initial > max) {
            throw new IllegalArgumentException("Constraing 'min <= initial <= max' violated min='" + min + "', initial='" + initial + "', max='" + max + "'");
        }
        this.minSize = min;
        this.initialSize = initial;
        this.maxSize = max;
        this.currentAverage = this.initialSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSize(double size) {
        Object object = this.AVERAGE_LOCK;
        synchronized (object) {
            ++this.count;
            double ratio = (double)(this.count - 1L) / (double)this.count;
            this.currentAverage = this.currentAverage * ratio + size / (double)this.count;
            if (this.currentAverage < (double)this.minSize) {
                this.currentAverage = this.minSize;
            } else if (this.currentAverage > (double)this.maxSize) {
                this.currentAverage = this.maxSize;
            }
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Updated average to '" + this.currentAverage + "'"));
        }
    }

    public void updateSize(long size) {
        this.updateSize((double)size);
    }

    public void updateSize(int size) {
        this.updateSize((double)size);
    }

    public double getDoubleAverage() {
        return this.currentAverage;
    }

    public long getLongAverage() {
        return (long)this.currentAverage;
    }

    public int getIntAverage() {
        return (int)this.currentAverage;
    }
}

