/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.my.webproxy.beans.cache.oscache;

import com.opensymphony.oscache.base.Config;
import com.opensymphony.oscache.base.persistence.CachePersistenceException;
import com.opensymphony.oscache.base.persistence.PersistenceListener;
import java.util.MissingResourceException;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DelegatingPersistenceListener
implements PersistenceListener {
    public static final String DELEGATE_CLASS_PROP = "cache.persistence.delegateClass";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private PersistenceListener delegateListener;

    public DelegatingPersistenceListener() {
        this(null);
    }

    public DelegatingPersistenceListener(PersistenceListener delegate) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("DelegatingPersistenceListener(" + delegate + ")"));
        }
        this.delegateListener = delegate;
    }

    public PersistenceListener getDelegateListener() {
        return this.delegateListener;
    }

    public void setDelegateListener(PersistenceListener delegateListener) {
        this.delegateListener = delegateListener;
    }

    protected String getDelegateClassPropertyName() {
        return DELEGATE_CLASS_PROP;
    }

    public final PersistenceListener configure(Config config) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("configure(" + config.getProperties() + ")"));
        }
        this.loadDelegatePersistenceListener(config);
        this.configureInternal(config);
        this.delegateListener = this.delegateListener.configure(config);
        return this;
    }

    protected void configureInternal(Config config) {
    }

    private void loadDelegatePersistenceListener(Config config) {
        Class<?> delegateClass;
        String delegateClassProperty = this.getDelegateClassPropertyName();
        String delegateClassName = config.getProperty(delegateClassProperty);
        if (delegateClassName == null) {
            if (this.delegateListener == null) {
                throw new IllegalArgumentException("'" + delegateClassProperty + "' is not set but required");
            }
            return;
        }
        if (this.delegateListener != null) {
            this.logger.warn((Object)("A delegate PersistenceListener is already configured, it will be overriden. delegate='" + this.delegateListener.getClass() + "'"));
        }
        try {
            delegateClass = Class.forName(delegateClassName);
        }
        catch (ClassNotFoundException cnfe) {
            MissingResourceException mre = new MissingResourceException("Can not find delegate PersistenceListener class='" + delegateClassName + "'", this.getClass().getName(), delegateClassName);
            mre.initCause(cnfe);
            throw mre;
        }
        try {
            this.delegateListener = (PersistenceListener)delegateClass.newInstance();
        }
        catch (InstantiationException ie) {
            MissingResourceException mre = new MissingResourceException("Could not instantiate delegate PersistenceListener class='" + delegateClassName + "'", this.getClass().getName(), delegateClassName);
            mre.initCause(ie);
            throw mre;
        }
        catch (IllegalAccessException iae) {
            MissingResourceException mre = new MissingResourceException("Could not instantiate delegate PersistenceListener class='" + delegateClassName + "'", this.getClass().getName(), delegateClassName);
            mre.initCause(iae);
            throw mre;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Using persistence class: " + this.delegateListener.getClass()));
        }
    }

    public boolean isStored(String key) throws CachePersistenceException {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("isStored(" + key + ")"));
        }
        return this.delegateListener.isStored(key);
    }

    public boolean isGroupStored(String groupName) throws CachePersistenceException {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("isGroupStored(" + groupName + ")"));
        }
        return this.delegateListener.isGroupStored(groupName);
    }

    public void clear() throws CachePersistenceException {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)"clear()");
        }
        this.delegateListener.clear();
    }

    public void remove(String key) throws CachePersistenceException {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("remove(" + key + ")"));
        }
        this.delegateListener.remove(key);
    }

    public void removeGroup(String groupName) throws CachePersistenceException {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("removeGroup(" + groupName + ")"));
        }
        this.delegateListener.removeGroup(groupName);
    }

    public Object retrieve(String key) throws CachePersistenceException {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("retrieve(" + key + ")"));
        }
        return this.delegateListener.retrieve(key);
    }

    public void store(String key, Object obj) throws CachePersistenceException {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("store(" + key + ", " + obj + ")"));
        }
        this.delegateListener.store(key, obj);
    }

    public void storeGroup(String groupName, Set group) throws CachePersistenceException {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("storeGroup(" + groupName + ", " + group + ")"));
        }
        this.delegateListener.storeGroup(groupName, group);
    }

    public Set retrieveGroup(String groupName) throws CachePersistenceException {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("retrieveGroup(" + groupName + ")"));
        }
        return this.delegateListener.retrieveGroup(groupName);
    }
}

