/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.my.webproxy.beans.cache.oscache;

import com.opensymphony.oscache.base.CacheEntry;
import com.opensymphony.oscache.base.Config;
import com.opensymphony.oscache.base.persistence.CachePersistenceException;
import edu.wisc.my.webproxy.beans.cache.oscache.CacheUtils;
import edu.wisc.my.webproxy.beans.cache.oscache.DelegatingPersistenceListener;
import java.util.Set;

public class FilteringPersistenceListener
extends DelegatingPersistenceListener {
    public static final String DELEGATE_CLASS_PROP = "cache.persistence.filter.delegateClass";
    public static final String PERSISTED_GROUPS_PROP = "cache.persistence.filter.groups";
    private Set persistedGroups;

    public Set getPersistedGroups() {
        return this.persistedGroups;
    }

    public void setPersistedGroups(Set persistedGroups) {
        this.persistedGroups = persistedGroups;
    }

    protected String getDelegateClassPropertyName() {
        return DELEGATE_CLASS_PROP;
    }

    protected void configureInternal(Config config) {
        String groups = config.getProperty(PERSISTED_GROUPS_PROP);
        if (groups == null) {
            if (this.persistedGroups == null) {
                throw new IllegalArgumentException("'cache.persistence.filter.groups' is not set but required or setPersistedGroups must be called.");
            }
            return;
        }
        if (this.persistedGroups != null) {
            this.logger.warn((Object)("PersistedGroups is already set to '" + this.persistedGroups + "', they will be overriden by the groups defined by '" + PERSISTED_GROUPS_PROP + "'"));
        }
        this.persistedGroups = CacheUtils.splitStringToSet((String)groups, (String)",");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Persisting groups matching: " + this.persistedGroups));
        }
    }

    public boolean isGroupStored(String groupName) throws CachePersistenceException {
        return this.isGroupCachable(groupName) && super.isGroupStored(groupName);
    }

    public void removeGroup(String groupName) throws CachePersistenceException {
        if (this.isGroupCachable(groupName)) {
            super.removeGroup(groupName);
        }
    }

    public void store(String key, Object obj) throws CachePersistenceException {
        if (this.isObjectCachable(obj)) {
            super.store(key, obj);
        }
    }

    public void storeGroup(String groupName, Set group) throws CachePersistenceException {
        if (this.isGroupCachable(groupName)) {
            super.storeGroup(groupName, group);
        }
    }

    public Set retrieveGroup(String groupName) throws CachePersistenceException {
        if (this.isGroupCachable(groupName)) {
            return super.retrieveGroup(groupName);
        }
        return null;
    }

    private boolean isObjectCachable(Object obj) {
        if (obj instanceof CacheEntry) {
            CacheEntry entry = (CacheEntry)obj;
            Set entryGroups = entry.getGroups();
            if (entryGroups != null) {
                for (String groupName : entryGroups) {
                    if (!this.persistedGroups.contains(groupName)) continue;
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Object='" + obj + "' is cachable because it is in group='" + groupName + "'"));
                    }
                    return true;
                }
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Object='" + obj + "' is not in any cachable groups"));
            }
            return false;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Object='" + obj + "' is no of type='" + CacheEntry.class + "' so it cannot be filtered and is not cachable."));
        }
        return false;
    }

    private boolean isGroupCachable(String groupName) {
        return this.persistedGroups.contains(groupName);
    }
}

