/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.my.webproxy.beans.cache.oscache;

import com.opensymphony.oscache.base.Config;
import com.opensymphony.oscache.base.persistence.CachePersistenceException;
import com.opensymphony.oscache.base.persistence.PersistenceListener;
import edu.wisc.my.webproxy.beans.cache.oscache.JdbcPersistenceListener;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.SerializationException;
import org.apache.commons.lang.SerializationUtils;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.support.JdbcDaoSupport;
import org.springframework.jdbc.core.support.SqlLobValue;
import org.springframework.jdbc.support.lob.LobHandler;

public class JdbcPersistenceListener
extends JdbcDaoSupport
implements PersistenceListener {
    private ObjectExistsQuery objectExistsQuery;
    private AllObjectsDelete allObjectsDelete;
    private ObjectDelete objectDelete;
    private ObjectQuery objectQuery;
    private ObjectInsert objectInsert;
    private ObjectUpdate objectUpdate;
    private LobHandler lobHandler;

    public LobHandler getLobHandler() {
        return this.lobHandler;
    }

    public void setLobHandler(LobHandler lobHandler) {
        this.lobHandler = lobHandler;
    }

    protected void initDao() throws Exception {
        this.objectExistsQuery = new ObjectExistsQuery(this, this.getDataSource());
        this.allObjectsDelete = new AllObjectsDelete(this, this.getDataSource());
        this.objectDelete = new ObjectDelete(this, this.getDataSource());
        this.objectQuery = new ObjectQuery(this, this.getDataSource());
        this.objectInsert = new ObjectInsert(this, this.getDataSource());
        this.objectUpdate = new ObjectUpdate(this, this.getDataSource());
    }

    public boolean isStored(String key) throws CachePersistenceException {
        return this.isStored(key, StoredObjectType.OBJECT);
    }

    public boolean isGroupStored(String groupName) throws CachePersistenceException {
        return this.isStored(groupName, StoredObjectType.GROUP);
    }

    public void clear() throws CachePersistenceException {
        this.allObjectsDelete.update();
    }

    public PersistenceListener configure(Config config) {
        return this;
    }

    public void remove(String key) throws CachePersistenceException {
        this.remove(key, StoredObjectType.OBJECT);
    }

    public void removeGroup(String groupName) throws CachePersistenceException {
        this.remove(groupName, StoredObjectType.GROUP);
    }

    public Object retrieve(String key) throws CachePersistenceException {
        return this.retrieve(key, StoredObjectType.OBJECT);
    }

    public Set retrieveGroup(String groupName) throws CachePersistenceException {
        return (Set)this.retrieve(groupName, StoredObjectType.GROUP);
    }

    public void store(String key, Object obj) throws CachePersistenceException {
        this.store(key, StoredObjectType.OBJECT, obj);
    }

    public void storeGroup(String groupName, Set keys) throws CachePersistenceException {
        this.store(groupName, StoredObjectType.GROUP, (Object)keys);
    }

    protected boolean isStored(String key, StoredObjectType type) {
        Object[] args = new Object[]{key, type.toString()};
        List results = this.objectExistsQuery.execute(args);
        return results.size() > 0;
    }

    protected void remove(String key, StoredObjectType type) {
        Object[] args = new Object[]{key, type.toString()};
        int rowsDeleted = this.objectDelete.update(args);
        if (rowsDeleted != 1) {
            this.logger.warn((Object)("Deleting Object of type='" + type + "' for key='" + key + "' resulted in " + rowsDeleted + " rows deleted. Expected 1 row deleted."));
        }
    }

    protected Object retrieve(String key, StoredObjectType type) {
        Object obj;
        Object[] args = new Object[]{key, type.toString()};
        List results = this.objectQuery.execute(args);
        byte[] serializedObject = (byte[])DataAccessUtils.uniqueResult((Collection)results);
        if (serializedObject == null) {
            return null;
        }
        try {
            obj = SerializationUtils.deserialize((byte[])serializedObject);
        }
        catch (SerializationException se) {
            this.logger.error((Object)("Could not deserialize Object for key='" + key + "' and type='" + type + "'"), (Throwable)se);
            return null;
        }
        return obj;
    }

    protected void store(String key, StoredObjectType type, Object obj) {
        byte[] serializedObject;
        if (obj != null) {
            try {
                serializedObject = SerializationUtils.serialize((Serializable)((Serializable)obj));
            }
            catch (SerializationException se) {
                this.logger.error((Object)("Could not serialize Object='" + obj + "' for key='" + key + "' and type='" + type + "'"), (Throwable)se);
                return;
            }
        } else {
            serializedObject = null;
        }
        boolean exists = this.isStored(key, type);
        if (!exists) {
            Object[] args = new Object[]{key, type.toString(), new SqlLobValue(serializedObject, this.lobHandler)};
            int rowsCreated = this.objectInsert.update(args);
            if (rowsCreated != 1) {
                this.logger.warn((Object)("Inserting Object='" + obj + "' for key='" + key + "' and type='" + type + "' resulted in " + rowsCreated + " rows created. Expected 1 row created."));
            }
        } else {
            Object[] args = new Object[]{new SqlLobValue(serializedObject, this.lobHandler), key, type.toString()};
            int rowsUpdated = this.objectUpdate.update(args);
            if (rowsUpdated != 1) {
                this.logger.warn((Object)("Updating Object='" + obj + "' for key='" + key + "' and type='" + type + "' resulted in " + rowsUpdated + " rows updated. Expected 1 row updated."));
            }
        }
    }

    static /* synthetic */ LobHandler access$000(JdbcPersistenceListener x0) {
        return x0.lobHandler;
    }
}

