/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.my.webproxy.beans.cache.oscache;

import com.opensymphony.oscache.base.Config;
import com.opensymphony.oscache.base.persistence.CachePersistenceException;
import com.opensymphony.oscache.base.persistence.PersistenceListener;
import edu.wisc.my.webproxy.beans.cache.oscache.CacheUtils;
import edu.wisc.my.webproxy.beans.cache.oscache.DelegatingPersistenceListener;
import edu.wisc.my.webproxy.beans.cache.oscache.KeyHashingPersistenceListener;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class KeyHashingPersistenceListener
extends DelegatingPersistenceListener {
    public static final String ALGORITHMS_PROP = "cache.persistence.hashing.algorithms";
    public static final String DELEGATE_CLASS_PROP = "cache.persistence.hashing.delegateClass";
    private static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final List<String> DEFAULT_ALGORITHMS;
    private final ObjectPool messageDigestPool;
    private List<String> hashAlgorithms = null;

    public KeyHashingPersistenceListener() {
        this(null);
    }

    public KeyHashingPersistenceListener(PersistenceListener delegate) {
        super(delegate);
        GenericObjectPool.Config config = new GenericObjectPool.Config();
        config.maxActive = -1;
        config.maxIdle = 32;
        config.whenExhaustedAction = (byte)2;
        config.testOnBorrow = false;
        config.testOnReturn = false;
        config.timeBetweenEvictionRunsMillis = 60000L;
        config.minEvictableIdleTimeMillis = -1L;
        config.testWhileIdle = false;
        this.messageDigestPool = new GenericObjectPool((PoolableObjectFactory)new MessageDigestorPoolableObjectFactory(this, null));
    }

    public List<String> getHashAlgorithms() {
        return this.hashAlgorithms;
    }

    public void setHashAlgorithms(List<String> hashAlgorithms) {
        this.hashAlgorithms = hashAlgorithms;
    }

    protected String getDelegateClassPropertyName() {
        return "cache.persistence.hashing.delegateClass";
    }

    protected void configureInternal(Config config) {
        String algorithmsList = config.getProperty("cache.persistence.hashing.algorithms");
        this.hashAlgorithms = algorithmsList != null ? CacheUtils.splitStringToList((String)algorithmsList, (String)",") : DEFAULT_ALGORITHMS;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Using hash algorithm list: " + this.hashAlgorithms));
        }
    }

    public boolean isGroupStored(String groupName) throws CachePersistenceException {
        String groupNameHash = this.getKeyHash(groupName);
        return super.isGroupStored(groupNameHash);
    }

    public boolean isStored(String key) throws CachePersistenceException {
        String keyHash = this.getKeyHash(key);
        return super.isStored(keyHash);
    }

    public void remove(String key) throws CachePersistenceException {
        String keyHash = this.getKeyHash(key);
        super.remove(keyHash);
    }

    public void removeGroup(String groupName) throws CachePersistenceException {
        String groupNameHash = this.getKeyHash(groupName);
        super.removeGroup(groupNameHash);
    }

    public Object retrieve(String key) throws CachePersistenceException {
        String keyHash = this.getKeyHash(key);
        return super.retrieve(keyHash);
    }

    public Set retrieveGroup(String groupName) throws CachePersistenceException {
        String groupNameHash = this.getKeyHash(groupName);
        return super.retrieveGroup(groupNameHash);
    }

    public void store(String key, Object obj) throws CachePersistenceException {
        String keyHash = this.getKeyHash(key);
        super.store(keyHash, obj);
    }

    public void storeGroup(String groupName, Set group) throws CachePersistenceException {
        String groupNameHash = this.getKeyHash(groupName);
        super.storeGroup(groupNameHash, group);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getKeyHash(String key) {
        MessageDigest digest = null;
        try {
            try {
                digest = (MessageDigest)this.messageDigestPool.borrowObject();
            }
            catch (Exception e) {
                this.logger.error((Object)("Error borrowing MessageDigest '" + digest + "' from the pool"));
            }
            if (digest != null) {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)("Using MessageDigest with hashCode=" + digest.hashCode()));
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Using '" + digest.getAlgorithm() + "' for key hashing."));
                }
                byte[] hash = digest.digest(key.getBytes());
                String hashString = KeyHashingPersistenceListener.byteArrayToHexString((byte[])hash);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Mapped key '" + key + "' to '" + hashString + "'."));
                }
                String string = hashString;
                return string;
            }
        }
        finally {
            if (digest != null) {
                try {
                    this.messageDigestPool.returnObject((Object)digest);
                }
                catch (Exception e) {
                    this.logger.error((Object)("Error returning MessageDigest '" + digest + "' to the pool"));
                }
            }
        }
        return Integer.toString(key.hashCode());
    }

    private static String byteArrayToHexString(byte[] in) {
        if (in == null || in.length <= 0) {
            return null;
        }
        StringBuffer out = new StringBuffer(in.length * 2);
        for (int byteIndex = 0; byteIndex < in.length; ++byteIndex) {
            byte charIndex = (byte)(in[byteIndex] & 0xF0);
            charIndex = (byte)(charIndex >>> 4);
            charIndex = (byte)(charIndex & 0xF);
            out.append(HEX_CHARS[charIndex]);
            charIndex = (byte)(in[byteIndex] & 0xF);
            out.append(HEX_CHARS[charIndex]);
        }
        return out.toString();
    }

    static /* synthetic */ List access$100(KeyHashingPersistenceListener x0) {
        return x0.hashAlgorithms;
    }

    static {
        ArrayList<String> algorithmsBuilder = new ArrayList<String>(6);
        algorithmsBuilder.add("SHA-512");
        algorithmsBuilder.add("SHA-384");
        algorithmsBuilder.add("SHA-256");
        algorithmsBuilder.add("SHA-1");
        algorithmsBuilder.add("MD5");
        algorithmsBuilder.add("MD2");
        DEFAULT_ALGORITHMS = Collections.unmodifiableList(algorithmsBuilder);
    }
}

