/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.my.webproxy.beans.cache.oscache;

import com.opensymphony.oscache.base.EntryRefreshPolicy;
import com.opensymphony.oscache.base.NeedsRefreshException;
import com.opensymphony.oscache.general.GeneralCacheAdministrator;
import edu.wisc.my.webproxy.beans.cache.CacheEntry;
import edu.wisc.my.webproxy.beans.cache.PageCache;
import edu.wisc.my.webproxy.beans.cache.oscache.CacheEntryRefreshPolicy;
import java.util.Properties;
import org.springframework.beans.factory.InitializingBean;

public class OsCachePageCache
implements PageCache,
InitializingBean {
    private static final EntryRefreshPolicy REFRESH_POLICY = new CacheEntryRefreshPolicy();
    private GeneralCacheAdministrator cacheAdmin;
    private Properties cacheProperties;

    public Properties getCacheProperties() {
        return this.cacheProperties;
    }

    public void setCacheProperties(Properties cacheProperties) {
        this.cacheProperties = cacheProperties;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.cacheProperties == null) {
            throw new IllegalStateException("cacheProperties must be set");
        }
        this.cacheAdmin = new GeneralCacheAdministrator(this.cacheProperties);
    }

    public void cachePage(String key, CacheEntry entry, boolean persistent) {
        if (persistent) {
            this.cacheAdmin.putInCache(key, (Object)entry, new String[]{"PERSIST"}, REFRESH_POLICY);
        } else {
            this.cacheAdmin.putInCache(key, (Object)entry, REFRESH_POLICY);
        }
    }

    public CacheEntry getCachedPage(String key) {
        return this.getCachedPage(key, false);
    }

    public CacheEntry getCachedPage(String key, boolean useExpired) {
        CacheEntry entry = null;
        try {
            entry = (CacheEntry)this.cacheAdmin.getFromCache(key);
        }
        catch (NeedsRefreshException nre) {
            if (useExpired) {
                entry = (CacheEntry)nre.getCacheContent();
            }
            this.cacheAdmin.cancelUpdate(key);
        }
        return entry;
    }

    public CacheEntry getCachedPage(String key, int maxCacheAge) {
        CacheEntry entry = null;
        try {
            entry = (CacheEntry)this.cacheAdmin.getFromCache(key, maxCacheAge);
        }
        catch (NeedsRefreshException nre) {
            this.cacheAdmin.cancelUpdate(key);
        }
        return entry;
    }
}

