/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.my.webproxy.beans.cache.oscache;

import com.opensymphony.oscache.base.Config;
import com.opensymphony.oscache.base.persistence.CachePersistenceException;
import com.opensymphony.oscache.base.persistence.PersistenceListener;
import edu.wisc.my.webproxy.portlet.ApplicationContextLocator;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;

public class SpringLocatingPersistenceListener
implements PersistenceListener {
    public static final String BEAN_NAME_PROP = "cache.persistence.spring.beanName";
    private static final Set<String> initializedBeans = new HashSet();
    protected final Log logger = LogFactory.getLog(this.getClass());
    private String beanName;
    private Config config;

    public SpringLocatingPersistenceListener() {
        this(null);
    }

    public SpringLocatingPersistenceListener(String beanName) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("SpringLocatingPersistenceListener(" + beanName + ")"));
        }
        this.beanName = beanName;
    }

    protected String getBeanNamePropertyName() {
        return BEAN_NAME_PROP;
    }

    public final PersistenceListener configure(Config config) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("configure(" + config.getProperties() + ")"));
        }
        this.loadDelegateBeanName(config);
        this.configureInternal(config);
        this.config = config;
        return this;
    }

    protected void configureInternal(Config config) {
    }

    private void loadDelegateBeanName(Config config) {
        String delegateClassProperty = this.getBeanNamePropertyName();
        this.beanName = config.getProperty(delegateClassProperty);
    }

    public boolean isStored(String key) throws CachePersistenceException {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("isStored(" + key + ")"));
        }
        return this.getSpringConfiguredListener().isStored(key);
    }

    public boolean isGroupStored(String groupName) throws CachePersistenceException {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("isGroupStored(" + groupName + ")"));
        }
        return this.getSpringConfiguredListener().isGroupStored(groupName);
    }

    public void clear() throws CachePersistenceException {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)"clear()");
        }
        this.getSpringConfiguredListener().clear();
    }

    public void remove(String key) throws CachePersistenceException {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("remove(" + key + ")"));
        }
        this.getSpringConfiguredListener().remove(key);
    }

    public void removeGroup(String groupName) throws CachePersistenceException {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("removeGroup(" + groupName + ")"));
        }
        this.getSpringConfiguredListener().removeGroup(groupName);
    }

    public Object retrieve(String key) throws CachePersistenceException {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("retrieve(" + key + ")"));
        }
        return this.getSpringConfiguredListener().retrieve(key);
    }

    public void store(String key, Object obj) throws CachePersistenceException {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("store(" + key + ", " + obj + ")"));
        }
        this.getSpringConfiguredListener().store(key, obj);
    }

    public void storeGroup(String groupName, Set group) throws CachePersistenceException {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("storeGroup(" + groupName + ", " + group + ")"));
        }
        this.getSpringConfiguredListener().storeGroup(groupName, group);
    }

    public Set retrieveGroup(String groupName) throws CachePersistenceException {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("retrieveGroup(" + groupName + ")"));
        }
        return this.getSpringConfiguredListener().retrieveGroup(groupName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PersistenceListener getSpringConfiguredListener() {
        ApplicationContext context = ApplicationContextLocator.getApplicationContext();
        if (context == null) {
            throw new IllegalStateException("Cannot retrieve ApplicationContext from ApplicationContextLocator. The SpringLocatingPersistenceListener cannot work without access to the ApplicationContext");
        }
        PersistenceListener listener = (PersistenceListener)context.getBean(this.beanName, PersistenceListener.class);
        if (listener == null) {
            throw new NoSuchBeanDefinitionException(this.beanName, "Cannot retrieve a PersistenceListener with bean name '" + this.beanName + "' from the ApplicationContext. The SpringLocatingPersistenceListener cannot work without a PersistenceListener");
        }
        Set set = initializedBeans;
        synchronized (set) {
            if (!initializedBeans.contains(this.beanName)) {
                listener.configure(this.config);
                initializedBeans.add(this.beanName);
            }
        }
        return listener;
    }
}

