/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.my.webproxy.beans.config;

import edu.wisc.my.webproxy.beans.config.ConfigUtils;
import edu.wisc.my.webproxy.beans.config.ConfigurationException;
import edu.wisc.my.webproxy.beans.config.JspConfigPage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletException;
import javax.portlet.PortletPreferences;

public class HttpClientConfigImpl
extends JspConfigPage {
    private static final String HTTPCLIENT_PREF_PREFIX = "webproxy.httpclient.";
    public static final String HTTP_TIMEOUT = new StringBuffer("edu.wisc.my.webproxy.").append("webproxy.httpclient.").append("httpTimeout").toString();
    public static final String MAX_REDIRECTS = new StringBuffer("edu.wisc.my.webproxy.").append("webproxy.httpclient.").append("redirects").toString();
    public static final String CIRCULAR_REDIRECTS = new StringBuffer("edu.wisc.my.webproxy.").append("webproxy.httpclient.").append("circularRedirects").toString();
    public static final String AUTH_TYPE = new StringBuffer("edu.wisc.my.webproxy.").append("webproxy.httpclient.").append("sAuthType").toString();
    public static final String AUTH_URL = new StringBuffer("edu.wisc.my.webproxy.").append("webproxy.httpclient.").append("sAuthenticationUrl").toString();
    public static final String AUTH_ENABLE = new StringBuffer("edu.wisc.my.webproxy.").append("webproxy.httpclient.").append("authEnable").toString();
    public static final String USER_NAME = new StringBuffer("edu.wisc.my.webproxy.").append("webproxy.httpclient.").append("userName").toString();
    public static final String PROMPT_USER_NAME = new StringBuffer("edu.wisc.my.webproxy.").append("webproxy.httpclient.").append("promptUserName").toString();
    public static final String PERSIST_USER_NAME = new StringBuffer("edu.wisc.my.webproxy.").append("webproxy.httpclient.").append("persistUserName").toString();
    public static final String PASSWORD = new StringBuffer("edu.wisc.my.webproxy.").append("webproxy.httpclient.").append("password").toString();
    public static final String PROMPT_PASSWORD = new StringBuffer("edu.wisc.my.webproxy.").append("webproxy.httpclient.").append("promptPassword").toString();
    public static final String PERSIST_PASSWORD = new StringBuffer("edu.wisc.my.webproxy.").append("webproxy.httpclient.").append("persistPassword").toString();
    public static final String SHARED_SESSION_KEY = new StringBuffer("edu.wisc.my.webproxy.").append("webproxy.httpclient.").append("sessionKey").toString();
    public static final String SESSION_PERSISTENCE_ENABLE = new StringBuffer("edu.wisc.my.webproxy.").append("webproxy.httpclient.").append("sessionPersistenceEnable").toString();
    public static final String DOMAIN = new StringBuffer("edu.wisc.my.webproxy.").append("webproxy.httpclient.").append("domain").toString();
    public static final String PROMPT_DOMAIN = new StringBuffer("edu.wisc.my.webproxy.").append("webproxy.httpclient.").append("promptDomain").toString();
    public static final String PERSIST_DOMAIN = new StringBuffer("edu.wisc.my.webproxy.").append("webproxy.httpclient.").append("persistDomain").toString();
    public static final String SESSION_TIMEOUT = new StringBuffer("edu.wisc.my.webproxy.").append("webproxy.httpclient.").append("sessionTimeout").toString();
    public static final String DYNAMIC_PARAM_NAMES = new StringBuffer("edu.wisc.my.webproxy.").append("webproxy.httpclient.").append("sDynamicParameterNames").toString();
    public static final String DYNAMIC_PARAM_VALUES = new StringBuffer("edu.wisc.my.webproxy.").append("webproxy.httpclient.").append("sDynamicParameterValues").toString();
    public static final String DYNAMIC_PARAM_PERSIST = new StringBuffer("edu.wisc.my.webproxy.").append("webproxy.httpclient.").append("sDynamicParameterPersist").toString();
    public static final String DYNAMIC_PARAM_SENSITIVE = new StringBuffer("edu.wisc.my.webproxy.").append("webproxy.httpclient.").append("sDynamicParameterSensitive").toString();
    public static final String STATIC_PARAM_NAMES = new StringBuffer("edu.wisc.my.webproxy.").append("webproxy.httpclient.").append("sStaticParameterNames").toString();
    public static final String STATIC_PARAM_VALUES = new StringBuffer("edu.wisc.my.webproxy.").append("webproxy.httpclient.").append("sStaticParameterValues").toString();
    public static final String AUTH_TYPE_BASIC = "BASIC";
    public static final String AUTH_TYPE_NTLM = "NTLM";
    public static final String AUTH_TYPE_FORM = "FORM";

    public String getName() {
        return "Http Configuration";
    }

    public void process(ActionRequest request, ActionResponse response) throws PortletException, IOException, ConfigurationException {
        String authType;
        StringBuffer errorMessages = new StringBuffer();
        PortletPreferences prefs = request.getPreferences();
        Boolean authEnable = new Boolean(request.getParameter(AUTH_ENABLE));
        prefs.setValue(AUTH_ENABLE, authEnable.toString());
        Boolean sessionPersistenceEnable = new Boolean(request.getParameter(SESSION_PERSISTENCE_ENABLE));
        prefs.setValue(SESSION_PERSISTENCE_ENABLE, sessionPersistenceEnable.toString());
        String maxRedirectsStr = null;
        try {
            maxRedirectsStr = ConfigUtils.checkEmptyNullString((String)request.getParameter(MAX_REDIRECTS), null);
            if (maxRedirectsStr != null && maxRedirectsStr.length() > 0) {
                Integer maxRedirects = new Integer(maxRedirectsStr);
                prefs.setValue(MAX_REDIRECTS, maxRedirects.toString());
            } else {
                prefs.setValue(MAX_REDIRECTS, "");
            }
        }
        catch (NumberFormatException nfe) {
            errorMessages.append("Invalid max redirects specified '").append(maxRedirectsStr).append("'\n");
        }
        Boolean circularRedirects = Boolean.valueOf(request.getParameter(CIRCULAR_REDIRECTS));
        prefs.setValue(CIRCULAR_REDIRECTS, circularRedirects.toString());
        String httpTimeoutStr = null;
        try {
            httpTimeoutStr = ConfigUtils.checkEmptyNullString((String)request.getParameter(HTTP_TIMEOUT), null);
            if (httpTimeoutStr != null && httpTimeoutStr.length() > 0) {
                Long httpTimeout = new Long(httpTimeoutStr);
                prefs.setValue(HTTP_TIMEOUT, httpTimeout.toString());
            } else {
                prefs.setValue(HTTP_TIMEOUT, "");
            }
        }
        catch (NumberFormatException nfe) {
            errorMessages.append("Invalid authorization timeout specified '").append(httpTimeoutStr).append("'\n");
        }
        String sessionTimeoutStr = null;
        try {
            sessionTimeoutStr = ConfigUtils.checkEmptyNullString((String)request.getParameter(SESSION_TIMEOUT), null);
            if (sessionTimeoutStr != null && sessionTimeoutStr.length() > 0) {
                Long sessionTimeout = new Long(sessionTimeoutStr);
                prefs.setValue(SESSION_TIMEOUT, sessionTimeout.toString());
            } else {
                prefs.setValue(SESSION_TIMEOUT, "");
            }
        }
        catch (NumberFormatException nfe) {
            errorMessages.append("Invalid authorization timeout specified '").append(sessionTimeoutStr).append("'\n");
        }
        String sessionKey = request.getParameter(SHARED_SESSION_KEY);
        if (sessionKey != null) {
            prefs.setValue(SHARED_SESSION_KEY, sessionKey);
        }
        if (AUTH_TYPE_BASIC.equals(authType = request.getParameter(AUTH_TYPE))) {
            prefs.setValue(AUTH_TYPE, AUTH_TYPE_BASIC);
        } else if (AUTH_TYPE_NTLM.equals(authType)) {
            prefs.setValue(AUTH_TYPE, AUTH_TYPE_NTLM);
        } else if (AUTH_TYPE_FORM.equals(authType)) {
            prefs.setValue(AUTH_TYPE, AUTH_TYPE_FORM);
        } else {
            errorMessages.append("Invalid authorization type specified '").append(authType).append("'\n");
        }
        String authUrl = ConfigUtils.checkEmptyNullString((String)request.getParameter(AUTH_URL), (String)"");
        prefs.setValue(AUTH_URL, authUrl);
        String userName = ConfigUtils.checkEmptyNullString((String)request.getParameter(USER_NAME), (String)"");
        prefs.setValue(USER_NAME, userName);
        Boolean promptUserName = new Boolean(request.getParameter(PROMPT_USER_NAME));
        prefs.setValue(PROMPT_USER_NAME, promptUserName.toString());
        Boolean persistUserName = new Boolean(request.getParameter(PERSIST_USER_NAME));
        prefs.setValue(PERSIST_USER_NAME, persistUserName.toString());
        String password = ConfigUtils.checkEmptyNullString((String)request.getParameter(PASSWORD), (String)"");
        prefs.setValue(PASSWORD, password);
        Boolean promptPassword = new Boolean(request.getParameter(PROMPT_PASSWORD));
        prefs.setValue(PROMPT_PASSWORD, promptPassword.toString());
        Boolean persistPassword = new Boolean(request.getParameter(PERSIST_PASSWORD));
        prefs.setValue(PERSIST_PASSWORD, persistPassword.toString());
        String[] dynamicParamNames = ConfigUtils.checkNullStringArray((String[])request.getParameterValues(DYNAMIC_PARAM_NAMES), (String[])new String[0]);
        String[] dynamicParamPersist = ConfigUtils.checkNullStringArray((String[])request.getParameterValues(DYNAMIC_PARAM_PERSIST), (String[])new String[0]);
        String[] dynamicParamSensitive = ConfigUtils.checkNullStringArray((String[])request.getParameterValues(DYNAMIC_PARAM_SENSITIVE), (String[])new String[0]);
        ArrayList<String> dynamicParamNamesList = new ArrayList<String>(dynamicParamNames.length);
        HashSet<String> dynamicParamPersistSet = new HashSet<String>(Arrays.asList(dynamicParamPersist));
        ArrayList<String> dynamicParamPersistList = new ArrayList<String>(dynamicParamPersistSet.size());
        HashSet<String> dynamicParamSensitiveSet = new HashSet<String>(Arrays.asList(dynamicParamSensitive));
        ArrayList<String> dynamicParamSensitiveList = new ArrayList<String>(dynamicParamSensitiveSet.size());
        for (int index = 0; index < dynamicParamNames.length; ++index) {
            String paramName = ConfigUtils.checkEmptyNullString((String)dynamicParamNames[index], null);
            if (paramName == null) continue;
            dynamicParamNamesList.add(paramName);
            String indexStr = Integer.toString(index);
            if (dynamicParamPersistSet.contains(indexStr)) {
                dynamicParamPersistList.add(indexStr);
            }
            if (!dynamicParamSensitiveSet.contains(indexStr)) continue;
            dynamicParamSensitiveList.add(indexStr);
        }
        prefs.setValues(DYNAMIC_PARAM_NAMES, dynamicParamNamesList.toArray(new String[dynamicParamNamesList.size()]));
        prefs.setValues(DYNAMIC_PARAM_PERSIST, dynamicParamPersistList.toArray(new String[dynamicParamPersistList.size()]));
        prefs.setValues(DYNAMIC_PARAM_SENSITIVE, dynamicParamSensitiveList.toArray(new String[dynamicParamSensitiveList.size()]));
        String[] staticParamNames = ConfigUtils.checkNullStringArray((String[])request.getParameterValues(STATIC_PARAM_NAMES), (String[])new String[0]);
        String[] staticParamValues = ConfigUtils.checkNullStringArray((String[])request.getParameterValues(STATIC_PARAM_VALUES), (String[])new String[0]);
        if (staticParamNames.length == staticParamValues.length) {
            ArrayList<String> staticParamNamesList = new ArrayList<String>(staticParamNames.length);
            ArrayList<String> staticParamValuesList = new ArrayList<String>(staticParamValues.length);
            for (int index = 0; index < staticParamNames.length; ++index) {
                String paramName = ConfigUtils.checkEmptyNullString((String)staticParamNames[index], null);
                if (paramName == null) continue;
                String paramValue = ConfigUtils.checkEmptyNullString((String)staticParamValues[index], null);
                staticParamNamesList.add(ConfigUtils.checkEmptyNullString((String)paramName, (String)""));
                staticParamValuesList.add(ConfigUtils.checkEmptyNullString((String)paramValue, (String)""));
            }
            prefs.setValues(STATIC_PARAM_NAMES, staticParamNamesList.toArray(new String[staticParamNamesList.size()]));
            prefs.setValues(STATIC_PARAM_VALUES, staticParamValuesList.toArray(new String[staticParamValuesList.size()]));
        } else {
            errorMessages.append("Static parameter and value parameter lists have inconsistent lengths.\n");
        }
        if (errorMessages.length() > 0) {
            throw new ConfigurationException(errorMessages.toString());
        }
        prefs.store();
    }
}

