/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.my.webproxy.beans.filtering;

import edu.wisc.my.webproxy.beans.PortletPreferencesWrapper;
import edu.wisc.my.webproxy.beans.config.GeneralConfigImpl;
import edu.wisc.my.webproxy.beans.filtering.BaseUrlFilter;
import edu.wisc.my.webproxy.portlet.WebProxyPortlet;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class AbsoluteUrlFilter
extends BaseUrlFilter {
    private static final Log LOG = LogFactory.getLog(WebProxyPortlet.class);
    private String urlBase = null;
    private String urlPath = null;

    public AbsoluteUrlFilter() {
    }

    public AbsoluteUrlFilter(XMLReader parent) {
        super(parent);
    }

    public String rewriteUrl(String urlFragment) {
        StringBuffer sb = new StringBuffer();
        if (urlFragment.startsWith("#") || urlFragment.startsWith("//")) {
            sb.append(urlFragment);
        } else if (urlFragment.startsWith("/")) {
            sb.append(this.urlBase);
            sb.append(urlFragment);
        } else if (urlFragment.indexOf("://") == -1) {
            sb.append(this.urlBase);
            sb.append(this.urlPath);
            sb.append(urlFragment);
        } else {
            sb.append(urlFragment);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Rewriting '" + urlFragment + "' to '" + sb + "'"));
        }
        return sb.toString();
    }

    public void characters(char[] ch, int start, int len) throws SAXException {
        super.characters(ch, start, len);
    }

    public String getName() {
        return "Absolute URL Filter";
    }

    public void setRenderData(RenderRequest request, RenderResponse response) {
        this.setupFilter((PortletRequest)request);
        super.setRenderData(request, response);
    }

    public void setActionData(ActionRequest request, ActionResponse response) {
        this.setupFilter((PortletRequest)request);
        super.setActionData(request, response);
    }

    public void clearData() {
        super.clearData();
        this.urlPath = null;
        this.urlBase = null;
    }

    private void setupFilter(PortletRequest request) {
        int protocolSeperator;
        int baseIndex;
        PortletSession session = request.getPortletSession();
        String currentUrl = (String)session.getAttribute(GeneralConfigImpl.BASE_URL);
        if (currentUrl == null) {
            PortletPreferencesWrapper pp = new PortletPreferencesWrapper(request.getPreferences(), (Map)request.getAttribute("javax.portlet.userinfo"));
            currentUrl = pp.getValue(GeneralConfigImpl.BASE_URL, null);
        }
        if ((baseIndex = currentUrl.indexOf(47, (protocolSeperator = currentUrl.indexOf("://")) + 3)) < 0) {
            this.urlBase = currentUrl;
            this.urlPath = "/";
        } else {
            this.urlBase = currentUrl.substring(0, baseIndex);
            int lastSlash = currentUrl.lastIndexOf(47);
            this.urlPath = lastSlash >= 0 ? currentUrl.substring(baseIndex, lastSlash + 1) : "/";
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Current URL ='" + currentUrl + "'"));
            LOG.trace((Object)("URL Base ='" + this.urlBase + "'"));
            LOG.trace((Object)("URL Path ='" + this.urlPath + "'"));
        }
    }
}

