/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.my.webproxy.beans.filtering;

import edu.wisc.my.webproxy.beans.filtering.ChainingSaxFilter;
import java.io.IOException;
import java.io.OutputStream;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public final class HtmlOutputFilter
extends ChainingSaxFilter {
    private static final byte[] ENTITY_START = "&".getBytes();
    private static final byte[] ENTITY_END = ";".getBytes();
    private static final byte[] TAG_OPEN_START = "<".getBytes();
    private static final byte[] TAG_CLOSE_START = "</".getBytes();
    private static final byte[] TAG_END = ">".getBytes();
    private static final byte[] COMMENT_START = "<!--".getBytes();
    private static final byte[] COMMENT_END = "-->".getBytes();
    private static final byte[] QUOTE = "\"".getBytes();
    private static final byte[] EQUAL = "=".getBytes();
    private static final byte[] SPACE = " ".getBytes();
    private final OutputStream out;
    private String currentEntity = null;

    public HtmlOutputFilter(OutputStream out) {
        if (out == null) {
            throw new IllegalArgumentException("OutputStream cannot be null");
        }
        this.out = out;
    }

    public String getName() {
        return "Output Filter";
    }

    public void comment(char[] ch, int start, int length) throws SAXException {
        try {
            this.out.write(COMMENT_START);
            this.out.write(new String(ch, start, length).getBytes());
            this.out.write(COMMENT_END);
        }
        catch (IOException ioe) {
            throw new SAXException("Error writing data to output stream", ioe);
        }
    }

    public void startEntity(String name) throws SAXException {
        this.currentEntity = name;
        try {
            this.out.write(ENTITY_START);
            this.out.write(this.currentEntity.getBytes());
            this.out.write(ENTITY_END);
        }
        catch (IOException ioe) {
            throw new SAXException("Error writing data to output stream", ioe);
        }
    }

    public void endEntity(String name) throws SAXException {
        this.currentEntity = null;
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        try {
            if (this.currentEntity == null) {
                String chars = new String(ch, start, length);
                this.out.write(chars.getBytes());
            }
        }
        catch (IOException ioe) {
            throw new SAXException("Error writing data to output stream", ioe);
        }
    }

    public void endDocument() throws SAXException {
        try {
            this.out.flush();
        }
        catch (IOException ioe) {
            throw new SAXException("Error flushing output stream", ioe);
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        try {
            this.out.write(TAG_CLOSE_START);
            this.out.write(qName.getBytes());
            this.out.write(TAG_END);
        }
        catch (IOException ioe) {
            throw new SAXException("Error writing data to output stream", ioe);
        }
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        try {
            this.out.write(TAG_OPEN_START);
            this.out.write(qName.getBytes());
            for (int index = 0; index < atts.getLength(); ++index) {
                String name = atts.getQName(index);
                String value = atts.getValue(index);
                this.out.write(SPACE);
                this.out.write(name.getBytes());
                if (value == null) continue;
                this.out.write(EQUAL);
                this.out.write(QUOTE);
                this.out.write(value.getBytes());
                this.out.write(QUOTE);
            }
            this.out.write(TAG_END);
        }
        catch (IOException ioe) {
            throw new SAXException("Error writing data to output stream", ioe);
        }
    }
}

