/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.my.webproxy.beans.http;

import edu.wisc.my.webproxy.beans.http.Cookie;
import edu.wisc.my.webproxy.beans.http.Credentials;
import edu.wisc.my.webproxy.beans.http.HttpClientCookieImpl;
import edu.wisc.my.webproxy.beans.http.NtCredentials;
import edu.wisc.my.webproxy.beans.http.State;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.NTCredentials;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;

public class HttpClientStateImpl
implements State,
Serializable {
    private transient HttpState httpClientState;

    public HttpClientStateImpl() {
        this.httpClientState = new HttpState();
    }

    public HttpClientStateImpl(HttpState state) {
        this.httpClientState = state;
    }

    public Credentials getUserCredentials() {
        org.apache.commons.httpclient.Credentials creds = this.httpClientState.getCredentials(AuthScope.ANY);
        if (creds instanceof UsernamePasswordCredentials) {
            UsernamePasswordCredentials upCreds = (UsernamePasswordCredentials)creds;
            return new Credentials(upCreds.getUserName(), upCreds.getPassword());
        }
        if (creds instanceof NTCredentials) {
            NTCredentials ntCreds = (NTCredentials)creds;
            return new NtCredentials(ntCreds.getUserName(), ntCreds.getPassword(), ntCreds.getHost(), ntCreds.getDomain());
        }
        return null;
    }

    public Credentials getNTCredentials() {
        org.apache.commons.httpclient.Credentials creds = this.httpClientState.getProxyCredentials(AuthScope.ANY);
        if (creds instanceof UsernamePasswordCredentials) {
            UsernamePasswordCredentials upCreds = (UsernamePasswordCredentials)creds;
            return new Credentials(upCreds.getUserName(), upCreds.getPassword());
        }
        if (creds instanceof NTCredentials) {
            NTCredentials ntCreds = (NTCredentials)creds;
            return new NtCredentials(ntCreds.getUserName(), ntCreds.getPassword(), ntCreds.getHost(), ntCreds.getDomain());
        }
        return null;
    }

    public void addCookies(Cookie[] cookies) {
        if (cookies != null) {
            for (int i = 0; i < cookies.length; ++i) {
                this.addCookie(cookies[i]);
            }
        }
    }

    public void setUserCredentials(Credentials c) {
        if (c instanceof NtCredentials) {
            NtCredentials myCreds = (NtCredentials)c;
            NTCredentials ntCreds = new NTCredentials(myCreds.getUserName(), myCreds.getPassword(), myCreds.getHost(), myCreds.getDomain());
            this.httpClientState.setCredentials(AuthScope.ANY, (org.apache.commons.httpclient.Credentials)ntCreds);
        } else {
            UsernamePasswordCredentials creds = new UsernamePasswordCredentials(c.getUserName(), c.getPassword());
            this.httpClientState.setCredentials(AuthScope.ANY, (org.apache.commons.httpclient.Credentials)creds);
        }
    }

    public void setNTCredentials(Credentials c) {
        if (c instanceof NtCredentials) {
            NtCredentials myCreds = (NtCredentials)c;
            NTCredentials ntCreds = new NTCredentials(myCreds.getUserName(), myCreds.getPassword(), myCreds.getHost(), myCreds.getDomain());
            this.httpClientState.setProxyCredentials(AuthScope.ANY, (org.apache.commons.httpclient.Credentials)ntCreds);
        } else {
            UsernamePasswordCredentials creds = new UsernamePasswordCredentials(c.getUserName(), c.getPassword());
            this.httpClientState.setProxyCredentials(AuthScope.ANY, (org.apache.commons.httpclient.Credentials)creds);
        }
    }

    public Cookie createCookie() {
        HttpClientCookieImpl cookie = new HttpClientCookieImpl();
        return cookie;
    }

    public Credentials createUserCredentials(String userName, String password) {
        Credentials credentials = new Credentials(userName, password);
        return credentials;
    }

    public NTCredentials createNTCredentials(String userName, String password, String domain, String host) {
        NTCredentials credentails = new NTCredentials(userName, password, host, domain);
        return credentails;
    }

    public void addCookie(Cookie cookie) {
        if (cookie instanceof HttpClientCookieImpl) {
            this.httpClientState.addCookie(((HttpClientCookieImpl)cookie).getWrappedCookie());
        } else {
            org.apache.commons.httpclient.Cookie c = new org.apache.commons.httpclient.Cookie();
            c.setComment(cookie.getComment());
            c.setDomain(cookie.getDomain());
            c.setExpiryDate(cookie.getExpiryDate());
            c.setName(cookie.getName());
            c.setPath(cookie.getPath());
            c.setSecure(cookie.getSecure());
            c.setValue(cookie.getValue());
            c.setVersion(cookie.getVersion());
            this.httpClientState.addCookie(c);
        }
    }

    public Cookie[] getCookies() {
        org.apache.commons.httpclient.Cookie[] cookies = this.httpClientState.getCookies();
        Cookie[] myCookies = new Cookie[cookies.length];
        for (int index = 0; index < myCookies.length; ++index) {
            myCookies[index] = new HttpClientCookieImpl(cookies[index]);
        }
        return myCookies;
    }

    public void clearCookies() {
        this.httpClientState.clear();
    }

    protected HttpState getWrappedState() {
        return this.httpClientState;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        org.apache.commons.httpclient.Cookie[] cookies = this.httpClientState.getCookies();
        out.writeObject(cookies);
        org.apache.commons.httpclient.Credentials creds = this.httpClientState.getCredentials(AuthScope.ANY);
        this.writeCredentials(out, creds);
        org.apache.commons.httpclient.Credentials proxyCreds = this.httpClientState.getProxyCredentials(AuthScope.ANY);
        this.writeCredentials(out, proxyCreds);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.httpClientState = new HttpState();
        org.apache.commons.httpclient.Cookie[] cookies = (org.apache.commons.httpclient.Cookie[])in.readObject();
        this.httpClientState.addCookies(cookies);
        this.httpClientState.setCredentials(AuthScope.ANY, this.readCredentials(in));
        this.httpClientState.setProxyCredentials(AuthScope.ANY, this.readCredentials(in));
    }

    private void writeCredentials(ObjectOutputStream out, org.apache.commons.httpclient.Credentials creds) throws IOException {
        Credentials myCreds = new Credentials();
        if (creds instanceof NTCredentials) {
            NTCredentials ntCreds = (NTCredentials)creds;
            myCreds = new NtCredentials();
            myCreds.setUserName(ntCreds.getUserName());
            myCreds.setPassword(ntCreds.getPassword());
            ((NtCredentials)myCreds).setDomain(ntCreds.getDomain());
            ((NtCredentials)myCreds).setHost(ntCreds.getHost());
        } else if (creds instanceof UsernamePasswordCredentials) {
            UsernamePasswordCredentials upCreds = (UsernamePasswordCredentials)creds;
            myCreds.setUserName(upCreds.getUserName());
            myCreds.setPassword(upCreds.getPassword());
        }
        out.writeObject(myCreds);
    }

    private org.apache.commons.httpclient.Credentials readCredentials(ObjectInputStream in) throws IOException, ClassNotFoundException {
        Credentials creds = (Credentials)in.readObject();
        if (creds instanceof NtCredentials) {
            NtCredentials ntCreds = (NtCredentials)creds;
            return new NTCredentials(ntCreds.getUserName(), ntCreds.getPassword(), ntCreds.getHost(), ntCreds.getDomain());
        }
        if (creds.getUserName() != null && creds.getPassword() != null) {
            return new UsernamePasswordCredentials(creds.getUserName(), creds.getPassword());
        }
        return null;
    }
}

