/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.my.webproxy.beans.http;

import edu.wisc.my.webproxy.beans.config.HttpClientConfigImpl;
import edu.wisc.my.webproxy.beans.http.Header;
import edu.wisc.my.webproxy.beans.http.HttpClientStateImpl;
import edu.wisc.my.webproxy.beans.http.HttpManager;
import edu.wisc.my.webproxy.beans.http.HttpTimeoutException;
import edu.wisc.my.webproxy.beans.http.ParameterPair;
import edu.wisc.my.webproxy.beans.http.Request;
import edu.wisc.my.webproxy.beans.http.RequestImpl;
import edu.wisc.my.webproxy.beans.http.Response;
import edu.wisc.my.webproxy.beans.http.ResponseImpl;
import edu.wisc.my.webproxy.beans.http.State;
import java.io.IOException;
import javax.portlet.PortletPreferences;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.methods.PostMethod;

public final class HttpManagerImpl
extends HttpManager {
    private final HttpClient client = new HttpClient();

    public Response doRequest(Request request) throws HttpTimeoutException, IOException {
        GetMethod method;
        String requestType = request.getType();
        int indx = requestType.indexOf(35);
        if (indx != -1) {
            requestType = requestType.substring(0, indx);
        }
        if ("GET".equals(requestType)) {
            method = new GetMethod(request.getUrl());
        } else if ("POST".equals(requestType)) {
            method = new PostMethod(request.getUrl());
            ParameterPair[] postParameters = request.getParameters();
            if (postParameters != null) {
                NameValuePair[] realParameters = new NameValuePair[postParameters.length];
                for (int index = 0; index < postParameters.length; ++index) {
                    realParameters[index] = new NameValuePair(postParameters[index].getName(), postParameters[index].getValue());
                }
                ((PostMethod)method).addParameters(realParameters);
            }
        } else if ("HEAD".equals(requestType)) {
            method = new HeadMethod(request.getUrl());
        } else {
            throw new IllegalArgumentException("Unknown request type '" + requestType + "'");
        }
        if ("BASIC".equalsIgnoreCase(request.getAuthType())) {
            String username = request.getState().getUserCredentials().getUserName();
            String password = request.getState().getUserCredentials().getPassword();
            if (username == null && password == null) {
                throw new IllegalArgumentException("Both username and password are null for BASIC authentication");
            }
            UsernamePasswordCredentials creds = new UsernamePasswordCredentials(username, password);
            this.client.getState().setCredentials(AuthScope.ANY, (Credentials)creds);
            method.setDoAuthentication(true);
        }
        this.setStaticHeaders(request.getHeaders(), (HttpMethod)method);
        State state = request.getState();
        if (state != null) {
            HttpState httpState = ((HttpClientStateImpl)state).getWrappedState();
            this.client.setState(httpState);
        }
        return new ResponseImpl((HttpMethod)method, this.client);
    }

    public Request createRequest() {
        return new RequestImpl();
    }

    public String getName() {
        return "HTTP_Manager";
    }

    public void clearData() {
    }

    public void setup(PortletPreferences prefs) {
        String httpTimeoutStr = prefs.getValue(HttpClientConfigImpl.HTTP_TIMEOUT, "");
        try {
            int httpTimeout = Integer.parseInt(httpTimeoutStr);
            this.client.getHttpConnectionManager().getParams().setConnectionTimeout(httpTimeout * 1000);
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        String circularRedirectsStr = prefs.getValue(HttpClientConfigImpl.CIRCULAR_REDIRECTS, null);
        if (circularRedirectsStr != null) {
            this.client.getParams().setParameter("http.protocol.allow-circular-redirects", (Object)Boolean.valueOf(circularRedirectsStr));
        }
    }

    private void setStaticHeaders(Header[] headers, HttpMethod method) {
        if (headers != null) {
            for (int index = 0; index < headers.length; ++index) {
                method.setRequestHeader(headers[index].getName(), headers[index].getValue());
            }
        }
    }
}

