/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.my.webproxy.beans.http;

import edu.wisc.my.webproxy.beans.http.Cookie;
import edu.wisc.my.webproxy.beans.http.JdbcStateStore;
import edu.wisc.my.webproxy.beans.http.State;
import edu.wisc.my.webproxy.beans.http.StateStore;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.SerializationException;
import org.apache.commons.lang.SerializationUtils;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.support.JdbcDaoSupport;
import org.springframework.jdbc.core.support.SqlLobValue;
import org.springframework.jdbc.support.lob.LobHandler;

public class JdbcStateStore
extends JdbcDaoSupport
implements StateStore {
    private StateExistsQuery stateExistsQuery;
    private StateInsert stateInsert;
    private StateUpdate stateUpdate;
    private StateQuery stateQuery;
    private StateDelete stateDelete;
    private AllStatesDelete allStatesDelete;
    private LobHandler lobHandler;

    public LobHandler getLobHandler() {
        return this.lobHandler;
    }

    public void setLobHandler(LobHandler lobHandler) {
        this.lobHandler = lobHandler;
    }

    protected void initDao() throws Exception {
        this.stateExistsQuery = new StateExistsQuery(this, this.getDataSource());
        this.stateInsert = new StateInsert(this, this.getDataSource());
        this.stateUpdate = new StateUpdate(this, this.getDataSource());
        this.stateQuery = new StateQuery(this, this.getDataSource());
        this.stateDelete = new StateDelete(this, this.getDataSource());
        this.allStatesDelete = new AllStatesDelete(this, this.getDataSource());
    }

    public void storeState(String key, State state) {
        byte[] serializedState;
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null.");
        }
        if (state == null) {
            throw new IllegalArgumentException("state cannot be null.");
        }
        try {
            serializedState = SerializationUtils.serialize((Serializable)state);
        }
        catch (SerializationException se) {
            this.logger.error((Object)("Could not serialize State='" + state + "' for key='" + key + "'"), (Throwable)se);
            return;
        }
        List results = this.stateExistsQuery.execute(key);
        if (results.size() == 0) {
            Object[] args = new Object[]{key, new SqlLobValue(serializedState, this.lobHandler)};
            int rowsCreated = this.stateInsert.update(args);
            if (rowsCreated != 1) {
                this.logger.warn((Object)("Inserting State='" + state + "' for key='" + key + "' resulted in " + rowsCreated + " rows created. Expected 1 row created."));
            }
        } else {
            Object[] args = new Object[]{new SqlLobValue(serializedState, this.lobHandler), key};
            int rowsUpdated = this.stateUpdate.update(args);
            if (rowsUpdated != 1) {
                this.logger.warn((Object)("Updating State='" + state + "' for key='" + key + "' resulted in " + rowsUpdated + " rows updated. Expected 1 row updated."));
            }
        }
    }

    public State getState(String key) {
        State state;
        List results = this.stateQuery.execute(key);
        byte[] serializedState = (byte[])DataAccessUtils.uniqueResult((Collection)results);
        if (serializedState == null) {
            return null;
        }
        try {
            state = (State)SerializationUtils.deserialize((byte[])serializedState);
        }
        catch (SerializationException se) {
            this.logger.error((Object)("Could not deserialize State for key='" + key + "'"), (Throwable)se);
            return null;
        }
        this.purgeCookies(state);
        return state;
    }

    public void deleteState(String key) {
        int rowsDeleted = this.stateDelete.update(key);
        if (rowsDeleted != 1) {
            this.logger.warn((Object)("Deleting State for key='" + key + "' resulted in " + rowsDeleted + " rows deleted. Expected 1 row deleted."));
        }
    }

    public void clearAll() {
        int rowsDeleted = this.allStatesDelete.update();
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Deleting all states resulted in " + rowsDeleted + " rows deleted."));
        }
    }

    protected void purgeCookies(State state) {
        Cookie[] cookies = state.getCookies();
        if (cookies != null) {
            ArrayList<Cookie> validCookies = new ArrayList<Cookie>(cookies.length);
            for (Cookie cookie : cookies) {
                if (cookie.getExpiryDate() == null || cookie.isExpired()) continue;
                validCookies.add(cookie);
            }
            state.clearCookies();
            if (validCookies.size() > 0) {
                state.addCookies(validCookies.toArray(new Cookie[validCookies.size()]));
            }
        }
    }

    static /* synthetic */ LobHandler access$000(JdbcStateStore x0) {
        return x0.lobHandler;
    }
}

