/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.my.webproxy.beans.http;

import edu.wisc.my.webproxy.beans.http.Header;
import edu.wisc.my.webproxy.beans.http.HeaderImpl;
import edu.wisc.my.webproxy.beans.http.HttpClientStateImpl;
import edu.wisc.my.webproxy.beans.http.HttpTimeoutException;
import edu.wisc.my.webproxy.beans.http.Response;
import edu.wisc.my.webproxy.beans.http.State;
import edu.wisc.my.webproxy.portlet.WebProxyPortlet;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.httpclient.ConnectTimeoutException;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ResponseImpl
implements Response {
    private static final Log LOG = LogFactory.getLog(WebProxyPortlet.class);
    HttpMethod method;
    HttpClient client;

    public ResponseImpl(HttpMethod method, HttpClient client) throws HttpTimeoutException, IOException {
        this.client = client;
        this.method = method;
        try {
            int statusCode = client.executeMethod(method);
            if (statusCode != 200) {
                LOG.info((Object)("Method failed: " + method.getStatusLine()));
            }
        }
        catch (ConnectTimeoutException cte) {
            throw new HttpTimeoutException((Throwable)cte);
        }
    }

    public InputStream getResponseBodyAsStream() {
        InputStream is = null;
        try {
            is = this.method.getResponseBodyAsStream();
        }
        catch (IOException e) {
            LOG.error((Object)"Caught an IOException when retrieving the response body: ", (Throwable)e);
        }
        return is;
    }

    public String getContentType() {
        String contentType = null;
        org.apache.commons.httpclient.Header header = this.method.getResponseHeader("Content-Type");
        if (header != null) {
            contentType = header.getValue();
        }
        return contentType;
    }

    public State getState() {
        HttpState httpState = this.client.getState();
        HttpClientStateImpl state = new HttpClientStateImpl(httpState);
        return state;
    }

    public Header[] getHeaders() {
        org.apache.commons.httpclient.Header[] httpClientHeaders = this.method.getResponseHeaders();
        Header[] myHeaders = new Header[httpClientHeaders.length];
        for (int i = 0; i < httpClientHeaders.length; ++i) {
            myHeaders[i] = new HeaderImpl(httpClientHeaders[i].getName(), httpClientHeaders[i].getValue());
        }
        return myHeaders;
    }

    public int getStatusCode() {
        return this.method.getStatusCode();
    }

    public String getRequestUrl() {
        try {
            return this.method.getURI().toString();
        }
        catch (URIException uRIException) {
            return null;
        }
    }

    public void close() {
        this.method.releaseConnection();
    }
}

