/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.my.webproxy.portlet;

import edu.wisc.my.webproxy.beans.PortletPreferencesWrapper;
import edu.wisc.my.webproxy.beans.cache.CacheEntry;
import edu.wisc.my.webproxy.beans.cache.CacheOutputStream;
import edu.wisc.my.webproxy.beans.cache.PageCache;
import edu.wisc.my.webproxy.beans.config.CacheConfigImpl;
import edu.wisc.my.webproxy.beans.config.ConfigPage;
import edu.wisc.my.webproxy.beans.config.ConfigUtils;
import edu.wisc.my.webproxy.beans.config.GeneralConfigImpl;
import edu.wisc.my.webproxy.beans.config.HttpClientConfigImpl;
import edu.wisc.my.webproxy.beans.config.HttpHeaderConfigImpl;
import edu.wisc.my.webproxy.beans.config.StaticHtmlConfigImpl;
import edu.wisc.my.webproxy.beans.filtering.ChainingSaxFilter;
import edu.wisc.my.webproxy.beans.filtering.HtmlOutputFilter;
import edu.wisc.my.webproxy.beans.filtering.HtmlParser;
import edu.wisc.my.webproxy.beans.http.Credentials;
import edu.wisc.my.webproxy.beans.http.Header;
import edu.wisc.my.webproxy.beans.http.HttpManager;
import edu.wisc.my.webproxy.beans.http.HttpTimeoutException;
import edu.wisc.my.webproxy.beans.http.NtCredentials;
import edu.wisc.my.webproxy.beans.http.ParameterPair;
import edu.wisc.my.webproxy.beans.http.Request;
import edu.wisc.my.webproxy.beans.http.Response;
import edu.wisc.my.webproxy.beans.http.State;
import edu.wisc.my.webproxy.beans.http.StateStore;
import edu.wisc.my.webproxy.beans.interceptors.PostInterceptor;
import edu.wisc.my.webproxy.beans.interceptors.PreInterceptor;
import edu.wisc.my.webproxy.portlet.ApplicationContextLocator;
import edu.wisc.my.webproxy.portlet.WebproxyConstants;
import edu.wisc.my.webproxy.servlet.SessionMappingListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletSession;
import javax.portlet.ReadOnlyException;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ValidatorException;
import javax.portlet.WindowState;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.web.portlet.context.PortletApplicationContextUtils;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;

/*
 * Exception performing whole class analysis ignored.
 */
public class WebProxyPortlet
extends GenericPortlet {
    private static final Log LOG = LogFactory.getLog(WebProxyPortlet.class);
    private static final String HEADER = "/WEB-INF/jsp/header.jsp";
    private static final String FOOTER = "/WEB-INF/jsp/footer.jsp";
    private static final String MANUAL = "/WEB-INF/jsp/manual.jsp";
    public static final String preferenceKey = WebProxyPortlet.class.getName();
    private static WebProxyPortlet instance = null;

    public static WebProxyPortlet getInstances() {
        return instance;
    }

    public void destroy() {
        super.destroy();
        instance = null;
    }

    public void init() throws PortletException {
        super.init();
        instance = this;
    }

    public void render(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        this.doDispatch(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doDispatch(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        block9: {
            ApplicationContext context = PortletApplicationContextUtils.getWebApplicationContext((PortletContext)this.getPortletContext());
            ApplicationContextLocator.setApplicationContext((ApplicationContext)context);
            try {
                PortletMode mode = request.getPortletMode();
                WindowState windowState = request.getWindowState();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Rendering with PortletMode='" + mode + "' and WindowState='" + windowState + "'"));
                }
                if (windowState.equals((Object)WindowState.MINIMIZED)) break block9;
                if (PortletMode.VIEW.equals((Object)mode) || PortletMode.EDIT.equals((Object)mode)) {
                    if (!this.manualLogin(request, response)) {
                        this.renderContent(request, response);
                    }
                    break block9;
                }
                if (WebproxyConstants.CONFIG_MODE.equals((Object)mode)) {
                    ConfigPage currentConfig = this.getConfig(request.getPortletSession());
                    PortletRequestDispatcher headerDispatch = this.getPortletContext().getRequestDispatcher("/WEB-INF/jsp/header.jsp");
                    headerDispatch.include(request, response);
                    try {
                        currentConfig.render(this.getPortletContext(), request, response);
                    }
                    catch (PortletException pe) {
                        LOG.error((Object)"Caught an exception trying to retreive portlet preferences in configuration mode: ", (Throwable)pe);
                    }
                    PortletRequestDispatcher footerDispatch = this.getPortletContext().getRequestDispatcher("/WEB-INF/jsp/footer.jsp");
                    footerDispatch.include(request, response);
                    break block9;
                }
                throw new PortletException("'" + mode + "' Not Implemented");
            }
            finally {
                ApplicationContextLocator.setApplicationContext(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void renderContent(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        String cacheKey;
        PageCache cache;
        CacheEntry cachedData;
        String sTemp;
        ApplicationContext context = PortletApplicationContextUtils.getWebApplicationContext((PortletContext)this.getPortletContext());
        Map userInfo = (Map)request.getAttribute("javax.portlet.userinfo");
        PortletPreferences myPreferences = request.getPreferences();
        myPreferences = new PortletPreferencesWrapper(myPreferences, userInfo);
        PortletSession session = request.getPortletSession();
        session.setAttribute("edu.wisc.my.webproxy.namespace", (Object)response.getNamespace());
        String sUrl = (String)session.getAttribute(GeneralConfigImpl.BASE_URL);
        if (sUrl == null && (sUrl = ConfigUtils.checkEmptyNullString((String)myPreferences.getValue(GeneralConfigImpl.BASE_URL, null), null)) == null) {
            throw new PortletException("No Initial URL Configured");
        }
        PortletMode mode = request.getPortletMode();
        if (PortletMode.EDIT.equals((Object)mode) && (sTemp = myPreferences.getValue(GeneralConfigImpl.EDIT_URL, null)) != null) {
            sUrl = sTemp;
        }
        String sRequestType = request.getParameter(WebproxyConstants.REQUEST_TYPE) != null ? request.getParameter(WebproxyConstants.REQUEST_TYPE) : null;
        HttpManager httpManager = (HttpManager)context.getBean("HttpManagerBean", HttpManager.class);
        httpManager.setRenderData(request, response);
        this.doFormAuth(httpManager, (PortletRequest)request);
        boolean sUseCache = new Boolean(myPreferences.getValue(CacheConfigImpl.USE_CACHE, null));
        if (sUseCache && (cachedData = (cache = (PageCache)context.getBean("PageCache", PageCache.class)).getCachedPage(cacheKey = WebProxyPortlet.generateCacheKey((String)sUrl, (String)response.getNamespace()))) != null) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Using cached content for key '" + cacheKey + "'"));
            }
            response.setContentType(cachedData.getContentType());
            response.getPortletOutputStream().write(cachedData.getContent());
            return;
        }
        State httpState = this.getState((PortletRequest)request);
        Response httpResponse = null;
        boolean redirect = true;
        int maxRedirects = ConfigUtils.parseInt((String)myPreferences.getValue(HttpClientConfigImpl.MAX_REDIRECTS, null), (int)5);
        for (int index = 0; index < maxRedirects && redirect; ++index) {
            String tempUrl;
            Request httpRequest = httpManager.createRequest();
            httpRequest.setState(httpState);
            this.doHttpAuth((PortletRequest)request, httpRequest);
            httpRequest.setUrl(sUrl);
            String[] headerNames = myPreferences.getValues(HttpHeaderConfigImpl.HEADER_NAME, new String[0]);
            String[] headerValues = myPreferences.getValues(HttpHeaderConfigImpl.HEADER_VALUE, new String[0]);
            if (headerNames.length == headerValues.length) {
                ArrayList<Header> headerList = new ArrayList<Header>(headerNames.length);
                for (int headerIndex = 0; headerIndex < headerNames.length; ++headerIndex) {
                    Header h = httpRequest.createHeader();
                    h.setName(headerNames[headerIndex]);
                    h.setValue(headerValues[headerIndex]);
                    headerList.add(h);
                }
                httpRequest.setHeaders(headerList.toArray(new Header[headerList.size()]));
            } else {
                LOG.error((Object)"Invalid data in preferences. Header name array length does not equal header value array length");
            }
            if (sRequestType == null) {
                httpRequest.setType("GET");
            } else {
                httpRequest.setType(sRequestType);
                if (sRequestType.equals("POST")) {
                    ArrayList<ParameterPair> postParameters = new ArrayList<ParameterPair>(request.getParameterMap().size());
                    Enumeration e = request.getParameterNames();
                    while (e.hasMoreElements()) {
                        String paramName = (String)e.nextElement();
                        if (paramName.startsWith("edu.wisc.my.webproxy.")) continue;
                        String[] values = request.getParameterValues(paramName);
                        for (int valIndex = 0; valIndex < values.length; ++valIndex) {
                            ParameterPair param = new ParameterPair(paramName, values[valIndex]);
                            postParameters.add(param);
                        }
                    }
                    ParameterPair[] params = postParameters.toArray(new ParameterPair[postParameters.size()]);
                    httpRequest.setParameters(params);
                }
            }
            String sPreInterceptor = ConfigUtils.checkEmptyNullString((String)myPreferences.getValue(GeneralConfigImpl.PRE_INTERCEPTOR_CLASS, null), null);
            if (sPreInterceptor != null) {
                String msg;
                try {
                    Class<?> preInterceptorClass = Class.forName(sPreInterceptor);
                    PreInterceptor myPreInterceptor = (PreInterceptor)preInterceptorClass.newInstance();
                    myPreInterceptor.intercept(request, response, httpRequest);
                }
                catch (ClassNotFoundException cnfe) {
                    msg = "Could not find specified pre-interceptor class '" + sPreInterceptor + "'";
                    LOG.error((Object)msg, (Throwable)cnfe);
                    throw new PortletException(msg, (Throwable)cnfe);
                }
                catch (InstantiationException ie) {
                    msg = "Could instatiate specified pre-interceptor class '" + sPreInterceptor + "'";
                    LOG.error((Object)msg, (Throwable)ie);
                    throw new PortletException(msg, (Throwable)ie);
                }
                catch (IllegalAccessException iae) {
                    msg = "Could instatiate specified pre-interceptor class '" + sPreInterceptor + "'";
                    LOG.error((Object)msg, (Throwable)iae);
                    throw new PortletException(msg, (Throwable)iae);
                }
                catch (ClassCastException cce) {
                    msg = "Could not cast '" + sPreInterceptor + "' to 'edu.wisc.my.webproxy.beans.interceptors.PreInterceptor'";
                    LOG.error((Object)msg, (Throwable)cce);
                    throw new PortletException(msg, (Throwable)cce);
                }
            }
            try {
                httpResponse = httpManager.doRequest(httpRequest);
            }
            catch (HttpTimeoutException hte) {
                boolean sUseExpired = new Boolean(myPreferences.getValue(CacheConfigImpl.USE_EXPIRED, null));
                if (sUseCache && sUseExpired) {
                    LOG.info((Object)("Request '" + sUrl + "' timed out. Attempting to use expired cache data."));
                    PageCache cache2 = (PageCache)context.getBean("PageCache", PageCache.class);
                    String cacheKey2 = WebProxyPortlet.generateCacheKey((String)sUrl, (String)response.getNamespace());
                    CacheEntry cachedData2 = cache2.getCachedPage(cacheKey2, true);
                    if (cachedData2 != null) {
                        int retryDelay = ConfigUtils.parseInt((String)myPreferences.getValue(CacheConfigImpl.RETRY_DELAY, null), (int)-1);
                        if (retryDelay > 0) {
                            boolean persistData = new Boolean(myPreferences.getValue(CacheConfigImpl.PERSIST_CACHE, null));
                            cachedData2.setExpirationDate(new Date(System.currentTimeMillis() + (long)(retryDelay * 1000)));
                            cache2.cachePage(cacheKey2, cachedData2, persistData);
                        }
                        if (LOG.isTraceEnabled()) {
                            LOG.trace((Object)("Using cached content for key '" + cacheKey2 + "'"));
                        }
                        response.setContentType(cachedData2.getContentType());
                        response.getPortletOutputStream().write(cachedData2.getContent());
                        if (httpResponse == null) return;
                        httpResponse.close();
                        return;
                    }
                }
                LOG.warn((Object)("Request '" + httpRequest + "' timed out"), (Throwable)hte);
                throw hte;
            }
            session.setAttribute(HttpClientConfigImpl.SESSION_TIMEOUT, (Object)new Long(System.currentTimeMillis()));
            String sPostInterceptor = ConfigUtils.checkEmptyNullString((String)myPreferences.getValue(GeneralConfigImpl.POST_INTERCEPTOR_CLASS, null), null);
            if (sPostInterceptor != null) {
                String msg;
                try {
                    Class<?> postInterceptorClass = Class.forName(sPostInterceptor);
                    PostInterceptor myPostInterceptor = (PostInterceptor)postInterceptorClass.newInstance();
                    myPostInterceptor.intercept(request, response, httpResponse);
                }
                catch (ClassNotFoundException cnfe) {
                    msg = "Could not find specified post-interceptor class '" + sPostInterceptor + "'";
                    LOG.error((Object)msg, (Throwable)cnfe);
                    throw new PortletException(msg, (Throwable)cnfe);
                }
                catch (InstantiationException ie) {
                    msg = "Could instatiate specified post-interceptor class '" + sPostInterceptor + "'";
                    LOG.error((Object)msg, (Throwable)ie);
                    throw new PortletException(msg, (Throwable)ie);
                }
                catch (IllegalAccessException iae) {
                    msg = "Could instatiate specified post-interceptor class '" + sPostInterceptor + "'";
                    LOG.error((Object)msg, (Throwable)iae);
                    throw new PortletException(msg, (Throwable)iae);
                }
                catch (ClassCastException cce) {
                    msg = "Could not cast '" + sPostInterceptor + "' to 'edu.wisc.my.webproxy.beans.interceptors.PostInterceptor'";
                    LOG.error((Object)msg, (Throwable)cce);
                    throw new PortletException(msg, (Throwable)cce);
                }
            }
            if ((httpState = httpResponse.getState()) != null) {
                this.storeState((PortletRequest)request, httpState);
            }
            if (sUrl.equals(tempUrl = WebProxyPortlet.checkRedirect((String)sUrl, (Response)httpResponse))) {
                redirect = false;
                continue;
            }
            sUrl = tempUrl;
        }
        String realUrl = httpResponse.getRequestUrl();
        String sContentType = httpResponse.getContentType();
        if (sContentType != null) {
            StringTokenizer st = new StringTokenizer(sContentType, ";");
            sContentType = st.nextToken();
        } else {
            sContentType = "text/html";
        }
        if ("unknown".equals(sContentType)) {
            sContentType = "text/html";
        }
        List acceptedContent = (List)context.getBean("ContentTypeBean", List.class);
        boolean matches = false;
        Iterator iterateContent = acceptedContent.iterator();
        while (iterateContent.hasNext() && !matches) {
            String sAcceptedContent = (String)iterateContent.next();
            Pattern contentPattern = Pattern.compile(sAcceptedContent, 2);
            Matcher contentMatcher = contentPattern.matcher(sContentType);
            matches = contentMatcher.matches();
        }
        response.setContentType(sContentType);
        InputStream in = null;
        OutputStream out = null;
        try {
            String sHeader;
            in = httpResponse.getResponseBodyAsStream();
            out = response.getPortletOutputStream();
            if (!matches) {
                return;
            }
            if (realUrl != null) {
                sUrl = realUrl;
            }
            session.setAttribute(GeneralConfigImpl.BASE_URL, (Object)sUrl);
            if (PortletMode.EDIT.equals((Object)mode)) {
                out.write(this.createBackButton(response).getBytes());
            }
            if (sUseCache) {
                PageCache cache3 = (PageCache)context.getBean("PageCache", PageCache.class);
                String cacheKey3 = WebProxyPortlet.generateCacheKey((String)sUrl, (String)response.getNamespace());
                int cacheExprTime = ConfigUtils.parseInt((String)myPreferences.getValue(CacheConfigImpl.CACHE_TIMEOUT, null), (int)-1);
                boolean persistData = new Boolean(myPreferences.getValue(CacheConfigImpl.PERSIST_CACHE, null));
                CacheEntry entryBase = new CacheEntry();
                entryBase.setContentType(sContentType);
                if (cacheExprTime >= 0) {
                    entryBase.setExpirationDate(new Date(System.currentTimeMillis() + (long)(cacheExprTime * 1000)));
                }
                out = new CacheOutputStream(out, entryBase, cache3, cacheKey3, persistData);
            }
            if ((sHeader = ConfigUtils.checkEmptyNullString((String)myPreferences.getValue(StaticHtmlConfigImpl.STATIC_HEADER, null), null)) != null) {
                out.write(sHeader.getBytes());
            }
            HtmlParser htmlParser = (HtmlParser)context.getBean("HtmlParserBean", HtmlParser.class);
            HtmlOutputFilter outFilter = new HtmlOutputFilter(out);
            try {
                htmlParser.setRenderData(request, response);
                List saxFilters = (List)context.getBean("SaxFilterBean", List.class);
                ChainingSaxFilter parent = null;
                Iterator filterItr = saxFilters.iterator();
                if (filterItr.hasNext()) {
                    parent = (ChainingSaxFilter)filterItr.next();
                    outFilter.setParent((XMLReader)parent);
                    while (filterItr.hasNext()) {
                        ChainingSaxFilter nextParent = (ChainingSaxFilter)filterItr.next();
                        parent.setParent((XMLReader)nextParent);
                        parent = nextParent;
                    }
                }
                outFilter.setRenderData(request, response);
                XMLReader xmlReader = htmlParser.getReader((LexicalHandler)parent);
                parent.setParent(xmlReader);
                try {
                    outFilter.parse(new InputSource(in));
                }
                catch (SAXException se) {
                    throw new PortletException("A error occured while parsing the content", (Throwable)se);
                }
                String sFooter = ConfigUtils.checkEmptyNullString((String)myPreferences.getValue(StaticHtmlConfigImpl.STATIC_FOOTER, null), null);
                if (sFooter == null) return;
                out.write(sFooter.getBytes());
                return;
            }
            finally {
                htmlParser.clearData();
                outFilter.clearData();
            }
        }
        finally {
            if (httpResponse != null) {
                httpResponse.close();
            }
        }
    }

    private String newGetUrl(String url, ActionRequest request) throws IOException {
        StringBuffer newUrl = new StringBuffer(url).append("?");
        Enumeration e = request.getParameterNames();
        while (e.hasMoreElements()) {
            String paramName = (String)e.nextElement();
            if (paramName.startsWith("edu.wisc.my.webproxy.")) continue;
            String[] values = request.getParameterValues(paramName);
            for (int valIndex = 0; valIndex < values.length; ++valIndex) {
                newUrl.append(URLEncoder.encode(paramName, "UTF-8")).append("=").append(URLEncoder.encode(values[valIndex], "UTF-8"));
                if (valIndex + 1 == values.length && !e.hasMoreElements()) continue;
                newUrl.append("&");
            }
        }
        return newUrl.toString();
    }

    private void doHttpAuth(PortletRequest portletRequest, Request httpRequest) {
        PortletPreferencesWrapper myPreferences = new PortletPreferencesWrapper(portletRequest.getPreferences(), (Map)portletRequest.getAttribute("javax.portlet.userinfo"));
        boolean authEnabled = new Boolean(myPreferences.getValue(HttpClientConfigImpl.AUTH_ENABLE, null));
        String authType = ConfigUtils.checkEmptyNullString((String)myPreferences.getValue(HttpClientConfigImpl.AUTH_TYPE, ""), (String)"");
        if (authEnabled && "BASIC".equals(authType) || "NTLM".equals(authType)) {
            Credentials creds;
            String password;
            PortletSession session = portletRequest.getPortletSession();
            String userName = (String)session.getAttribute(HttpClientConfigImpl.USER_NAME);
            if (userName == null) {
                userName = myPreferences.getValue(HttpClientConfigImpl.USER_NAME, "");
            }
            if ((password = (String)session.getAttribute(HttpClientConfigImpl.PASSWORD)) == null) {
                password = myPreferences.getValue(HttpClientConfigImpl.PASSWORD, "");
            }
            if ("BASIC".equals(authType)) {
                creds = new Credentials(userName, password);
            } else {
                String domain = (String)session.getAttribute(HttpClientConfigImpl.DOMAIN);
                if (domain == null) {
                    domain = myPreferences.getValue(HttpClientConfigImpl.DOMAIN, "");
                }
                String host = portletRequest.getProperty("REMOTE_HOST");
                creds = new NtCredentials(userName, password, domain, host);
            }
            State httpState = httpRequest.getState();
            httpState.setUserCredentials(creds);
            httpRequest.setState(httpState);
            httpRequest.setAuthType(authType);
        }
    }

    private String doFormAuth(HttpManager httpManager, PortletRequest request) throws PortletException, IOException {
        PortletSession session = request.getPortletSession();
        PortletPreferencesWrapper prefs = new PortletPreferencesWrapper(request.getPreferences(), (Map)request.getAttribute("javax.portlet.userinfo"));
        boolean authEnabled = new Boolean(prefs.getValue(HttpClientConfigImpl.AUTH_ENABLE, null));
        String authType = ConfigUtils.checkEmptyNullString((String)prefs.getValue(HttpClientConfigImpl.AUTH_TYPE, ""), (String)"");
        String sessionTimeoutStr = prefs.getValue(HttpClientConfigImpl.SESSION_TIMEOUT, null);
        long sessionTimeout = 25L;
        try {
            sessionTimeout = Long.parseLong(sessionTimeoutStr);
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        Long lastActivity = (Long)session.getAttribute(HttpClientConfigImpl.SESSION_TIMEOUT);
        boolean sessionExpired = lastActivity == null || lastActivity + (sessionTimeout *= 60000L) <= System.currentTimeMillis();
        if (authEnabled && sessionExpired && "FORM".equals(authType)) {
            ParameterPair pair;
            String value;
            String[] sStaticParameterNames = prefs.getValues(HttpClientConfigImpl.STATIC_PARAM_NAMES, new String[0]);
            String[] sStaticParameterValues = prefs.getValues(HttpClientConfigImpl.STATIC_PARAM_VALUES, new String[0]);
            String[] sDynamicParameterNames = prefs.getValues(HttpClientConfigImpl.DYNAMIC_PARAM_NAMES, new String[0]);
            String[] sDynamicParameterValues = new String[sDynamicParameterNames.length];
            String[] postAttributes = (String[])session.getAttribute(HttpClientConfigImpl.DYNAMIC_PARAM_VALUES);
            if (postAttributes != null) {
                for (int index = 0; index < postAttributes.length && index < sDynamicParameterValues.length; ++index) {
                    sDynamicParameterValues[index] = postAttributes[index];
                }
            }
            ArrayList<ParameterPair> sLoginAttributes = new ArrayList<ParameterPair>(sDynamicParameterNames.length + sStaticParameterNames.length);
            for (int dynamicIndex = 0; dynamicIndex < sDynamicParameterNames.length; ++dynamicIndex) {
                value = dynamicIndex < sDynamicParameterValues.length ? ConfigUtils.checkEmptyNullString((String)sDynamicParameterValues[dynamicIndex], (String)"") : "";
                pair = new ParameterPair(sDynamicParameterNames[dynamicIndex], value);
                sLoginAttributes.add(pair);
            }
            for (int staticIndex = 0; staticIndex < sStaticParameterNames.length; ++staticIndex) {
                value = staticIndex < sStaticParameterValues.length ? ConfigUtils.checkEmptyNullString((String)sStaticParameterValues[staticIndex], (String)"") : "";
                pair = new ParameterPair(sStaticParameterNames[staticIndex], value);
                sLoginAttributes.add(pair);
            }
            Request authPost = httpManager.createRequest();
            authPost.setType("POST");
            State storedState = this.getState(request);
            if (storedState != null) {
                authPost.setState(storedState);
            }
            String authUrl = ConfigUtils.checkEmptyNullString((String)prefs.getValue(HttpClientConfigImpl.AUTH_URL, ""), (String)"");
            authPost.setUrl(authUrl);
            authPost.setParameters(sLoginAttributes.toArray(new ParameterPair[sLoginAttributes.size()]));
            Response authResponse = httpManager.doRequest(authPost);
            session.setAttribute(HttpClientConfigImpl.SESSION_TIMEOUT, (Object)new Long(System.currentTimeMillis()));
            String redirUrl = WebProxyPortlet.checkRedirect((String)authUrl, (Response)authResponse);
            State postState = authResponse.getState();
            if (postState != null) {
                this.storeState(request, postState);
            }
            authResponse.close();
            if (!authUrl.equals(redirUrl)) {
                return redirUrl;
            }
            return null;
        }
        return null;
    }

    public static String generateCacheKey(String pageUrl, String namespace) {
        StringBuffer cacheKeyBuf = new StringBuffer();
        cacheKeyBuf.append(namespace);
        cacheKeyBuf.append(".");
        cacheKeyBuf.append(pageUrl);
        return cacheKeyBuf.toString();
    }

    public static String generateStateKey(String key, String namespace) {
        StringBuffer cacheKeyBuf = new StringBuffer();
        cacheKeyBuf.append(namespace);
        cacheKeyBuf.append(".");
        cacheKeyBuf.append(key);
        return cacheKeyBuf.toString();
    }

    private boolean manualLogin(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        PortletSession session = request.getPortletSession();
        PortletPreferences myPreferences = request.getPreferences();
        boolean authEnabled = new Boolean(myPreferences.getValue(HttpClientConfigImpl.AUTH_ENABLE, null));
        if (authEnabled) {
            String authType = myPreferences.getValue(HttpClientConfigImpl.AUTH_TYPE, null);
            if ("BASIC".equals(authType)) {
                String password;
                boolean userNamePrompt = new Boolean(myPreferences.getValue(HttpClientConfigImpl.PROMPT_USER_NAME, null));
                boolean passwordPrompt = new Boolean(myPreferences.getValue(HttpClientConfigImpl.PROMPT_PASSWORD, null));
                String userName = (String)session.getAttribute(HttpClientConfigImpl.USER_NAME);
                if (userName == null) {
                    userName = myPreferences.getValue(HttpClientConfigImpl.USER_NAME, null);
                }
                if ((password = (String)session.getAttribute(HttpClientConfigImpl.PASSWORD)) == null) {
                    password = myPreferences.getValue(HttpClientConfigImpl.PASSWORD, null);
                }
                userName = ConfigUtils.checkEmptyNullString((String)userName, null);
                password = ConfigUtils.checkEmptyNullString((String)password, null);
                if (userNamePrompt && userName == null || passwordPrompt && password == null) {
                    PortletRequestDispatcher manualLoginDispatch = this.getPortletContext().getRequestDispatcher("/WEB-INF/jsp/manual.jsp");
                    manualLoginDispatch.include(request, response);
                    return true;
                }
            } else if ("FORM".equals(authType)) {
                String[] dynamicParamNames = myPreferences.getValues(HttpClientConfigImpl.DYNAMIC_PARAM_NAMES, new String[0]);
                String[] dynamicParamValues = myPreferences.getValues(HttpClientConfigImpl.DYNAMIC_PARAM_VALUES, new String[dynamicParamNames.length]);
                String[] sessionDynamicParamValues = (String[])session.getAttribute(HttpClientConfigImpl.DYNAMIC_PARAM_VALUES);
                boolean emptyValue = false;
                for (int index = 0; index < dynamicParamValues.length; ++index) {
                    if (dynamicParamValues[index] == null && sessionDynamicParamValues != null && index < sessionDynamicParamValues.length) {
                        dynamicParamValues[index] = sessionDynamicParamValues[index];
                    }
                    if (dynamicParamValues[index] != null) continue;
                    emptyValue = true;
                }
                session.setAttribute(HttpClientConfigImpl.DYNAMIC_PARAM_VALUES, (Object)dynamicParamValues);
                if (emptyValue) {
                    PortletRequestDispatcher manualLoginDispatch = this.getPortletContext().getRequestDispatcher("/WEB-INF/jsp/manual.jsp");
                    manualLoginDispatch.include(request, response);
                    return true;
                }
            } else {
                throw new IllegalArgumentException("Unknown authType specified '" + authType + "'");
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processAction(ActionRequest request, ActionResponse response) throws PortletException, IOException {
        PortletMode mode = request.getPortletMode();
        WindowState windowState = request.getWindowState();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Processing action with PortletMode='" + mode + "' and WindowState='" + windowState + "'"));
        }
        PortletSession session = request.getPortletSession();
        Map userInfo = (Map)request.getAttribute("javax.portlet.userinfo");
        PortletPreferencesWrapper pp = new PortletPreferencesWrapper(request.getPreferences(), userInfo);
        String manualAuthSubmit = request.getParameter("AUTH_CREDS");
        if (manualAuthSubmit != null) {
            this.processManualAuthForm(request);
        } else if (request.getPortletMode().equals((Object)PortletMode.EDIT)) {
            if (ConfigUtils.checkEmptyNullString((String)request.getParameter("backButton"), null) != null) {
                response.setPortletMode(PortletMode.VIEW);
            }
        } else {
            ApplicationContext context = PortletApplicationContextUtils.getWebApplicationContext((PortletContext)this.getPortletContext());
            if (request.getPortletMode().equals((Object)WebproxyConstants.CONFIG_MODE)) {
                this.processConfigAction(request, response);
                return;
            }
            HttpManager httpManager = (HttpManager)context.getBean("HttpManagerBean", HttpManager.class);
            httpManager.setActionData(request, response);
            if (request.getPortletMode().equals((Object)PortletMode.EDIT)) {
                String sUrl = request.getParameter(GeneralConfigImpl.EDIT_URL);
                session.setAttribute(GeneralConfigImpl.EDIT_URL, (Object)sUrl);
                response.setPortletMode(PortletMode.VIEW);
                return;
            }
            String sUrl = request.getParameter(WebproxyConstants.BASE_URL);
            String sRequestType = request.getProperty("REQUEST_METHOD");
            if (request.getParameter("edu.wisc.my.webproxy..getMethod") != null) {
                sRequestType = "GET";
                sUrl = this.newGetUrl(sUrl, request);
            }
            this.doFormAuth(httpManager, (PortletRequest)request);
            String sContentType = null;
            State persistedState = this.getState((PortletRequest)request);
            Response httpResponse = null;
            try {
                boolean redirect = true;
                int maxRedirects = ConfigUtils.parseInt((String)pp.getValue(HttpClientConfigImpl.MAX_REDIRECTS, null), (int)5);
                for (int index = 0; index < maxRedirects && redirect; ++index) {
                    String tempUrl;
                    State state;
                    Request httpRequest = httpManager.createRequest();
                    httpRequest.setState(persistedState);
                    this.doHttpAuth((PortletRequest)request, httpRequest);
                    httpRequest.setUrl(sUrl);
                    httpRequest.setType("HEAD");
                    String[] headerNames = pp.getValues(HttpHeaderConfigImpl.HEADER_NAME, new String[0]);
                    String[] headerValues = pp.getValues(HttpHeaderConfigImpl.HEADER_VALUE, new String[0]);
                    if (headerNames.length == headerValues.length) {
                        ArrayList<Header> headerList = new ArrayList<Header>(headerNames.length);
                        for (int headerIndex = 0; headerIndex < headerNames.length; ++headerIndex) {
                            Header h = httpRequest.createHeader();
                            h.setName(headerNames[headerIndex]);
                            h.setValue(headerValues[headerIndex]);
                            headerList.add(h);
                        }
                        httpRequest.setHeaders(headerList.toArray(new Header[headerList.size()]));
                    } else {
                        LOG.error((Object)"Invalid data in preferences. Header name array length does not equal header value array length");
                    }
                    String sPreInterceptor = ConfigUtils.checkEmptyNullString((String)pp.getValue(GeneralConfigImpl.PRE_INTERCEPTOR_CLASS, null), null);
                    if (sPreInterceptor != null) {
                        String msg;
                        try {
                            Class<?> preInterceptorClass = Class.forName(sPreInterceptor);
                            PreInterceptor myPreInterceptor = (PreInterceptor)preInterceptorClass.newInstance();
                            myPreInterceptor.intercept(request, response, httpRequest);
                        }
                        catch (ClassNotFoundException cnfe) {
                            msg = "Could not find specified pre-interceptor class '" + sPreInterceptor + "'";
                            LOG.error((Object)msg, (Throwable)cnfe);
                            throw new PortletException(msg, (Throwable)cnfe);
                        }
                        catch (InstantiationException ie) {
                            msg = "Could instatiate specified pre-interceptor class '" + sPreInterceptor + "'";
                            LOG.error((Object)msg, (Throwable)ie);
                            throw new PortletException(msg, (Throwable)ie);
                        }
                        catch (IllegalAccessException iae) {
                            msg = "Could instatiate specified pre-interceptor class '" + sPreInterceptor + "'";
                            LOG.error((Object)msg, (Throwable)iae);
                            throw new PortletException(msg, (Throwable)iae);
                        }
                        catch (ClassCastException cce) {
                            msg = "Could not cast '" + sPreInterceptor + "' to 'edu.wisc.my.webproxy.beans.interceptors.PreInterceptor'";
                            LOG.error((Object)msg, (Throwable)cce);
                            throw new PortletException(msg, (Throwable)cce);
                        }
                    }
                    httpResponse = httpManager.doRequest(httpRequest);
                    session.setAttribute(HttpClientConfigImpl.SESSION_TIMEOUT, (Object)new Long(System.currentTimeMillis()));
                    String sPostInterceptor = ConfigUtils.checkEmptyNullString((String)pp.getValue(GeneralConfigImpl.POST_INTERCEPTOR_CLASS, null), null);
                    if (sPostInterceptor != null) {
                        String msg;
                        try {
                            Class<?> postInterceptorClass = Class.forName(sPostInterceptor);
                            PostInterceptor myPostInterceptor = (PostInterceptor)postInterceptorClass.newInstance();
                            myPostInterceptor.intercept(request, response, httpResponse);
                        }
                        catch (ClassNotFoundException cnfe) {
                            msg = "Could not find specified post-interceptor class '" + sPostInterceptor + "'";
                            LOG.error((Object)msg, (Throwable)cnfe);
                            throw new PortletException(msg, (Throwable)cnfe);
                        }
                        catch (InstantiationException ie) {
                            msg = "Could instatiate specified post-interceptor class '" + sPostInterceptor + "'";
                            LOG.error((Object)msg, (Throwable)ie);
                            throw new PortletException(msg, (Throwable)ie);
                        }
                        catch (IllegalAccessException iae) {
                            msg = "Could instatiate specified post-interceptor class '" + sPostInterceptor + "'";
                            LOG.error((Object)msg, (Throwable)iae);
                            throw new PortletException(msg, (Throwable)iae);
                        }
                        catch (ClassCastException cce) {
                            msg = "Could not cast '" + sPostInterceptor + "' to 'edu.wisc.my.webproxy.beans.interceptors.PostInterceptor'";
                            LOG.error((Object)msg, (Throwable)cce);
                            throw new PortletException(msg, (Throwable)cce);
                        }
                    }
                    if ((state = httpResponse.getState()) != null) {
                        this.storeState((PortletRequest)request, state);
                    }
                    if (!(tempUrl = WebProxyPortlet.checkRedirect((String)sUrl, (Response)httpResponse)).equals(sUrl)) continue;
                    redirect = false;
                }
                if (httpResponse.getContentType() != null) {
                    StringTokenizer st = new StringTokenizer(httpResponse.getContentType(), ";");
                    sContentType = st.nextToken();
                }
            }
            finally {
                if (httpResponse != null) {
                    httpResponse.close();
                }
            }
            boolean matches = false;
            if (sContentType != null) {
                List acceptedContent = (List)context.getBean("ContentTypeBean", List.class);
                String sAcceptedContent = null;
                Iterator iterateContent = acceptedContent.iterator();
                while (iterateContent.hasNext() && !matches) {
                    sAcceptedContent = (String)iterateContent.next();
                    Pattern contentPattern = Pattern.compile(sAcceptedContent, 2);
                    Matcher contentMatcher = contentPattern.matcher(sContentType);
                    if (!contentMatcher.matches()) continue;
                    matches = true;
                }
            }
            if (!matches) {
                int protocolEnd = sUrl.indexOf("//");
                int queryStringStart = sUrl.indexOf("?");
                int fileBaseStart = protocolEnd < 0 ? 0 : protocolEnd + 2;
                int fileBaseEnd = queryStringStart < 0 ? sUrl.length() : queryStringStart;
                String fileBase = sUrl.substring(fileBaseStart, fileBaseEnd);
                StringBuffer servletUrl = new StringBuffer();
                servletUrl.append(request.getContextPath());
                servletUrl.append("/ProxyServlet/");
                servletUrl.append(fileBase);
                servletUrl.append("?");
                servletUrl.append(URLEncoder.encode("url", "UTF-8"));
                servletUrl.append("=");
                servletUrl.append(URLEncoder.encode(sUrl, "UTF-8"));
                servletUrl.append("&");
                servletUrl.append(URLEncoder.encode("sid", "UTF-8"));
                servletUrl.append("=");
                servletUrl.append(URLEncoder.encode(session.getId(), "UTF-8"));
                Object namespaceTestObj = new Object();
                String NAMESPACE_TEST_NAME = "NAMESPACE_TEST";
                session.setAttribute("NAMESPACE_TEST", namespaceTestObj);
                Enumeration nameEnum = session.getAttributeNames(1);
                while (nameEnum.hasMoreElements()) {
                    String sufix;
                    String prefix;
                    String name = (String)nameEnum.nextElement();
                    Object value = session.getAttribute(name, 1);
                    if (!value.equals(namespaceTestObj)) continue;
                    int index = name.indexOf("NAMESPACE_TEST");
                    if (index >= 0) {
                        prefix = name.substring(0, index);
                        sufix = name.substring(index + "NAMESPACE_TEST".length());
                    } else {
                        prefix = "";
                        sufix = "";
                    }
                    servletUrl.append("&");
                    servletUrl.append(URLEncoder.encode("ns_prefix", "UTF-8"));
                    servletUrl.append("=");
                    servletUrl.append(URLEncoder.encode(prefix, "UTF-8"));
                    servletUrl.append("&");
                    servletUrl.append(URLEncoder.encode("ns_sufix", "UTF-8"));
                    servletUrl.append("=");
                    servletUrl.append(URLEncoder.encode(sufix, "UTF-8"));
                }
                session.setAttribute(PortletPreferences.class.getName(), (Object)request.getPreferences());
                if (session instanceof HttpSession && SessionMappingListener.getSession((String)session.getId()) == null) {
                    SessionMappingListener.setSession((HttpSession)((HttpSession)session));
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Redirecting request to '" + servletUrl + "'"));
                }
                response.sendRedirect(servletUrl.toString());
                return;
            }
            Map params = request.getParameterMap();
            if (params != null) {
                response.setRenderParameters(params);
            }
            response.setRenderParameter(WebproxyConstants.REQUEST_TYPE, sRequestType);
            response.setRenderParameter(GeneralConfigImpl.BASE_URL, sUrl);
            session.setAttribute(GeneralConfigImpl.BASE_URL, (Object)sUrl);
        }
    }

    private void processConfigAction(ActionRequest request, ActionResponse response) throws ReadOnlyException {
        PortletSession session = request.getPortletSession();
        Map userInfo = (Map)request.getAttribute("javax.portlet.userinfo");
        PortletPreferencesWrapper pp = new PortletPreferencesWrapper(request.getPreferences(), userInfo);
        if (request.getParameter("configPlacer") != null) {
            try {
                session.setAttribute("configPlacer", (Object)new Integer(request.getParameter("configPlacer")));
            }
            catch (NumberFormatException e) {
                LOG.error((Object)"Caught NumberFormatException when retrieving configuration page placer", (Throwable)e);
            }
        } else {
            ConfigPage tempConfig = this.getConfig(session);
            Integer configPlacer = (Integer)session.getAttribute("configPlacer");
            boolean error = false;
            try {
                tempConfig.process(request, response);
            }
            catch (Exception e) {
                LOG.error((Object)new StringBuffer("Caught RuntimeException when calling action on ").append(tempConfig.getName()).toString(), (Throwable)e);
                response.setRenderParameter("msg", e.getMessage());
                error = true;
            }
            String sPrevious = request.getParameter("previous");
            String sNext = request.getParameter("next");
            if (sNext != null) {
                if (!error) {
                    configPlacer = new Integer(configPlacer + 1);
                }
                session.setAttribute("configPlacer", (Object)configPlacer);
            } else if (sPrevious != null) {
                if (!error) {
                    configPlacer = new Integer(configPlacer - 1);
                }
                session.setAttribute("configPlacer", (Object)configPlacer);
            } else {
                response.setRenderParameter("msg", "Thank you for submitting the parameters.");
                pp.reset("configPlacer");
                session.removeAttribute("configList");
            }
        }
    }

    private void processManualAuthForm(ActionRequest request) throws ReadOnlyException, IOException, ValidatorException {
        PortletSession session = request.getPortletSession();
        Map userInfo = (Map)request.getAttribute("javax.portlet.userinfo");
        PortletPreferencesWrapper pp = new PortletPreferencesWrapper(request.getPreferences(), userInfo);
        String authType = pp.getValue(HttpClientConfigImpl.AUTH_TYPE, null);
        if ("BASIC".equals(authType)) {
            String userName = ConfigUtils.checkEmptyNullString((String)request.getParameter(HttpClientConfigImpl.USER_NAME), (String)"");
            String password = ConfigUtils.checkEmptyNullString((String)request.getParameter(HttpClientConfigImpl.PASSWORD), (String)"");
            if (userName.length() > 0) {
                session.setAttribute(HttpClientConfigImpl.USER_NAME, (Object)userName);
                boolean userNamePersist = new Boolean(pp.getValue(HttpClientConfigImpl.PERSIST_USER_NAME, null));
                if (userNamePersist) {
                    pp.setValue(HttpClientConfigImpl.USER_NAME, userName);
                }
            }
            if (password.length() > 0) {
                session.setAttribute(HttpClientConfigImpl.PASSWORD, (Object)password);
                boolean passwordPersist = new Boolean(pp.getValue(HttpClientConfigImpl.PERSIST_PASSWORD, null));
                if (passwordPersist) {
                    pp.setValue(HttpClientConfigImpl.PASSWORD, password);
                }
            }
            pp.store();
        } else if ("FORM".equals(authType)) {
            String[] dynamicParamNames = pp.getValues(HttpClientConfigImpl.DYNAMIC_PARAM_NAMES, new String[0]);
            String[] dynamicParamValues = ConfigUtils.checkNullStringArray((String[])request.getParameterValues(HttpClientConfigImpl.DYNAMIC_PARAM_VALUES), (String[])new String[0]);
            if (dynamicParamValues.length == dynamicParamNames.length) {
                dynamicParamValues = ConfigUtils.checkArrayForNulls((String[])dynamicParamValues, (String)"");
                session.setAttribute(HttpClientConfigImpl.DYNAMIC_PARAM_VALUES, (Object)dynamicParamValues);
                String[] persistedParamValues = new String[dynamicParamValues.length];
                String[] dynamicParamPersist = pp.getValues(HttpClientConfigImpl.DYNAMIC_PARAM_PERSIST, new String[0]);
                for (int index = 0; index < dynamicParamPersist.length; ++index) {
                    try {
                        int paramIndex = Integer.parseInt(dynamicParamPersist[index]);
                        persistedParamValues[paramIndex] = dynamicParamValues[paramIndex];
                        continue;
                    }
                    catch (NumberFormatException nfe) {
                        // empty catch block
                    }
                }
                pp.setValues(HttpClientConfigImpl.DYNAMIC_PARAM_VALUES, persistedParamValues);
                pp.store();
            } else {
                LOG.warn((Object)("Invalid data submitted during manual authentication prompt. dynamicParamNames.length='" + dynamicParamNames.length + "' != dynamicParamValues.length='" + dynamicParamValues.length + "'"));
            }
        } else {
            throw new IllegalArgumentException("Unknown authType specified '" + authType + "'");
        }
    }

    public static String checkRedirect(String sUrl, Response httpResponse) {
        StringBuffer myUrl = new StringBuffer(sUrl);
        int statusCode = httpResponse.getStatusCode();
        if (statusCode == 302 || statusCode == 301 || statusCode == 303 || statusCode == 307) {
            Header[] headers = httpResponse.getHeaders();
            for (int index = 0; index < headers.length; ++index) {
                if (!"location".equalsIgnoreCase(headers[index].getName())) continue;
                String location = headers[index].getValue();
                if (location == null || location.equals("")) {
                    myUrl.append("/");
                    break;
                }
                if (location.toUpperCase().startsWith("HTTP")) {
                    myUrl = new StringBuffer(location);
                    break;
                }
                myUrl.append(location);
                break;
            }
        }
        return myUrl.toString();
    }

    private ConfigPage getConfig(PortletSession session) {
        ApplicationContext context = PortletApplicationContextUtils.getWebApplicationContext((PortletContext)this.getPortletContext());
        List configurationList = (List)context.getBean("ConfigBean", List.class);
        session.setAttribute("configList", (Object)configurationList);
        ConfigPage currentConfig = null;
        Integer configPlacer = null;
        configPlacer = (Integer)session.getAttribute("configPlacer");
        if (configPlacer == null) {
            configPlacer = new Integer(0);
        }
        currentConfig = (ConfigPage)configurationList.get(configPlacer);
        session.setAttribute("configPlacer", (Object)configPlacer);
        return currentConfig;
    }

    private String createBackButton(RenderResponse response) {
        StringBuffer backButton = new StringBuffer("<br><form name=\"back\" action=\"").append(response.createActionURL()).append(">\" method=\"post\"><input type=\"submit\" name=\"").append("backButton").append("\" value=\"Back to Application\"></form>");
        return backButton.toString();
    }

    private State getState(PortletRequest request) {
        StateStore stateStore;
        ApplicationContext context = PortletApplicationContextUtils.getWebApplicationContext((PortletContext)this.getPortletContext());
        PortletSession session = request.getPortletSession();
        PortletPreferencesWrapper prefs = new PortletPreferencesWrapper(request.getPreferences(), (Map)request.getAttribute("javax.portlet.userinfo"));
        String sharedStateKey = ConfigUtils.checkEmptyNullString((String)prefs.getValue(HttpClientConfigImpl.SHARED_SESSION_KEY, null), null);
        State httpState = sharedStateKey != null ? (State)session.getAttribute(sharedStateKey, 1) : (State)session.getAttribute("current_state");
        boolean sessionPersistenceEnabled = new Boolean(prefs.getValue(HttpClientConfigImpl.SESSION_PERSISTENCE_ENABLE, null));
        if (sessionPersistenceEnabled && httpState == null && (stateStore = (StateStore)context.getBean("StateStore", StateStore.class)) != null) {
            String namespace = (String)session.getAttribute("edu.wisc.my.webproxy.namespace");
            String stateKey = sharedStateKey != null ? WebProxyPortlet.generateStateKey((String)sharedStateKey, (String)namespace) : WebProxyPortlet.generateStateKey((String)"current_state", (String)namespace);
            httpState = stateStore.getState(stateKey);
        }
        return httpState;
    }

    private void storeState(PortletRequest request, State state) {
        StateStore stateStore;
        ApplicationContext context = PortletApplicationContextUtils.getWebApplicationContext((PortletContext)this.getPortletContext());
        PortletSession session = request.getPortletSession();
        PortletPreferencesWrapper prefs = new PortletPreferencesWrapper(request.getPreferences(), (Map)request.getAttribute("javax.portlet.userinfo"));
        String sharedStateKey = ConfigUtils.checkEmptyNullString((String)prefs.getValue(HttpClientConfigImpl.SHARED_SESSION_KEY, null), null);
        if (sharedStateKey != null) {
            session.setAttribute(sharedStateKey, (Object)state, 1);
        } else {
            session.setAttribute("current_state", (Object)state);
        }
        boolean sessionPersistenceEnabled = new Boolean(prefs.getValue(HttpClientConfigImpl.SESSION_PERSISTENCE_ENABLE, null));
        if (sessionPersistenceEnabled && (stateStore = (StateStore)context.getBean("StateStore", StateStore.class)) != null) {
            String namespace = (String)session.getAttribute("edu.wisc.my.webproxy.namespace");
            String stateKey = sharedStateKey != null ? WebProxyPortlet.generateStateKey((String)sharedStateKey, (String)namespace) : WebProxyPortlet.generateStateKey((String)"current_state", (String)namespace);
            stateStore.storeState(stateKey, state);
        }
    }
}

