/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.my.webproxy.servlet;

import edu.wisc.my.webproxy.beans.cache.CacheEntry;
import edu.wisc.my.webproxy.beans.cache.PageCache;
import edu.wisc.my.webproxy.beans.config.CacheConfigImpl;
import edu.wisc.my.webproxy.beans.config.ConfigUtils;
import edu.wisc.my.webproxy.beans.config.GeneralConfigImpl;
import edu.wisc.my.webproxy.beans.config.HttpClientConfigImpl;
import edu.wisc.my.webproxy.beans.config.HttpHeaderConfigImpl;
import edu.wisc.my.webproxy.beans.http.Header;
import edu.wisc.my.webproxy.beans.http.HttpManager;
import edu.wisc.my.webproxy.beans.http.HttpTimeoutException;
import edu.wisc.my.webproxy.beans.http.Request;
import edu.wisc.my.webproxy.beans.http.Response;
import edu.wisc.my.webproxy.beans.http.State;
import edu.wisc.my.webproxy.beans.http.StateStore;
import edu.wisc.my.webproxy.beans.interceptors.PostInterceptor;
import edu.wisc.my.webproxy.beans.interceptors.PreInterceptor;
import edu.wisc.my.webproxy.portlet.ApplicationContextLocator;
import edu.wisc.my.webproxy.portlet.WebProxyPortlet;
import edu.wisc.my.webproxy.servlet.SessionMappingListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import javax.portlet.PortletPreferences;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class ProxyServlet
extends HttpServlet {
    private Log LOG = LogFactory.getLog(ProxyServlet.class);
    public static final String SESSION_ID_PARAM = "sid";
    public static final String NAMESPACE_PREFIX_PARAM = "ns_prefix";
    public static final String NAMESPACE_SUFIX_PARAM = "ns_sufix";
    public static final String URL_PARAM = "url";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        WebApplicationContext context = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.getServletContext());
        ApplicationContextLocator.setApplicationContext((ApplicationContext)context);
        try {
            super.service(request, response);
        }
        finally {
            ApplicationContextLocator.setApplicationContext(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Header[] headers;
        StateStore stateStore;
        String cacheKey;
        PageCache cache;
        CacheEntry cachedData;
        String sid = request.getParameter(SESSION_ID_PARAM);
        String prefix = request.getParameter(NAMESPACE_PREFIX_PARAM);
        String sufix = request.getParameter(NAMESPACE_SUFIX_PARAM);
        String url = request.getParameter(URL_PARAM);
        HttpSession portletSession = SessionMappingListener.getSession((String)sid);
        if (portletSession == null) {
            IllegalStateException ise = new IllegalStateException("No HttpSession found for sid=" + sid);
            this.LOG.error((Object)ise, (Throwable)ise);
            throw ise;
        }
        PortletPreferences prefs = (PortletPreferences)portletSession.getAttribute(prefix + PortletPreferences.class.getName() + sufix);
        if (prefs == null) {
            IllegalStateException ise = new IllegalStateException("No PortletPreferences found for sid=" + sid + ", ns_prefix=" + prefix + ". ns_sufix=" + sufix);
            this.LOG.error((Object)ise, (Throwable)ise);
            throw ise;
        }
        String namespace = (String)portletSession.getAttribute(prefix + "edu.wisc.my.webproxy.namespace" + sufix);
        WebApplicationContext context = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.getServletContext());
        boolean sUseCache = new Boolean(prefs.getValue(CacheConfigImpl.USE_CACHE, null));
        if (sUseCache && (cachedData = (cache = (PageCache)context.getBean("PageCache", PageCache.class)).getCachedPage(cacheKey = WebProxyPortlet.generateCacheKey((String)url, (String)namespace))) != null) {
            if (this.LOG.isTraceEnabled()) {
                this.LOG.trace((Object)("Using cached content for key '" + cacheKey + "'"));
            }
            response.setContentType(cachedData.getContentType());
            response.getOutputStream().write(cachedData.getContent());
            return;
        }
        String sharedStateKey = ConfigUtils.checkEmptyNullString((String)prefs.getValue(HttpClientConfigImpl.SHARED_SESSION_KEY, null), null);
        State httpState = sharedStateKey != null ? (State)portletSession.getAttribute(sharedStateKey) : (State)portletSession.getAttribute(prefix + "current_state" + sufix);
        boolean sessionPersistenceEnabled = new Boolean(prefs.getValue(HttpClientConfigImpl.SESSION_PERSISTENCE_ENABLE, null));
        if (sessionPersistenceEnabled && httpState == null && (stateStore = (StateStore)context.getBean("StateStore", StateStore.class)) != null) {
            String stateKey = sharedStateKey != null ? WebProxyPortlet.generateStateKey((String)sharedStateKey, (String)namespace) : WebProxyPortlet.generateStateKey((String)"current_state", (String)namespace);
            httpState = stateStore.getState(stateKey);
        }
        HttpManager httpManager = (HttpManager)context.getBean("HttpManagerBean", HttpManager.class);
        Response httpResponse = null;
        try {
            httpManager.setup(prefs);
            boolean redirect = true;
            int maxRedirects = ConfigUtils.parseInt((String)prefs.getValue(HttpClientConfigImpl.MAX_REDIRECTS, null), (int)5);
            for (int index = 0; index < maxRedirects && redirect; ++index) {
                String tempUrl;
                Request httpRequest = httpManager.createRequest();
                httpRequest.setState(httpState);
                httpRequest.setUrl(url);
                String[] headerNames = prefs.getValues(HttpHeaderConfigImpl.HEADER_NAME, new String[0]);
                String[] headerValues = prefs.getValues(HttpHeaderConfigImpl.HEADER_VALUE, new String[0]);
                if (headerNames.length == headerValues.length) {
                    ArrayList<Header> headerList = new ArrayList<Header>(headerNames.length);
                    for (int headerIndex = 0; headerIndex < headerNames.length; ++headerIndex) {
                        Header h = httpRequest.createHeader();
                        h.setName(headerNames[headerIndex]);
                        h.setValue(headerValues[headerIndex]);
                        headerList.add(h);
                    }
                    httpRequest.setHeaders(headerList.toArray(new Header[headerList.size()]));
                } else {
                    this.LOG.error((Object)"Invalid data in preferences. Header name array length does not equal header value array length");
                }
                httpRequest.setType("GET");
                String sPreInterceptor = ConfigUtils.checkEmptyNullString((String)prefs.getValue(GeneralConfigImpl.PRE_INTERCEPTOR_CLASS, null), null);
                if (sPreInterceptor != null) {
                    String msg;
                    try {
                        Class<?> preInterceptorClass = Class.forName(sPreInterceptor);
                        PreInterceptor myPreInterceptor = (PreInterceptor)preInterceptorClass.newInstance();
                        myPreInterceptor.intercept(request, response, httpRequest);
                    }
                    catch (ClassNotFoundException cnfe) {
                        msg = "Could not find specified pre-interceptor class '" + sPreInterceptor + "'";
                        this.LOG.error((Object)msg, (Throwable)cnfe);
                        throw new ServletException(msg, (Throwable)cnfe);
                    }
                    catch (InstantiationException ie) {
                        msg = "Could instatiate specified pre-interceptor class '" + sPreInterceptor + "'";
                        this.LOG.error((Object)msg, (Throwable)ie);
                        throw new ServletException(msg, (Throwable)ie);
                    }
                    catch (IllegalAccessException iae) {
                        msg = "Could instatiate specified pre-interceptor class '" + sPreInterceptor + "'";
                        this.LOG.error((Object)msg, (Throwable)iae);
                        throw new ServletException(msg, (Throwable)iae);
                    }
                    catch (ClassCastException cce) {
                        msg = "Could not cast '" + sPreInterceptor + "' to 'edu.wisc.my.webproxy.beans.interceptors.PreInterceptor'";
                        this.LOG.error((Object)msg, (Throwable)cce);
                        throw new ServletException(msg, (Throwable)cce);
                    }
                }
                try {
                    httpResponse = httpManager.doRequest(httpRequest);
                }
                catch (HttpTimeoutException hte) {
                    boolean sUseExpired = new Boolean(prefs.getValue(CacheConfigImpl.USE_EXPIRED, null));
                    if (sUseCache && sUseExpired) {
                        this.LOG.info((Object)("Request '" + url + "' timed out. Attempting to use expired cache data."));
                        PageCache cache2 = (PageCache)context.getBean("PageCache", PageCache.class);
                        String cacheKey2 = WebProxyPortlet.generateCacheKey((String)url, (String)namespace);
                        CacheEntry cachedData2 = cache2.getCachedPage(cacheKey2, true);
                        if (cachedData2 != null) {
                            int retryDelay = ConfigUtils.parseInt((String)prefs.getValue(CacheConfigImpl.RETRY_DELAY, null), (int)-1);
                            if (retryDelay > 0) {
                                boolean persistData = new Boolean(prefs.getValue(CacheConfigImpl.PERSIST_CACHE, null));
                                cachedData2.setExpirationDate(new Date(System.currentTimeMillis() + (long)(retryDelay * 1000)));
                                cache2.cachePage(cacheKey2, cachedData2, persistData);
                            }
                            if (this.LOG.isTraceEnabled()) {
                                this.LOG.trace((Object)("Using cached content for key '" + cacheKey2 + "'"));
                            }
                            response.setContentType(cachedData2.getContentType());
                            response.getOutputStream().write(cachedData2.getContent());
                            httpManager.clearData();
                            return;
                        }
                    }
                    this.LOG.warn((Object)("Request '" + httpRequest + "' timed out"), (Throwable)hte);
                    throw new ServletException((Throwable)hte);
                }
                portletSession.setAttribute(prefix + HttpClientConfigImpl.SESSION_TIMEOUT + sufix, (Object)new Long(System.currentTimeMillis()));
                String sPostInterceptor = ConfigUtils.checkEmptyNullString((String)prefs.getValue(GeneralConfigImpl.POST_INTERCEPTOR_CLASS, null), null);
                if (sPostInterceptor != null) {
                    String msg;
                    try {
                        Class<?> postInterceptorClass = Class.forName(sPostInterceptor);
                        PostInterceptor myPostInterceptor = (PostInterceptor)postInterceptorClass.newInstance();
                        myPostInterceptor.intercept(request, response, httpResponse);
                    }
                    catch (ClassNotFoundException cnfe) {
                        msg = "Could not find specified post-interceptor class '" + sPostInterceptor + "'";
                        this.LOG.error((Object)msg, (Throwable)cnfe);
                        throw new ServletException(msg, (Throwable)cnfe);
                    }
                    catch (InstantiationException ie) {
                        msg = "Could instatiate specified post-interceptor class '" + sPostInterceptor + "'";
                        this.LOG.error((Object)msg, (Throwable)ie);
                        throw new ServletException(msg, (Throwable)ie);
                    }
                    catch (IllegalAccessException iae) {
                        msg = "Could instatiate specified post-interceptor class '" + sPostInterceptor + "'";
                        this.LOG.error((Object)msg, (Throwable)iae);
                        throw new ServletException(msg, (Throwable)iae);
                    }
                    catch (ClassCastException cce) {
                        msg = "Could not cast '" + sPostInterceptor + "' to 'edu.wisc.my.webproxy.beans.interceptors.PostInterceptor'";
                        this.LOG.error((Object)msg, (Throwable)cce);
                        throw new ServletException(msg, (Throwable)cce);
                    }
                }
                if (url.equals(tempUrl = WebProxyPortlet.checkRedirect((String)url, (Response)httpResponse))) {
                    redirect = false;
                    continue;
                }
                url = tempUrl;
            }
            headers = httpResponse.getHeaders();
        }
        finally {
            httpManager.clearData();
        }
        for (int index = 0; index < headers.length; ++index) {
            if (!"Content-Length".equals(headers[index].getName())) continue;
            try {
                int length = Integer.parseInt(headers[index].getValue());
                response.setContentLength(length);
                continue;
            }
            catch (NumberFormatException nfe) {
                this.LOG.warn((Object)("'" + url + "' returned an invalid Content-Length='" + headers[index].getValue() + "'"));
            }
        }
        response.setContentType(httpResponse.getContentType());
        response.setStatus(httpResponse.getStatusCode());
        InputStream in = null;
        ServletOutputStream out = null;
        try {
            in = httpResponse.getResponseBodyAsStream();
            out = response.getOutputStream();
            IOUtils.copy((InputStream)in, (OutputStream)out);
            out.flush();
            return;
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.flush();
                out.close();
            }
        }
    }

    protected void doHead(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        System.err.println("doHead not implemented");
        super.doHead(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        System.err.println("doPost not implemented");
        super.doPost(request, response);
    }
}

