/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.my.webproxy.beans.http;

import edu.wisc.my.webproxy.beans.PortletPreferencesWrapper;
import edu.wisc.my.webproxy.beans.config.ConfigUtils;
import edu.wisc.my.webproxy.beans.config.HttpClientConfigImpl;
import edu.wisc.my.webproxy.beans.http.HttpManagerImpl;
import java.util.Map;
import javax.portlet.PortletRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.jasig.portal.security.provider.saml.SAMLSession;

public class ShibbolethEnabledHttpManagerImpl
extends HttpManagerImpl {
    private static final String AUTH_TYPE_SHIBBOLETH = "SHIBBOLETH";
    private String spPrivateKey;
    private String spCertificate;
    private String portalEntityID;

    public String getPortalEntityID() {
        return this.portalEntityID;
    }

    public void setPortalEntityID(String portalEntityID) {
        this.portalEntityID = portalEntityID;
    }

    public void setSpPrivateKey(String spPrivateKey) {
        this.spPrivateKey = spPrivateKey;
    }

    public void setSpCertificate(String spCertificate) {
        this.spCertificate = spCertificate;
    }

    protected DefaultHttpClient createHttpClient(PortletRequest request) {
        PortletPreferencesWrapper myPreferences = new PortletPreferencesWrapper(request.getPreferences(), (Map)request.getAttribute("javax.portlet.userinfo"));
        boolean authEnabled = new Boolean(myPreferences.getValue(HttpClientConfigImpl.AUTH_ENABLE, null));
        String authType = ConfigUtils.checkEmptyNullString((String)myPreferences.getValue(HttpClientConfigImpl.AUTH_TYPE, ""), (String)"");
        if (authEnabled && AUTH_TYPE_SHIBBOLETH.equals(authType)) {
            String idpPublicKeys;
            String samlAssertion = this.getAssertion(request);
            SAMLSession samlSession = new SAMLSession(samlAssertion);
            samlSession.setPortalEntityID(this.portalEntityID);
            if (this.spPrivateKey != null && this.spCertificate != null) {
                samlSession.setIdPClientPrivateKeyAndCert(this.spPrivateKey, this.spCertificate);
            }
            if ((idpPublicKeys = this.getIdPPublicKeys(request)) != null) {
                samlSession.setIdPServerPublicKeys(idpPublicKeys);
            }
            this.logger.debug((Object)"Returning new Shibbolized HttpClient instance");
            return (DefaultHttpClient)samlSession.getHttpClient();
        }
        return super.createHttpClient(request);
    }

    protected String getAssertion(PortletRequest request) {
        Map userInfo = (Map)request.getAttribute("javax.portlet.userinfo");
        String samlAssertion = (String)userInfo.get("samlAssertion");
        return samlAssertion;
    }

    protected String getIdPPublicKeys(PortletRequest request) {
        Map userInfo = (Map)request.getAttribute("javax.portlet.userinfo");
        String idpPublicKeys = (String)userInfo.get("idpPublicKeys");
        return idpPublicKeys;
    }
}

