/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.my.webproxy.servlet;

import edu.wisc.my.webproxy.beans.cache.CacheEntry;
import edu.wisc.my.webproxy.beans.cache.PageCache;
import edu.wisc.my.webproxy.beans.config.CacheConfigImpl;
import edu.wisc.my.webproxy.beans.config.ConfigUtils;
import edu.wisc.my.webproxy.beans.config.GeneralConfigImpl;
import edu.wisc.my.webproxy.beans.config.HttpClientConfigImpl;
import edu.wisc.my.webproxy.beans.config.HttpHeaderConfigImpl;
import edu.wisc.my.webproxy.beans.http.HttpManager;
import edu.wisc.my.webproxy.beans.http.HttpTimeoutException;
import edu.wisc.my.webproxy.beans.http.IHeader;
import edu.wisc.my.webproxy.beans.http.IKeyManager;
import edu.wisc.my.webproxy.beans.http.Request;
import edu.wisc.my.webproxy.beans.http.Response;
import edu.wisc.my.webproxy.beans.interceptors.PostInterceptor;
import edu.wisc.my.webproxy.beans.interceptors.PreInterceptor;
import edu.wisc.my.webproxy.portlet.ApplicationContextLocator;
import edu.wisc.my.webproxy.portlet.WebProxyPortlet;
import edu.wisc.my.webproxy.portlet.WebproxyConstants;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import javax.portlet.PortletPreferences;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.web.util.LRUTrackingModelPasser;
import org.jasig.web.util.ModelPasser;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class ProxyServlet
extends HttpServlet {
    private Log LOG = LogFactory.getLog(ProxyServlet.class);
    public static final String SESSION_ID_PARAM = "sid";
    public static final String URL_PARAM = "url";
    public static final String POST_PARAMETERS = "POST_PARAMETERS";
    public static final String HTTP_MANAGER = "HTTP_MANAGER";
    public static final String SESSION_KEY = "SESSION_KEY";
    private ModelPasser modelPasser = new LRUTrackingModelPasser();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        WebApplicationContext context = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.getServletContext());
        ApplicationContextLocator.setApplicationContext((ApplicationContext)context);
        try {
            super.service(request, response);
        }
        finally {
            ApplicationContextLocator.setApplicationContext(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        IHeader[] headers;
        IKeyManager keyManager;
        String cacheKey;
        PageCache cache;
        CacheEntry cachedData;
        String sessionKey = request.getParameter(SESSION_KEY);
        Map model = this.modelPasser.getModelFromPortlet(request, response, sessionKey);
        if (model == null) {
            response.sendError(404, "No model exists in the session for key '" + sessionKey + "'");
            return;
        }
        String requestType = (String)model.get(WebproxyConstants.REQUEST_TYPE);
        Map postParameters = (Map)model.get(POST_PARAMETERS);
        String url = (String)model.get(URL_PARAM);
        String instanceKey = (String)model.get(IKeyManager.PORTLET_INSTANCE_KEY);
        PortletPreferences prefs = (PortletPreferences)model.get(PortletPreferences.class.getName());
        WebApplicationContext context = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.getServletContext());
        boolean sUseCache = new Boolean(prefs.getValue(CacheConfigImpl.USE_CACHE, null));
        if (sUseCache && (cachedData = (cache = (PageCache)context.getBean("PageCache", PageCache.class)).getCachedPage(cacheKey = (keyManager = (IKeyManager)context.getBean("keyManager", IKeyManager.class)).generateCacheKey(url, instanceKey))) != null) {
            if (this.LOG.isTraceEnabled()) {
                this.LOG.trace((Object)("Using cached content for key '" + cacheKey + "'"));
            }
            response.setContentType(cachedData.getContentType());
            response.getWriter().write(cachedData.getContent());
            return;
        }
        HttpManager httpManager = (HttpManager)model.get(HTTP_MANAGER);
        Response httpResponse = null;
        try {
            boolean redirect = true;
            int maxRedirects = ConfigUtils.parseInt((String)prefs.getValue(HttpClientConfigImpl.MAX_REDIRECTS, null), (int)5);
            for (int index = 0; index < maxRedirects && redirect; ++index) {
                String tempUrl;
                Request httpRequest = httpManager.createRequest();
                httpRequest.setUrl(url);
                String[] headerNames = prefs.getValues(HttpHeaderConfigImpl.HEADER_NAME, new String[0]);
                String[] headerValues = prefs.getValues(HttpHeaderConfigImpl.HEADER_VALUE, new String[0]);
                if (headerNames.length == headerValues.length) {
                    ArrayList<IHeader> headerList = new ArrayList<IHeader>(headerNames.length);
                    for (int headerIndex = 0; headerIndex < headerNames.length; ++headerIndex) {
                        IHeader h = httpRequest.createHeader(headerNames[headerIndex], headerValues[headerIndex]);
                        headerList.add(h);
                    }
                    httpRequest.setHeaders(headerList.toArray(new IHeader[headerList.size()]));
                } else {
                    this.LOG.error((Object)"Invalid data in preferences. Header name array length does not equal header value array length");
                }
                httpRequest.setType("GET");
                String sPreInterceptor = ConfigUtils.checkEmptyNullString((String)prefs.getValue(GeneralConfigImpl.PRE_INTERCEPTOR_CLASS, null), null);
                if (sPreInterceptor != null) {
                    String msg;
                    try {
                        Class<?> preInterceptorClass = Class.forName(sPreInterceptor);
                        PreInterceptor myPreInterceptor = (PreInterceptor)preInterceptorClass.newInstance();
                        myPreInterceptor.intercept(request, response, httpRequest);
                    }
                    catch (ClassNotFoundException cnfe) {
                        msg = "Could not find specified pre-interceptor class '" + sPreInterceptor + "'";
                        this.LOG.error((Object)msg, (Throwable)cnfe);
                        throw new ServletException(msg, (Throwable)cnfe);
                    }
                    catch (InstantiationException ie) {
                        msg = "Could instatiate specified pre-interceptor class '" + sPreInterceptor + "'";
                        this.LOG.error((Object)msg, (Throwable)ie);
                        throw new ServletException(msg, (Throwable)ie);
                    }
                    catch (IllegalAccessException iae) {
                        msg = "Could instatiate specified pre-interceptor class '" + sPreInterceptor + "'";
                        this.LOG.error((Object)msg, (Throwable)iae);
                        throw new ServletException(msg, (Throwable)iae);
                    }
                    catch (ClassCastException cce) {
                        msg = "Could not cast '" + sPreInterceptor + "' to 'edu.wisc.my.webproxy.beans.interceptors.PreInterceptor'";
                        this.LOG.error((Object)msg, (Throwable)cce);
                        throw new ServletException(msg, (Throwable)cce);
                    }
                }
                try {
                    httpResponse = httpManager.doRequest(httpRequest);
                }
                catch (HttpTimeoutException hte) {
                    boolean sUseExpired = new Boolean(prefs.getValue(CacheConfigImpl.USE_EXPIRED, null));
                    if (sUseCache && sUseExpired) {
                        this.LOG.info((Object)("Request '" + url + "' timed out. Attempting to use expired cache data."));
                        PageCache cache2 = (PageCache)context.getBean("PageCache", PageCache.class);
                        IKeyManager keyManager2 = (IKeyManager)context.getBean("keyManager", IKeyManager.class);
                        String cacheKey2 = keyManager2.generateCacheKey(url, instanceKey);
                        CacheEntry cachedData2 = cache2.getCachedPage(cacheKey2, true);
                        if (cachedData2 != null) {
                            int retryDelay = ConfigUtils.parseInt((String)prefs.getValue(CacheConfigImpl.RETRY_DELAY, null), (int)-1);
                            if (retryDelay > 0) {
                                boolean persistData = new Boolean(prefs.getValue(CacheConfigImpl.PERSIST_CACHE, null));
                                cachedData2.setExpirationDate(new Date(System.currentTimeMillis() + (long)(retryDelay * 1000)));
                                cache2.cachePage(cacheKey2, cachedData2, persistData);
                            }
                            if (this.LOG.isTraceEnabled()) {
                                this.LOG.trace((Object)("Using cached content for key '" + cacheKey2 + "'"));
                            }
                            response.setContentType(cachedData2.getContentType());
                            response.getWriter().write(cachedData2.getContent());
                            httpManager.clearData();
                            return;
                        }
                    }
                    this.LOG.warn((Object)("Request '" + httpRequest + "' timed out"), (Throwable)hte);
                    throw new ServletException((Throwable)hte);
                }
                String sPostInterceptor = ConfigUtils.checkEmptyNullString((String)prefs.getValue(GeneralConfigImpl.POST_INTERCEPTOR_CLASS, null), null);
                if (sPostInterceptor != null) {
                    String msg;
                    try {
                        Class<?> postInterceptorClass = Class.forName(sPostInterceptor);
                        PostInterceptor myPostInterceptor = (PostInterceptor)postInterceptorClass.newInstance();
                        myPostInterceptor.intercept(request, response, httpResponse);
                    }
                    catch (ClassNotFoundException cnfe) {
                        msg = "Could not find specified post-interceptor class '" + sPostInterceptor + "'";
                        this.LOG.error((Object)msg, (Throwable)cnfe);
                        throw new ServletException(msg, (Throwable)cnfe);
                    }
                    catch (InstantiationException ie) {
                        msg = "Could instatiate specified post-interceptor class '" + sPostInterceptor + "'";
                        this.LOG.error((Object)msg, (Throwable)ie);
                        throw new ServletException(msg, (Throwable)ie);
                    }
                    catch (IllegalAccessException iae) {
                        msg = "Could instatiate specified post-interceptor class '" + sPostInterceptor + "'";
                        this.LOG.error((Object)msg, (Throwable)iae);
                        throw new ServletException(msg, (Throwable)iae);
                    }
                    catch (ClassCastException cce) {
                        msg = "Could not cast '" + sPostInterceptor + "' to 'edu.wisc.my.webproxy.beans.interceptors.PostInterceptor'";
                        this.LOG.error((Object)msg, (Throwable)cce);
                        throw new ServletException(msg, (Throwable)cce);
                    }
                }
                if (url.equals(tempUrl = WebProxyPortlet.checkRedirect((String)url, (Response)httpResponse))) {
                    redirect = false;
                    continue;
                }
                url = tempUrl;
            }
            headers = httpResponse.getHeaders();
        }
        finally {
            httpManager.clearData();
        }
        for (int index = 0; index < headers.length; ++index) {
            if (!"Content-Length".equals(headers[index].getName())) continue;
            try {
                int length = Integer.parseInt(headers[index].getValue());
                response.setContentLength(length);
                continue;
            }
            catch (NumberFormatException nfe) {
                this.LOG.warn((Object)("'" + url + "' returned an invalid Content-Length='" + headers[index].getValue() + "'"));
            }
        }
        response.setContentType(httpResponse.getContentType());
        response.setStatus(httpResponse.getStatusCode());
        InputStream in = null;
        ServletOutputStream out = null;
        try {
            in = httpResponse.getResponseBodyAsStream();
            out = response.getOutputStream();
            IOUtils.copy((InputStream)in, (OutputStream)out);
            out.flush();
            return;
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.flush();
                out.close();
            }
        }
    }

    protected void doHead(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        System.err.println("doHead not implemented");
        super.doHead(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        System.err.println("doPost not implemented");
        super.doPost(request, response);
    }
}

