/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.utils.cache.hibernate;

import java.util.Properties;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.hibernate.EhCache;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.cache.Cache;
import org.hibernate.cache.CacheProvider;
import org.hibernate.cache.Timestamper;
import org.springframework.beans.factory.annotation.Required;

public class EhCacheProvider
implements CacheProvider {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private CacheManager cacheManager;

    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    @Required
    public void setCacheManager(CacheManager cacheManager) {
        Validate.notNull((Object)cacheManager, (String)"cacheManager can not be null");
        this.cacheManager = cacheManager;
    }

    public Cache buildCache(String regionName, Properties properties) throws org.hibernate.cache.CacheException {
        try {
            Ehcache cache = this.cacheManager.getEhcache(regionName);
            if (cache == null) {
                this.logger.warn((Object)("Could not find a specific ehcache configuration for cache regionNamed '" + regionName + "'. The default cache will be used."));
                this.cacheManager.addCache(regionName);
                cache = this.cacheManager.getEhcache(regionName);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Created EhCache '" + regionName + "'"));
                }
            }
            return new EhCache(cache);
        }
        catch (CacheException e) {
            throw new org.hibernate.cache.CacheException((Exception)((Object)e));
        }
    }

    public boolean isMinimalPutsEnabledByDefault() {
        return false;
    }

    public long nextTimestamp() {
        return Timestamper.next();
    }

    public void start(Properties properties) throws org.hibernate.cache.CacheException {
    }

    public void stop() {
    }
}

