/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.my.webproxy.beans.http;

import edu.wisc.my.webproxy.beans.http.HeaderImpl;
import edu.wisc.my.webproxy.beans.http.HttpTimeoutException;
import edu.wisc.my.webproxy.beans.http.IHeader;
import edu.wisc.my.webproxy.beans.http.Response;
import edu.wisc.my.webproxy.portlet.WebProxyPortlet;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ConnectTimeoutException;

public class ResponseImpl
implements Response {
    private static final Log LOG = LogFactory.getLog(WebProxyPortlet.class);
    HttpUriRequest method;
    HttpClient client;
    HttpResponse response;

    public ResponseImpl(HttpUriRequest method, HttpClient client) throws HttpTimeoutException, IOException {
        this.client = client;
        this.method = method;
        try {
            this.response = this.client.execute(this.method);
            int statusCode = this.response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                LOG.info((Object)("Method failed: " + this.response.getStatusLine()));
            }
        }
        catch (ConnectTimeoutException cte) {
            throw new HttpTimeoutException((Throwable)cte);
        }
    }

    public InputStream getResponseBodyAsStream() {
        InputStream is = null;
        try {
            is = this.response.getEntity().getContent();
        }
        catch (IOException e) {
            LOG.error((Object)"Caught an IOException when retrieving the response body: ", (Throwable)e);
        }
        return is;
    }

    public String getContentType() {
        String contentType = null;
        Header[] headers = this.response.getHeaders("Content-Type");
        if (headers.length > 0) {
            contentType = headers[0].getValue();
        }
        return contentType;
    }

    public IHeader[] getHeaders() {
        Header[] httpClientHeaders = this.response.getAllHeaders();
        IHeader[] myHeaders = new IHeader[httpClientHeaders.length];
        for (int i = 0; i < httpClientHeaders.length; ++i) {
            myHeaders[i] = new HeaderImpl(httpClientHeaders[i].getName(), httpClientHeaders[i].getValue());
        }
        return myHeaders;
    }

    public int getStatusCode() {
        return this.response.getStatusLine().getStatusCode();
    }

    public String getRequestUrl() {
        return this.method.getURI().toString();
    }

    public void close() {
    }
}

