/**
 * Copyright (c) 2001 The JA-SIG Collaborative.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software developed by the JA-SIG Collaborative
 *    (http://www.jasig.org/)."
 *
 * THIS SOFTWARE IS PROVIDED BY THE JA-SIG COLLABORATIVE "AS IS" AND ANY
 * EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE JA-SIG COLLABORATIVE OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */
package edu.wisc.my.webproxy.beans.http;


/**
 * {@link ICredentials} for use with the NTLM authentication scheme which requires additional
 * information
 * 
 * @author Eric Dalquist <a href="mailto:edalquist@unicon.net">edalquist@unicon.net</a>
 * 
 * @version $Revision: 18152 $
 */
public class NtCredentials extends ICredentials {
    private String domain;
    private String host;
    
    /**
     * Default constructor.
     * 
     */
    
    public NtCredentials() {
        
    }

    /**
     * Constructor.
     * @param userName The user name.  This should not include the domain to authenticate with.
     * For example: "user" is correct whereas "DOMAIN\\user" is not.
     * @param password The password.
     * @param host The host the authentication request is originating from.  Essentially, the
     * computer name for this machine.
     * @param domain The domain to authenticate within.
     */
    
    public NtCredentials(String userName, String password, String host, String domain) {
        super(userName, password);
        this.host = host;
        this.domain = domain;
    }
    
    
    /**
     * Retrieves the domain name to authenticate with.
     *
     * @return String the domain these credentials are intended to authenticate with.
     * 
     * @see #setDomain(String)
     * 
     */
    
    public String getDomain() {
        return this.domain;
    }
    
    /**
     * Retrieves the host name of the computer originating the request.
     *
     * @return String the host the user is logged into.
     */
    
    public String getHost() {
        return this.host;
    }
    
    /**
     * Sets the domain to authenticate with. The domain may not be null.
     *
     * @param domain the NT domain to authenticate in.
     * 
     * @see #getDomain()
     * 
     */
    
    public void setDomain(String domain) {
        this.domain = domain;
    }
    
    /** 
     * Sets the host name of the computer originating the request. The host name may
     * not be null.
     *
     * @param host the Host the user is logged into.
     * 
     */
    
    public void setHost(String host) {
        this.host = host;
    }
}
