/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.my.webproxy.beans;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.portlet.PortletPreferences;
import javax.portlet.ReadOnlyException;
import javax.portlet.ValidatorException;

public class PortletPreferencesWrapper
implements PortletPreferences {
    private static final Pattern ATTRIBUTE_PATTERN = Pattern.compile("\\$\\{([^\\$\\}]+)\\}");
    private PortletPreferences portletPrefs = null;
    private Map userInfo = null;

    public PortletPreferencesWrapper(PortletPreferences pp, Map userInfo) {
        this.portletPrefs = pp;
        this.userInfo = userInfo;
    }

    public boolean isReadOnly(String arg0) {
        return this.portletPrefs.isReadOnly(arg0);
    }

    public String getValue(String attribute, String def) {
        String value = this.portletPrefs.getValue(attribute, def);
        if (value != null) {
            value = this.rewriteValue(value);
        }
        return value;
    }

    private String rewriteValue(String value) {
        if (value == null) {
            return null;
        }
        StringBuffer valueBuffer = new StringBuffer(value);
        Matcher contentMatcher = ATTRIBUTE_PATTERN.matcher(valueBuffer);
        int searchIndex = 0;
        while (searchIndex < valueBuffer.length() && contentMatcher.find(searchIndex)) {
            int start = contentMatcher.start();
            int end = contentMatcher.end();
            String attrName = contentMatcher.group(1);
            String attrValue = (String)this.userInfo.get(attrName);
            if (attrValue == null) {
                attrValue = "";
            }
            valueBuffer.replace(start, end, attrValue);
            searchIndex = start + attrValue.length() + 1;
            contentMatcher = ATTRIBUTE_PATTERN.matcher(valueBuffer);
        }
        return valueBuffer.toString();
    }

    public String[] getValues(String attribute, String[] def) {
        String sTemp = null;
        String[] values = this.portletPrefs.getValues(attribute, def);
        if (values == null) {
            return null;
        }
        String[] newValues = new String[values.length];
        for (int count = 0; count < values.length; ++count) {
            newValues[count] = sTemp = this.rewriteValue(values[count]);
        }
        return newValues;
    }

    public void setValue(String arg0, String arg1) throws ReadOnlyException {
        this.portletPrefs.setValue(arg0, arg1);
    }

    public void setValues(String arg0, String[] arg1) throws ReadOnlyException {
        this.portletPrefs.setValues(arg0, arg1);
    }

    public Enumeration getNames() {
        return this.portletPrefs.getNames();
    }

    public Map getMap() {
        return this.portletPrefs.getMap();
    }

    public void reset(String arg0) throws ReadOnlyException {
        this.portletPrefs.reset(arg0);
    }

    public void store() throws IOException, ValidatorException {
        this.portletPrefs.store();
    }
}

