/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.my.webproxy.portlet;

import edu.wisc.my.webproxy.beans.PortletPreferencesWrapper;
import edu.wisc.my.webproxy.beans.cache.CacheEntry;
import edu.wisc.my.webproxy.beans.cache.CacheWriter;
import edu.wisc.my.webproxy.beans.cache.PageCache;
import edu.wisc.my.webproxy.beans.config.CacheConfigImpl;
import edu.wisc.my.webproxy.beans.config.ConfigPage;
import edu.wisc.my.webproxy.beans.config.ConfigUtils;
import edu.wisc.my.webproxy.beans.config.GeneralConfigImpl;
import edu.wisc.my.webproxy.beans.config.HttpClientConfigImpl;
import edu.wisc.my.webproxy.beans.config.HttpHeaderConfigImpl;
import edu.wisc.my.webproxy.beans.config.StaticHtmlConfigImpl;
import edu.wisc.my.webproxy.beans.filtering.ChainingSaxFilter;
import edu.wisc.my.webproxy.beans.filtering.HtmlOutputFilter;
import edu.wisc.my.webproxy.beans.filtering.HtmlParser;
import edu.wisc.my.webproxy.beans.http.HttpManager;
import edu.wisc.my.webproxy.beans.http.HttpManagerService;
import edu.wisc.my.webproxy.beans.http.HttpTimeoutException;
import edu.wisc.my.webproxy.beans.http.IHeader;
import edu.wisc.my.webproxy.beans.http.IKeyManager;
import edu.wisc.my.webproxy.beans.http.ParameterPair;
import edu.wisc.my.webproxy.beans.http.Request;
import edu.wisc.my.webproxy.beans.http.Response;
import edu.wisc.my.webproxy.beans.interceptors.PostInterceptor;
import edu.wisc.my.webproxy.beans.interceptors.PreInterceptor;
import edu.wisc.my.webproxy.beans.security.CasAuthenticationHandler;
import edu.wisc.my.webproxy.portlet.ApplicationContextLocator;
import edu.wisc.my.webproxy.portlet.WebproxyConstants;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletResponse;
import javax.portlet.PortletSession;
import javax.portlet.ReadOnlyException;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ValidatorException;
import javax.portlet.WindowState;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.jasig.web.util.LRUTrackingModelPasser;
import org.jasig.web.util.ModelPasser;
import org.jasig.web.util.SecureSessionKeyGenerator;
import org.jasig.web.util.SessionKeyGenerator;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.context.request.WebRequestInterceptor;
import org.springframework.web.portlet.context.PortletApplicationContextUtils;
import org.springframework.web.portlet.context.PortletWebRequest;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class WebProxyPortlet
extends GenericPortlet {
    private static final Log LOG = LogFactory.getLog(WebProxyPortlet.class);
    private static final String HEADER = "/WEB-INF/jsp/header.jsp";
    private static final String FOOTER = "/WEB-INF/jsp/footer.jsp";
    private static final String MANUAL = "/WEB-INF/jsp/manual.jsp";
    public static final String preferenceKey = WebProxyPortlet.class.getName();
    private SessionKeyGenerator sessionKeyGenerator = new SecureSessionKeyGenerator();
    private ModelPasser modelPasser = new LRUTrackingModelPasser();
    private static WebProxyPortlet instance = null;
    private static final Pattern URL_WITH_PROTOCOL = Pattern.compile("[^:]*://.*");
    private static final Pattern URL_BASE = Pattern.compile("([^:]*://[^/]*).*");

    public static WebProxyPortlet getInstances() {
        return instance;
    }

    public void destroy() {
        super.destroy();
        instance = null;
    }

    public void init() throws PortletException {
        super.init();
        instance = this;
    }

    public void render(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        this.doDispatch(request, response);
    }

    public void doDispatch(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        ApplicationContext context = PortletApplicationContextUtils.getWebApplicationContext((PortletContext)this.getPortletContext());
        ApplicationContextLocator.setApplicationContext(context);
        WebRequestInterceptor interceptor = (WebRequestInterceptor)context.getBean("openEntityManagerInViewInterceptor", WebRequestInterceptor.class);
        PortletWebRequest webRequest = new PortletWebRequest((PortletRequest)request, (PortletResponse)response);
        Exception dispatchException = null;
        try {
            try {
                interceptor.preHandle((WebRequest)webRequest);
            }
            catch (Exception e) {
                throw new PortletException((Throwable)e);
            }
            PortletMode mode = request.getPortletMode();
            WindowState windowState = request.getWindowState();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Rendering with PortletMode='" + mode + "' and WindowState='" + windowState + "'"));
            }
            if (!windowState.equals((Object)WindowState.MINIMIZED)) {
                if (PortletMode.VIEW.equals((Object)mode) || PortletMode.EDIT.equals((Object)mode)) {
                    if (!this.manualLogin(request, response)) {
                        this.renderContent(request, response);
                    }
                } else if (WebproxyConstants.CONFIG_MODE.equals((Object)mode)) {
                    ConfigPage currentConfig = this.getConfig(request.getPortletSession());
                    PortletRequestDispatcher headerDispatch = this.getPortletContext().getRequestDispatcher(HEADER);
                    headerDispatch.include(request, response);
                    try {
                        currentConfig.render(this.getPortletContext(), request, response);
                    }
                    catch (PortletException pe) {
                        LOG.error((Object)"Caught an exception trying to retreive portlet preferences in configuration mode: ", (Throwable)pe);
                    }
                    PortletRequestDispatcher footerDispatch = this.getPortletContext().getRequestDispatcher(FOOTER);
                    footerDispatch.include(request, response);
                } else {
                    throw new PortletException("'" + mode + "' Not Implemented");
                }
            }
            try {
                interceptor.postHandle((WebRequest)webRequest, null);
            }
            catch (Exception e) {
                throw new PortletException((Throwable)e);
            }
        }
        catch (Exception e) {
            dispatchException = e;
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            if (e instanceof PortletException) {
                throw (PortletException)((Object)e);
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new PortletException((Throwable)e);
        }
        finally {
            ApplicationContextLocator.setApplicationContext(null);
            try {
                interceptor.afterCompletion((WebRequest)webRequest, dispatchException);
            }
            catch (Exception e1) {
                throw new PortletException((Throwable)e1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void renderContent(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        IKeyManager keyManager;
        String cacheKey;
        PageCache cache;
        CacheEntry cachedData;
        String sTemp;
        ApplicationContext context = PortletApplicationContextUtils.getWebApplicationContext((PortletContext)this.getPortletContext());
        ApplicationContextLocator.setApplicationContext(context);
        Map userInfo = (Map)request.getAttribute("javax.portlet.userinfo");
        PortletPreferences myPreferences = request.getPreferences();
        myPreferences = new PortletPreferencesWrapper(myPreferences, userInfo);
        PortletSession session = request.getPortletSession();
        String sUrl = (String)session.getAttribute(GeneralConfigImpl.BASE_URL);
        if (sUrl == null && (sUrl = ConfigUtils.checkEmptyNullString(myPreferences.getValue(GeneralConfigImpl.BASE_URL, null), null)) == null) {
            throw new PortletException("No Initial URL Configured");
        }
        PortletMode mode = request.getPortletMode();
        if (PortletMode.EDIT.equals((Object)mode) && (sTemp = myPreferences.getValue(GeneralConfigImpl.EDIT_URL, null)) != null) {
            sUrl = sTemp;
        }
        String sRequestType = request.getParameter(WebproxyConstants.REQUEST_TYPE) != null ? request.getParameter(WebproxyConstants.REQUEST_TYPE) : null;
        HttpManagerService findingService = (HttpManagerService)context.getBean("HttpManagerService", HttpManagerService.class);
        HttpManager httpManager = findingService.findManager((PortletRequest)request);
        httpManager.setRenderData(request, response);
        this.doFormAuth(httpManager, (PortletRequest)request);
        boolean sUseCache = new Boolean(myPreferences.getValue(CacheConfigImpl.USE_CACHE, null));
        if (sUseCache && (cachedData = (cache = (PageCache)context.getBean("PageCache", PageCache.class)).getCachedPage(cacheKey = (keyManager = (IKeyManager)context.getBean("keyManager", IKeyManager.class)).generateCacheKey(sUrl, (PortletRequest)request))) != null) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Using cached content for key '" + cacheKey + "'"));
            }
            response.setContentType(cachedData.getContentType());
            response.getWriter().write(cachedData.getContent());
            return;
        }
        Response httpResponse = null;
        boolean redirect = true;
        int maxRedirects = ConfigUtils.parseInt(myPreferences.getValue(HttpClientConfigImpl.MAX_REDIRECTS, null), 5);
        for (int index = 0; index < maxRedirects && redirect; ++index) {
            this.doHttpAuth((PortletRequest)request, httpManager);
            Request httpRequest = httpManager.createRequest();
            httpRequest.setUrl(sUrl);
            String[] headerNames = myPreferences.getValues(HttpHeaderConfigImpl.HEADER_NAME, new String[0]);
            String[] headerValues = myPreferences.getValues(HttpHeaderConfigImpl.HEADER_VALUE, new String[0]);
            if (headerNames.length == headerValues.length) {
                ArrayList<IHeader> headerList = new ArrayList<IHeader>(headerNames.length);
                for (int headerIndex = 0; headerIndex < headerNames.length; ++headerIndex) {
                    IHeader h = httpRequest.createHeader(headerNames[headerIndex], headerValues[headerIndex]);
                    headerList.add(h);
                }
                httpRequest.setHeaders(headerList.toArray(new IHeader[headerList.size()]));
            } else {
                LOG.error((Object)"Invalid data in preferences. Header name array length does not equal header value array length");
            }
            if (sRequestType == null) {
                httpRequest.setType("GET");
            } else {
                httpRequest.setType(sRequestType);
                if (sRequestType.equals("POST")) {
                    ArrayList<ParameterPair> postParameters = new ArrayList<ParameterPair>(request.getParameterMap().size());
                    Enumeration e = request.getParameterNames();
                    while (e.hasMoreElements()) {
                        String paramName = (String)e.nextElement();
                        if (paramName.startsWith("edu.wisc.my.webproxy.")) continue;
                        String[] values = request.getParameterValues(paramName);
                        for (int valIndex = 0; valIndex < values.length; ++valIndex) {
                            ParameterPair param = new ParameterPair(paramName, values[valIndex]);
                            postParameters.add(param);
                        }
                    }
                    ParameterPair[] params = postParameters.toArray(new ParameterPair[postParameters.size()]);
                    httpRequest.setParameters(params);
                }
            }
            String sPreInterceptor = ConfigUtils.checkEmptyNullString(myPreferences.getValue(GeneralConfigImpl.PRE_INTERCEPTOR_CLASS, null), null);
            if (sPreInterceptor != null) {
                String msg;
                try {
                    Class<?> preInterceptorClass = Class.forName(sPreInterceptor);
                    PreInterceptor myPreInterceptor = (PreInterceptor)preInterceptorClass.newInstance();
                    myPreInterceptor.intercept(request, response, httpRequest);
                }
                catch (ClassNotFoundException cnfe) {
                    msg = "Could not find specified pre-interceptor class '" + sPreInterceptor + "'";
                    LOG.error((Object)msg, (Throwable)cnfe);
                    throw new PortletException(msg, (Throwable)cnfe);
                }
                catch (InstantiationException ie) {
                    msg = "Could instatiate specified pre-interceptor class '" + sPreInterceptor + "'";
                    LOG.error((Object)msg, (Throwable)ie);
                    throw new PortletException(msg, (Throwable)ie);
                }
                catch (IllegalAccessException iae) {
                    msg = "Could instatiate specified pre-interceptor class '" + sPreInterceptor + "'";
                    LOG.error((Object)msg, (Throwable)iae);
                    throw new PortletException(msg, (Throwable)iae);
                }
                catch (ClassCastException cce) {
                    msg = "Could not cast '" + sPreInterceptor + "' to 'edu.wisc.my.webproxy.beans.interceptors.PreInterceptor'";
                    LOG.error((Object)msg, (Throwable)cce);
                    throw new PortletException(msg, (Throwable)cce);
                }
            }
            try {
                httpResponse = httpManager.doRequest(httpRequest);
            }
            catch (HttpTimeoutException hte) {
                boolean sUseExpired = new Boolean(myPreferences.getValue(CacheConfigImpl.USE_EXPIRED, null));
                if (sUseCache && sUseExpired) {
                    LOG.info((Object)("Request '" + sUrl + "' timed out. Attempting to use expired cache data."));
                    PageCache cache2 = (PageCache)context.getBean("PageCache", PageCache.class);
                    IKeyManager keyManager2 = (IKeyManager)context.getBean("keyManager", IKeyManager.class);
                    String cacheKey2 = keyManager2.generateCacheKey(sUrl, (PortletRequest)request);
                    CacheEntry cachedData2 = cache2.getCachedPage(cacheKey2, true);
                    if (cachedData2 != null) {
                        int retryDelay = ConfigUtils.parseInt(myPreferences.getValue(CacheConfigImpl.RETRY_DELAY, null), -1);
                        if (retryDelay > 0) {
                            boolean persistData = new Boolean(myPreferences.getValue(CacheConfigImpl.PERSIST_CACHE, null));
                            cachedData2.setExpirationDate(new Date(System.currentTimeMillis() + (long)(retryDelay * 1000)));
                            cache2.cachePage(cacheKey2, cachedData2, persistData);
                        }
                        if (LOG.isTraceEnabled()) {
                            LOG.trace((Object)("Using cached content for key '" + cacheKey2 + "'"));
                        }
                        response.setContentType(cachedData2.getContentType());
                        response.getWriter().write(cachedData2.getContent());
                        if (httpResponse == null) return;
                        httpResponse.close();
                        return;
                    }
                }
                LOG.warn((Object)("Request '" + httpRequest + "' timed out"), (Throwable)((Object)hte));
                throw hte;
            }
            session.setAttribute(HttpClientConfigImpl.SESSION_TIMEOUT, (Object)new Long(System.currentTimeMillis()));
            String sPostInterceptor = ConfigUtils.checkEmptyNullString(myPreferences.getValue(GeneralConfigImpl.POST_INTERCEPTOR_CLASS, null), null);
            if (sPostInterceptor != null) {
                String msg;
                try {
                    Class<?> postInterceptorClass = Class.forName(sPostInterceptor);
                    PostInterceptor myPostInterceptor = (PostInterceptor)postInterceptorClass.newInstance();
                    myPostInterceptor.intercept(request, response, httpResponse);
                }
                catch (ClassNotFoundException cnfe) {
                    msg = "Could not find specified post-interceptor class '" + sPostInterceptor + "'";
                    LOG.error((Object)msg, (Throwable)cnfe);
                    throw new PortletException(msg, (Throwable)cnfe);
                }
                catch (InstantiationException ie) {
                    msg = "Could instatiate specified post-interceptor class '" + sPostInterceptor + "'";
                    LOG.error((Object)msg, (Throwable)ie);
                    throw new PortletException(msg, (Throwable)ie);
                }
                catch (IllegalAccessException iae) {
                    msg = "Could instatiate specified post-interceptor class '" + sPostInterceptor + "'";
                    LOG.error((Object)msg, (Throwable)iae);
                    throw new PortletException(msg, (Throwable)iae);
                }
                catch (ClassCastException cce) {
                    msg = "Could not cast '" + sPostInterceptor + "' to 'edu.wisc.my.webproxy.beans.interceptors.PostInterceptor'";
                    LOG.error((Object)msg, (Throwable)cce);
                    throw new PortletException(msg, (Throwable)cce);
                }
            }
            findingService.saveHttpManager((PortletRequest)request, httpManager);
            String tempUrl = WebProxyPortlet.checkRedirect(sUrl, httpResponse);
            if (sUrl.equals(tempUrl)) {
                redirect = false;
                continue;
            }
            sUrl = tempUrl;
        }
        String realUrl = httpResponse.getRequestUrl();
        String sContentType = httpResponse.getContentType();
        if (sContentType != null) {
            StringTokenizer st = new StringTokenizer(sContentType, ";");
            sContentType = st.nextToken();
        } else {
            sContentType = "text/html";
        }
        if ("unknown".equals(sContentType)) {
            sContentType = "text/html";
        }
        List acceptedContent = (List)context.getBean("ContentTypeBean", List.class);
        boolean matches = false;
        Iterator iterateContent = acceptedContent.iterator();
        while (iterateContent.hasNext() && !matches) {
            String sAcceptedContent = (String)iterateContent.next();
            Pattern contentPattern = Pattern.compile(sAcceptedContent, 2);
            Matcher contentMatcher = contentPattern.matcher(sContentType);
            matches = contentMatcher.matches();
        }
        response.setContentType(sContentType);
        InputStream in = null;
        Writer out = null;
        try {
            String sHeader;
            in = httpResponse.getResponseBodyAsStream();
            out = response.getWriter();
            if (!matches) {
                return;
            }
            if (realUrl != null) {
                sUrl = realUrl;
            }
            session.setAttribute(GeneralConfigImpl.BASE_URL, (Object)sUrl);
            if (PortletMode.EDIT.equals((Object)mode)) {
                out.write(this.createBackButton(response));
            }
            if (sUseCache) {
                PageCache cache3 = (PageCache)context.getBean("PageCache", PageCache.class);
                IKeyManager keyManager3 = (IKeyManager)context.getBean("keyManager", IKeyManager.class);
                String cacheKey3 = keyManager3.generateCacheKey(sUrl, (PortletRequest)request);
                int cacheExprTime = ConfigUtils.parseInt(myPreferences.getValue(CacheConfigImpl.CACHE_TIMEOUT, null), -1);
                boolean persistData = new Boolean(myPreferences.getValue(CacheConfigImpl.PERSIST_CACHE, null));
                CacheEntry entryBase = new CacheEntry();
                entryBase.setContentType(sContentType);
                if (cacheExprTime >= 0) {
                    entryBase.setExpirationDate(new Date(System.currentTimeMillis() + (long)(cacheExprTime * 1000)));
                }
                out = new CacheWriter(out, entryBase, cache3, cacheKey3, persistData);
            }
            if ((sHeader = ConfigUtils.checkEmptyNullString(myPreferences.getValue(StaticHtmlConfigImpl.STATIC_HEADER, null), null)) != null) {
                out.write(sHeader);
            }
            HtmlParser htmlParser = (HtmlParser)context.getBean("HtmlParserBean", HtmlParser.class);
            HtmlOutputFilter outFilter = new HtmlOutputFilter(out);
            try {
                htmlParser.setRenderData(request, response);
                List saxFilters = (List)context.getBean("SaxFilterBean", List.class);
                ChainingSaxFilter parent = null;
                Iterator filterItr = saxFilters.iterator();
                if (filterItr.hasNext()) {
                    parent = (ChainingSaxFilter)filterItr.next();
                    outFilter.setParent(parent);
                    while (filterItr.hasNext()) {
                        ChainingSaxFilter nextParent = (ChainingSaxFilter)filterItr.next();
                        parent.setParent(nextParent);
                        parent = nextParent;
                    }
                }
                outFilter.setRenderData(request, response);
                XMLReader xmlReader = htmlParser.getReader(parent);
                parent.setParent(xmlReader);
                try {
                    outFilter.parse(new InputSource(in));
                }
                catch (SAXException se) {
                    throw new PortletException("A error occured while parsing the content", (Throwable)se);
                }
                String sFooter = ConfigUtils.checkEmptyNullString(myPreferences.getValue(StaticHtmlConfigImpl.STATIC_FOOTER, null), null);
                if (sFooter == null) return;
                out.write(sFooter);
                return;
            }
            finally {
                htmlParser.clearData();
                outFilter.clearData();
            }
        }
        finally {
            if (httpResponse != null) {
                httpResponse.close();
            }
        }
    }

    private String newGetUrl(String url, ActionRequest request) throws IOException {
        StringBuilder newUrl = new StringBuilder(url).append("?");
        Enumeration e = request.getParameterNames();
        while (e.hasMoreElements()) {
            String paramName = (String)e.nextElement();
            if (paramName.startsWith("edu.wisc.my.webproxy.")) continue;
            String[] values = request.getParameterValues(paramName);
            for (int valIndex = 0; valIndex < values.length; ++valIndex) {
                newUrl.append(URLEncoder.encode(paramName, "UTF-8")).append("=").append(URLEncoder.encode(values[valIndex], "UTF-8"));
                if (valIndex + 1 == values.length && !e.hasMoreElements()) continue;
                newUrl.append("&");
            }
        }
        return newUrl.toString();
    }

    private void doHttpAuth(PortletRequest portletRequest, HttpManager manager) {
        PortletPreferencesWrapper myPreferences = new PortletPreferencesWrapper(portletRequest.getPreferences(), (Map)portletRequest.getAttribute("javax.portlet.userinfo"));
        boolean authEnabled = new Boolean(myPreferences.getValue(HttpClientConfigImpl.AUTH_ENABLE, null));
        String authType = ConfigUtils.checkEmptyNullString(myPreferences.getValue(HttpClientConfigImpl.AUTH_TYPE, ""), "");
        if (authEnabled && "BASIC".equals(authType) || "NTLM".equals(authType)) {
            UsernamePasswordCredentials creds;
            String password;
            PortletSession session = portletRequest.getPortletSession();
            String userName = (String)session.getAttribute(HttpClientConfigImpl.USER_NAME);
            if (userName == null) {
                userName = myPreferences.getValue(HttpClientConfigImpl.USER_NAME, "");
            }
            if ((password = (String)session.getAttribute(HttpClientConfigImpl.PASSWORD)) == null) {
                password = myPreferences.getValue(HttpClientConfigImpl.PASSWORD, "");
            }
            if ("BASIC".equals(authType)) {
                creds = new UsernamePasswordCredentials(userName, password);
            } else {
                String domain = (String)session.getAttribute(HttpClientConfigImpl.DOMAIN);
                if (domain == null) {
                    domain = myPreferences.getValue(HttpClientConfigImpl.DOMAIN, "");
                }
                String host = portletRequest.getProperty("REMOTE_HOST");
                creds = new NTCredentials(userName, password, domain, host);
            }
            manager.setCredentials((Credentials)creds);
        }
    }

    private String doFormAuth(HttpManager httpManager, PortletRequest request) throws PortletException, IOException {
        PortletSession session = request.getPortletSession();
        PortletPreferencesWrapper prefs = new PortletPreferencesWrapper(request.getPreferences(), (Map)request.getAttribute("javax.portlet.userinfo"));
        boolean authEnabled = new Boolean(prefs.getValue(HttpClientConfigImpl.AUTH_ENABLE, null));
        String authType = ConfigUtils.checkEmptyNullString(prefs.getValue(HttpClientConfigImpl.AUTH_TYPE, ""), "");
        String sessionTimeoutStr = prefs.getValue(HttpClientConfigImpl.SESSION_TIMEOUT, null);
        long sessionTimeout = 25L;
        try {
            sessionTimeout = Long.parseLong(sessionTimeoutStr);
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        Long lastActivity = (Long)session.getAttribute(HttpClientConfigImpl.SESSION_TIMEOUT);
        boolean sessionExpired = lastActivity == null || lastActivity + (sessionTimeout *= 60000L) <= System.currentTimeMillis();
        if (authEnabled && sessionExpired && "FORM".equals(authType)) {
            ParameterPair pair;
            String value;
            String[] sStaticParameterNames = prefs.getValues(HttpClientConfigImpl.STATIC_PARAM_NAMES, new String[0]);
            String[] sStaticParameterValues = prefs.getValues(HttpClientConfigImpl.STATIC_PARAM_VALUES, new String[0]);
            String[] sDynamicParameterNames = prefs.getValues(HttpClientConfigImpl.DYNAMIC_PARAM_NAMES, new String[0]);
            String[] sDynamicParameterValues = new String[sDynamicParameterNames.length];
            String[] postAttributes = (String[])session.getAttribute(HttpClientConfigImpl.DYNAMIC_PARAM_VALUES);
            if (postAttributes != null) {
                for (int index = 0; index < postAttributes.length && index < sDynamicParameterValues.length; ++index) {
                    sDynamicParameterValues[index] = postAttributes[index];
                }
            }
            ArrayList<ParameterPair> sLoginAttributes = new ArrayList<ParameterPair>(sDynamicParameterNames.length + sStaticParameterNames.length);
            for (int dynamicIndex = 0; dynamicIndex < sDynamicParameterNames.length; ++dynamicIndex) {
                value = dynamicIndex < sDynamicParameterValues.length ? ConfigUtils.checkEmptyNullString(sDynamicParameterValues[dynamicIndex], "") : "";
                pair = new ParameterPair(sDynamicParameterNames[dynamicIndex], value);
                sLoginAttributes.add(pair);
            }
            for (int staticIndex = 0; staticIndex < sStaticParameterNames.length; ++staticIndex) {
                value = staticIndex < sStaticParameterValues.length ? ConfigUtils.checkEmptyNullString(sStaticParameterValues[staticIndex], "") : "";
                pair = new ParameterPair(sStaticParameterNames[staticIndex], value);
                sLoginAttributes.add(pair);
            }
            Request authPost = httpManager.createRequest();
            authPost.setType("POST");
            String authUrl = ConfigUtils.checkEmptyNullString(prefs.getValue(HttpClientConfigImpl.AUTH_URL, ""), "");
            authPost.setUrl(authUrl);
            authPost.setParameters(sLoginAttributes.toArray(new ParameterPair[sLoginAttributes.size()]));
            Response authResponse = httpManager.doRequest(authPost);
            session.setAttribute(HttpClientConfigImpl.SESSION_TIMEOUT, (Object)new Long(System.currentTimeMillis()));
            String redirUrl = WebProxyPortlet.checkRedirect(authUrl, authResponse);
            authResponse.close();
            if (!authUrl.equals(redirUrl)) {
                return redirUrl;
            }
            return null;
        }
        return null;
    }

    private boolean manualLogin(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        PortletSession session = request.getPortletSession();
        PortletPreferences myPreferences = request.getPreferences();
        boolean authEnabled = new Boolean(myPreferences.getValue(HttpClientConfigImpl.AUTH_ENABLE, null));
        if (authEnabled) {
            String authType = myPreferences.getValue(HttpClientConfigImpl.AUTH_TYPE, null);
            if ("BASIC".equals(authType)) {
                String password;
                boolean userNamePrompt = new Boolean(myPreferences.getValue(HttpClientConfigImpl.PROMPT_USER_NAME, null));
                boolean passwordPrompt = new Boolean(myPreferences.getValue(HttpClientConfigImpl.PROMPT_PASSWORD, null));
                String userName = (String)session.getAttribute(HttpClientConfigImpl.USER_NAME);
                if (userName == null) {
                    userName = myPreferences.getValue(HttpClientConfigImpl.USER_NAME, null);
                }
                if ((password = (String)session.getAttribute(HttpClientConfigImpl.PASSWORD)) == null) {
                    password = myPreferences.getValue(HttpClientConfigImpl.PASSWORD, null);
                }
                userName = ConfigUtils.checkEmptyNullString(userName, null);
                password = ConfigUtils.checkEmptyNullString(password, null);
                if (userNamePrompt && userName == null || passwordPrompt && password == null) {
                    PortletRequestDispatcher manualLoginDispatch = this.getPortletContext().getRequestDispatcher(MANUAL);
                    manualLoginDispatch.include(request, response);
                    return true;
                }
            } else if ("FORM".equals(authType)) {
                String[] dynamicParamNames = myPreferences.getValues(HttpClientConfigImpl.DYNAMIC_PARAM_NAMES, new String[0]);
                String[] dynamicParamValues = myPreferences.getValues(HttpClientConfigImpl.DYNAMIC_PARAM_VALUES, new String[dynamicParamNames.length]);
                String[] sessionDynamicParamValues = (String[])session.getAttribute(HttpClientConfigImpl.DYNAMIC_PARAM_VALUES);
                boolean emptyValue = false;
                for (int index = 0; index < dynamicParamValues.length; ++index) {
                    if (dynamicParamValues[index] == null && sessionDynamicParamValues != null && index < sessionDynamicParamValues.length) {
                        dynamicParamValues[index] = sessionDynamicParamValues[index];
                    }
                    if (dynamicParamValues[index] != null) continue;
                    emptyValue = true;
                }
                session.setAttribute(HttpClientConfigImpl.DYNAMIC_PARAM_VALUES, (Object)dynamicParamValues);
                if (emptyValue) {
                    PortletRequestDispatcher manualLoginDispatch = this.getPortletContext().getRequestDispatcher(MANUAL);
                    manualLoginDispatch.include(request, response);
                    return true;
                }
            } else if ("CAS".equals(authType)) {
                Map userInfo;
                String myProxyTicket;
                ApplicationContext context;
                CasAuthenticationHandler casHandler;
                String destination;
                Boolean authenticated = (Boolean)session.getAttribute("edu.wisc.my.webproxy.beans.security.CasAuthenticationHandler.CAS_AUTHENTICATED_SESSION_FLAG");
                if (authenticated != Boolean.TRUE && (destination = (casHandler = (CasAuthenticationHandler)(context = PortletApplicationContextUtils.getWebApplicationContext((PortletContext)this.getPortletContext())).getBean("casAuthenticationHandler")).authenticate((PortletRequest)request, myProxyTicket = (String)(userInfo = (Map)request.getAttribute("javax.portlet.userinfo")).get("casProxyTicket"))) != null) {
                    session.setAttribute(GeneralConfigImpl.BASE_URL, (Object)destination);
                    session.setAttribute("edu.wisc.my.webproxy.beans.security.CasAuthenticationHandler.CAS_AUTHENTICATED_SESSION_FLAG", (Object)Boolean.TRUE);
                }
            } else {
                return false;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processAction(ActionRequest request, ActionResponse response) throws PortletException, IOException {
        ApplicationContext context = PortletApplicationContextUtils.getWebApplicationContext((PortletContext)this.getPortletContext());
        WebRequestInterceptor interceptor = (WebRequestInterceptor)context.getBean("openEntityManagerInViewInterceptor", WebRequestInterceptor.class);
        PortletWebRequest webRequest = new PortletWebRequest((PortletRequest)request, (PortletResponse)response);
        try {
            interceptor.preHandle((WebRequest)webRequest);
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
        Exception dispatchException = null;
        try {
            PortletMode mode = request.getPortletMode();
            WindowState windowState = request.getWindowState();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Processing action with PortletMode='" + mode + "' and WindowState='" + windowState + "'"));
            }
            PortletSession session = request.getPortletSession();
            Map userInfo = (Map)request.getAttribute("javax.portlet.userinfo");
            PortletPreferencesWrapper pp = new PortletPreferencesWrapper(request.getPreferences(), userInfo);
            String manualAuthSubmit = request.getParameter("AUTH_CREDS");
            if (manualAuthSubmit != null) {
                this.processManualAuthForm(request);
            } else if (request.getPortletMode().equals((Object)PortletMode.EDIT)) {
                if (ConfigUtils.checkEmptyNullString(request.getParameter("backButton"), null) != null) {
                    response.setPortletMode(PortletMode.VIEW);
                }
            } else {
                ApplicationContextLocator.setApplicationContext(context);
                if (request.getPortletMode().equals((Object)WebproxyConstants.CONFIG_MODE)) {
                    this.processConfigAction(request, response);
                    return;
                }
                HttpManagerService findingService = (HttpManagerService)context.getBean("HttpManagerService", HttpManagerService.class);
                HttpManager httpManager = findingService.findManager((PortletRequest)request);
                httpManager.setActionData(request, response);
                if (request.getPortletMode().equals((Object)PortletMode.EDIT)) {
                    String sUrl = request.getParameter(GeneralConfigImpl.EDIT_URL);
                    session.setAttribute(GeneralConfigImpl.EDIT_URL, (Object)sUrl);
                    response.setPortletMode(PortletMode.VIEW);
                    return;
                }
                String sUrl = request.getParameter(WebproxyConstants.BASE_URL);
                String sRequestType = request.getProperty("REQUEST_METHOD");
                if (request.getParameter("edu.wisc.my.webproxy..getMethod") != null) {
                    sRequestType = "GET";
                    sUrl = this.newGetUrl(sUrl, request);
                }
                this.doFormAuth(httpManager, (PortletRequest)request);
                String sContentType = null;
                Response httpResponse = null;
                try {
                    boolean redirect = true;
                    int maxRedirects = ConfigUtils.parseInt(pp.getValue(HttpClientConfigImpl.MAX_REDIRECTS, null), 5);
                    for (int index = 0; index < maxRedirects && redirect; ++index) {
                        this.doHttpAuth((PortletRequest)request, httpManager);
                        Request httpRequest = httpManager.createRequest();
                        httpRequest.setUrl(sUrl);
                        httpRequest.setType("HEAD");
                        String[] headerNames = pp.getValues(HttpHeaderConfigImpl.HEADER_NAME, new String[0]);
                        String[] headerValues = pp.getValues(HttpHeaderConfigImpl.HEADER_VALUE, new String[0]);
                        if (headerNames.length == headerValues.length) {
                            ArrayList<IHeader> headerList = new ArrayList<IHeader>(headerNames.length);
                            for (int headerIndex = 0; headerIndex < headerNames.length; ++headerIndex) {
                                IHeader h = httpRequest.createHeader(headerNames[headerIndex], headerValues[headerIndex]);
                                headerList.add(h);
                            }
                            httpRequest.setHeaders(headerList.toArray(new IHeader[headerList.size()]));
                        } else {
                            LOG.error((Object)"Invalid data in preferences. Header name array length does not equal header value array length");
                        }
                        String sPreInterceptor = ConfigUtils.checkEmptyNullString(pp.getValue(GeneralConfigImpl.PRE_INTERCEPTOR_CLASS, null), null);
                        if (sPreInterceptor != null) {
                            String msg;
                            try {
                                Class<?> preInterceptorClass = Class.forName(sPreInterceptor);
                                PreInterceptor myPreInterceptor = (PreInterceptor)preInterceptorClass.newInstance();
                                myPreInterceptor.intercept(request, response, httpRequest);
                            }
                            catch (ClassNotFoundException cnfe) {
                                msg = "Could not find specified pre-interceptor class '" + sPreInterceptor + "'";
                                LOG.error((Object)msg, (Throwable)cnfe);
                                throw new PortletException(msg, (Throwable)cnfe);
                            }
                            catch (InstantiationException ie) {
                                msg = "Could instatiate specified pre-interceptor class '" + sPreInterceptor + "'";
                                LOG.error((Object)msg, (Throwable)ie);
                                throw new PortletException(msg, (Throwable)ie);
                            }
                            catch (IllegalAccessException iae) {
                                msg = "Could instatiate specified pre-interceptor class '" + sPreInterceptor + "'";
                                LOG.error((Object)msg, (Throwable)iae);
                                throw new PortletException(msg, (Throwable)iae);
                            }
                            catch (ClassCastException cce) {
                                msg = "Could not cast '" + sPreInterceptor + "' to 'edu.wisc.my.webproxy.beans.interceptors.PreInterceptor'";
                                LOG.error((Object)msg, (Throwable)cce);
                                throw new PortletException(msg, (Throwable)cce);
                            }
                        }
                        httpResponse = httpManager.doRequest(httpRequest);
                        session.setAttribute(HttpClientConfigImpl.SESSION_TIMEOUT, (Object)new Long(System.currentTimeMillis()));
                        String sPostInterceptor = ConfigUtils.checkEmptyNullString(pp.getValue(GeneralConfigImpl.POST_INTERCEPTOR_CLASS, null), null);
                        if (sPostInterceptor != null) {
                            String msg;
                            try {
                                Class<?> postInterceptorClass = Class.forName(sPostInterceptor);
                                PostInterceptor myPostInterceptor = (PostInterceptor)postInterceptorClass.newInstance();
                                myPostInterceptor.intercept(request, response, httpResponse);
                            }
                            catch (ClassNotFoundException cnfe) {
                                msg = "Could not find specified post-interceptor class '" + sPostInterceptor + "'";
                                LOG.error((Object)msg, (Throwable)cnfe);
                                throw new PortletException(msg, (Throwable)cnfe);
                            }
                            catch (InstantiationException ie) {
                                msg = "Could instatiate specified post-interceptor class '" + sPostInterceptor + "'";
                                LOG.error((Object)msg, (Throwable)ie);
                                throw new PortletException(msg, (Throwable)ie);
                            }
                            catch (IllegalAccessException iae) {
                                msg = "Could instatiate specified post-interceptor class '" + sPostInterceptor + "'";
                                LOG.error((Object)msg, (Throwable)iae);
                                throw new PortletException(msg, (Throwable)iae);
                            }
                            catch (ClassCastException cce) {
                                msg = "Could not cast '" + sPostInterceptor + "' to 'edu.wisc.my.webproxy.beans.interceptors.PostInterceptor'";
                                LOG.error((Object)msg, (Throwable)cce);
                                throw new PortletException(msg, (Throwable)cce);
                            }
                        }
                        findingService.saveHttpManager((PortletRequest)request, httpManager);
                        String tempUrl = WebProxyPortlet.checkRedirect(sUrl, httpResponse);
                        if (!tempUrl.equals(sUrl)) continue;
                        redirect = false;
                    }
                    if (httpResponse.getContentType() != null) {
                        StringTokenizer st = new StringTokenizer(httpResponse.getContentType(), ";");
                        sContentType = st.nextToken();
                    }
                }
                finally {
                    if (httpResponse != null) {
                        httpResponse.close();
                    }
                }
                boolean matches = false;
                if (sContentType != null) {
                    List acceptedContent = (List)context.getBean("ContentTypeBean", List.class);
                    String sAcceptedContent = null;
                    Iterator iterateContent = acceptedContent.iterator();
                    while (iterateContent.hasNext() && !matches) {
                        sAcceptedContent = (String)iterateContent.next();
                        Pattern contentPattern = Pattern.compile(sAcceptedContent, 2);
                        Matcher contentMatcher = contentPattern.matcher(sContentType);
                        if (!contentMatcher.matches()) continue;
                        matches = true;
                    }
                }
                if (!matches) {
                    int protocolEnd = sUrl.indexOf("//");
                    int queryStringStart = sUrl.indexOf("?");
                    int fileBaseStart = protocolEnd < 0 ? 0 : protocolEnd + 2;
                    int fileBaseEnd = queryStringStart < 0 ? sUrl.length() : queryStringStart;
                    String fileBase = sUrl.substring(fileBaseStart, fileBaseEnd);
                    LinkedHashMap<String, Object> model = new LinkedHashMap<String, Object>();
                    model.put(WebproxyConstants.REQUEST_TYPE, sRequestType);
                    model.put("url", sUrl);
                    if ("POST".equals(sRequestType)) {
                        model.put("POST_PARAMETERS", request.getParameterMap());
                    }
                    model.put(PortletPreferences.class.getName(), pp);
                    model.put("HTTP_MANAGER", httpManager);
                    IKeyManager keyManager = (IKeyManager)context.getBean("keyManager", IKeyManager.class);
                    model.put(IKeyManager.PORTLET_INSTANCE_KEY, keyManager.getInstanceKey((PortletRequest)request));
                    String sessionKey = this.sessionKeyGenerator.getNextSessionKey(session);
                    this.modelPasser.passModelToServlet(request, response, sessionKey, model);
                    StringBuilder servletUrl = new StringBuilder();
                    servletUrl.append(request.getContextPath());
                    servletUrl.append("/ProxyServlet/");
                    servletUrl.append(fileBase);
                    servletUrl.append("?");
                    servletUrl.append(URLEncoder.encode("SESSION_KEY", "UTF-8"));
                    servletUrl.append("=");
                    servletUrl.append(URLEncoder.encode(sessionKey, "UTF-8"));
                    response.sendRedirect(servletUrl.toString());
                    return;
                }
                Map params = request.getParameterMap();
                if (params != null) {
                    response.setRenderParameters(params);
                }
                response.setRenderParameter(WebproxyConstants.REQUEST_TYPE, sRequestType);
                response.setRenderParameter(GeneralConfigImpl.BASE_URL, sUrl);
                session.setAttribute(GeneralConfigImpl.BASE_URL, (Object)sUrl);
            }
            try {
                interceptor.postHandle((WebRequest)webRequest, null);
            }
            catch (Exception e) {
                throw new PortletException((Throwable)e);
            }
        }
        catch (Exception e) {
            dispatchException = e;
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            if (e instanceof PortletException) {
                throw (PortletException)((Object)e);
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new PortletException((Throwable)e);
        }
        finally {
            try {
                interceptor.afterCompletion((WebRequest)webRequest, dispatchException);
            }
            catch (Exception e) {
                throw new PortletException((Throwable)e);
            }
        }
    }

    private void processConfigAction(ActionRequest request, ActionResponse response) throws PortletException {
        PortletSession session = request.getPortletSession();
        Map userInfo = (Map)request.getAttribute("javax.portlet.userinfo");
        PortletPreferencesWrapper pp = new PortletPreferencesWrapper(request.getPreferences(), userInfo);
        if (request.getParameter("configPlacer") != null) {
            try {
                session.setAttribute("configPlacer", (Object)new Integer(request.getParameter("configPlacer")));
            }
            catch (NumberFormatException e) {
                LOG.error((Object)"Caught NumberFormatException when retrieving configuration page placer", (Throwable)e);
            }
        } else if (request.getParameter("cancel") != null) {
            response.setPortletMode(PortletMode.VIEW);
        } else {
            ConfigPage tempConfig = this.getConfig(session);
            Integer configPlacer = (Integer)session.getAttribute("configPlacer");
            boolean error = false;
            try {
                tempConfig.process(request, response);
            }
            catch (Exception e) {
                LOG.error((Object)new StringBuffer("Caught RuntimeException when calling action on ").append(tempConfig.getName()).toString(), (Throwable)e);
                response.setRenderParameter("msg", e.getMessage());
                error = true;
            }
            if (request.getParameter("next") != null) {
                if (!error) {
                    configPlacer = new Integer(configPlacer + 1);
                }
                session.setAttribute("configPlacer", (Object)configPlacer);
            } else if (request.getParameter("previous") != null) {
                if (!error) {
                    configPlacer = new Integer(configPlacer - 1);
                }
                session.setAttribute("configPlacer", (Object)configPlacer);
            } else if (request.getParameter("apply") != null) {
                response.setPortletMode(PortletMode.VIEW);
            } else {
                response.setRenderParameter("msg", "Thank you for submitting the parameters.");
                pp.reset("configPlacer");
                session.removeAttribute("configList");
            }
        }
    }

    private void processManualAuthForm(ActionRequest request) throws ReadOnlyException, IOException, ValidatorException {
        PortletSession session = request.getPortletSession();
        Map userInfo = (Map)request.getAttribute("javax.portlet.userinfo");
        PortletPreferencesWrapper pp = new PortletPreferencesWrapper(request.getPreferences(), userInfo);
        String authType = pp.getValue(HttpClientConfigImpl.AUTH_TYPE, null);
        if ("BASIC".equals(authType)) {
            String userName = ConfigUtils.checkEmptyNullString(request.getParameter(HttpClientConfigImpl.USER_NAME), "");
            String password = ConfigUtils.checkEmptyNullString(request.getParameter(HttpClientConfigImpl.PASSWORD), "");
            if (userName.length() > 0) {
                session.setAttribute(HttpClientConfigImpl.USER_NAME, (Object)userName);
                boolean userNamePersist = new Boolean(pp.getValue(HttpClientConfigImpl.PERSIST_USER_NAME, null));
                if (userNamePersist) {
                    pp.setValue(HttpClientConfigImpl.USER_NAME, userName);
                }
            }
            if (password.length() > 0) {
                session.setAttribute(HttpClientConfigImpl.PASSWORD, (Object)password);
                boolean passwordPersist = new Boolean(pp.getValue(HttpClientConfigImpl.PERSIST_PASSWORD, null));
                if (passwordPersist) {
                    pp.setValue(HttpClientConfigImpl.PASSWORD, password);
                }
            }
            pp.store();
        } else if ("FORM".equals(authType)) {
            String[] dynamicParamNames = pp.getValues(HttpClientConfigImpl.DYNAMIC_PARAM_NAMES, new String[0]);
            String[] dynamicParamValues = ConfigUtils.checkNullStringArray(request.getParameterValues(HttpClientConfigImpl.DYNAMIC_PARAM_VALUES), new String[0]);
            if (dynamicParamValues.length == dynamicParamNames.length) {
                dynamicParamValues = ConfigUtils.checkArrayForNulls(dynamicParamValues, "");
                session.setAttribute(HttpClientConfigImpl.DYNAMIC_PARAM_VALUES, (Object)dynamicParamValues);
                String[] persistedParamValues = new String[dynamicParamValues.length];
                String[] dynamicParamPersist = pp.getValues(HttpClientConfigImpl.DYNAMIC_PARAM_PERSIST, new String[0]);
                for (int index = 0; index < dynamicParamPersist.length; ++index) {
                    try {
                        int paramIndex = Integer.parseInt(dynamicParamPersist[index]);
                        persistedParamValues[paramIndex] = dynamicParamValues[paramIndex];
                        continue;
                    }
                    catch (NumberFormatException nfe) {
                        // empty catch block
                    }
                }
                pp.setValues(HttpClientConfigImpl.DYNAMIC_PARAM_VALUES, persistedParamValues);
                pp.store();
            } else {
                LOG.warn((Object)("Invalid data submitted during manual authentication prompt. dynamicParamNames.length='" + dynamicParamNames.length + "' != dynamicParamValues.length='" + dynamicParamValues.length + "'"));
            }
        } else {
            throw new IllegalArgumentException("Unknown authType specified '" + authType + "'");
        }
    }

    public static String checkRedirect(String sUrl, Response httpResponse) {
        int statusCode = httpResponse.getStatusCode();
        if (statusCode == 302 || statusCode == 301 || statusCode == 303 || statusCode == 307) {
            IHeader[] headers = httpResponse.getHeaders();
            for (int index = 0; index < headers.length; ++index) {
                String calculatedLocation;
                if (!"location".equalsIgnoreCase(headers[index].getName())) continue;
                String location = headers[index].getValue();
                if (location == null) {
                    calculatedLocation = sUrl;
                } else if (URL_WITH_PROTOCOL.matcher(location).matches()) {
                    calculatedLocation = location;
                } else if (location.startsWith("/")) {
                    Matcher matcher = URL_BASE.matcher(sUrl);
                    if (!matcher.matches()) {
                        throw new IllegalArgumentException("URL '" + sUrl + "' doesn't match regex: " + URL_BASE.pattern());
                    }
                    String sUrlBase = matcher.group(1);
                    calculatedLocation = sUrlBase + location;
                } else {
                    calculatedLocation = sUrl.substring(0, sUrl.lastIndexOf(47)) + "/" + location;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Handling " + statusCode + " redirect from '" + sUrl + "' to  '" + location + "'. Calculated redirect URL is: " + calculatedLocation));
                }
                return calculatedLocation;
            }
        }
        return sUrl;
    }

    private ConfigPage getConfig(PortletSession session) {
        ApplicationContext context = PortletApplicationContextUtils.getWebApplicationContext((PortletContext)this.getPortletContext());
        List configurationList = (List)context.getBean("ConfigBean", List.class);
        session.setAttribute("configList", (Object)configurationList);
        ConfigPage currentConfig = null;
        Integer configPlacer = null;
        configPlacer = (Integer)session.getAttribute("configPlacer");
        if (configPlacer == null) {
            configPlacer = new Integer(0);
        }
        currentConfig = (ConfigPage)configurationList.get(configPlacer);
        session.setAttribute("configPlacer", (Object)configPlacer);
        return currentConfig;
    }

    private String createBackButton(RenderResponse response) {
        StringBuilder backButton = new StringBuilder("<br><form name=\"back\" action=\"").append(response.createActionURL()).append(">\" method=\"post\"><input type=\"submit\" name=\"").append("backButton").append("\" value=\"Back to Application\"></form>");
        return backButton.toString();
    }
}

